/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.breakpoint.provider;

import com.ibm.icu.text.MessageFormat;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.breakpoint.provider.IPHPBreakpointProvider;
import org.eclipse.php.internal.ui.editor.input.IPlatformIndependentPathEditorInput;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.StatusLineMessageTimerManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPHPBreakpointProvider
implements IPHPBreakpointProvider,
IExecutableExtension {
    public IStatus addBreakpoint(IDocument document, IEditorInput input, int lineNumber, int offset) throws CoreException {
        int pos = DefaultPHPBreakpointProvider.getValidPosition(document, lineNumber);
        try {
            lineNumber = document.getLineOfOffset(pos) + 1;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return new Status(4, PHPDebugUIPlugin.getID(), "Invalid breakpoint");
        }
        Status status = null;
        IBreakpoint point = null;
        if (pos >= 0) {
            IStorage storage;
            IResource resource = this.getResourceFromInput(input);
            HashMap<String, String> attributes = new HashMap<String, String>();
            ISourceModule modelElement = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)input);
            if (modelElement != null) {
                attributes.put("location", modelElement.getPath().toString());
            }
            String secondaryId = null;
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)input;
                if (fileEditorInput.getFile().isLinked()) {
                    secondaryId = fileEditorInput.getFile().getRawLocation().toString();
                }
            } else if (input instanceof IURIEditorInput || input instanceof NonExistingPHPFileEditorInput) {
                secondaryId = input instanceof IPlatformIndependentPathEditorInput ? ((IPlatformIndependentPathEditorInput)input).getPath() : (input instanceof IURIEditorInput ? URIUtil.toPath((URI)((IURIEditorInput)input).getURI()).toOSString() : ((NonExistingPHPFileEditorInput)input).getPath((Object)input).toString());
            } else if (input instanceof IStorageEditorInput && (storage = ((IStorageEditorInput)input).getStorage()) instanceof IModelElement) {
                IModelElement element = (IModelElement)storage;
                secondaryId = EnvironmentPathUtils.getFile((IModelElement)element).getFullPath().toPortableString();
            }
            if (secondaryId != null) {
                attributes.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", secondaryId);
            }
            if (this.findBreakpointMarker(secondaryId, resource, lineNumber) == null) {
                point = this.createBreakpoint(input, resource, lineNumber, attributes);
            }
        }
        if (point == null) {
            this.showErrorMessage();
        }
        status = new Status(0, PHPDebugUIPlugin.getID(), 0, MessageFormat.format((String)PHPDebugUIMessages.BreakpointCreated_1, (Object[])new Object[0]), null);
        return status;
    }

    protected void showErrorMessage() {
        StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.ErrorCreatingBreakpoint_1, (long)1000L, (boolean)true);
    }

    protected IMarker findBreakpointMarker(String secondaryId, IResource resource, int lineNumber) throws CoreException {
        IMarker[] breakpoints;
        IMarker[] iMarkerArray = breakpoints = resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker breakpoint = iMarkerArray[n2];
            if (breakpoint.getAttribute("lineNumber").equals(new Integer(lineNumber)) && (secondaryId == null || secondaryId.equals(breakpoint.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path")))) {
                return breakpoint;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IBreakpoint createBreakpoint(IEditorInput input, IResource resource, int lineNumber, Map<String, String> attributes) throws CoreException {
        return new PHPConditionalBreakpoint(resource, lineNumber, attributes);
    }

    public IResource getResource(IEditorInput input) {
        return this.getResourceFromInput(input);
    }

    private IResource getResourceFromInput(IEditorInput input) {
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null || !resource.exists()) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public static int getValidPosition(IDocument idoc, int editorLineNumber) {
        int result = -1;
        if (idoc != null) {
            int startOffset = 0;
            int endOffset = 0;
            try {
                String partitionType = null;
                boolean phpPartitionVisited = false;
                do {
                    IRegion line = idoc.getLineInformation(editorLineNumber - 1);
                    startOffset = line.getOffset();
                    endOffset = Math.max(line.getOffset(), line.getOffset() + line.getLength());
                    ITypedRegion[] partitions = null;
                    partitions = idoc.computePartitioning(startOffset, endOffset - startOffset);
                    int i = 0;
                    while (i < partitions.length) {
                        partitionType = partitions[i].getType();
                        if (partitionType.equals("org.eclipse.php.PHP_DEFAULT")) {
                            phpPartitionVisited = true;
                            startOffset = partitions[i].getOffset();
                            String linePart = idoc.get(startOffset, partitions[i].getLength()).trim();
                            if (Pattern.matches(".*[a-zA-Z0-0_]+.*", linePart) && !linePart.trim().toLowerCase().equals("<?php")) {
                                result = startOffset;
                                break;
                            }
                        }
                        ++i;
                    }
                    ++editorLineNumber;
                } while ((!phpPartitionVisited || PHPStructuredTextPartitioner.isPHPPartitionType(partitionType)) && result == -1);
            }
            catch (BadLocationException badLocationException) {
                result = -1;
            }
        }
        return result;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools tools) {
    }
}

