/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.html.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseStatementInjector {
    private ScriptCompletionProposal proposal;

    public UseStatementInjector(ScriptCompletionProposal proposal) {
        this.proposal = proposal;
    }

    private Collection<Identifier> createIdentifiers(AST ast, String namespaceName) {
        String[] split = namespaceName.split("\\\\");
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            identifiers.add(ast.newIdentifier(s));
            ++n2;
        }
        return identifiers;
    }

    private NamespaceDeclaration getCurrentNamespace(Program program, int offset) {
        ASTNode node = program.getElementAt(offset);
        do {
            switch (node.getType()) {
                case 64: {
                    return (NamespaceDeclaration)node;
                }
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    private String getNamespaceName(NamespaceDeclaration namespaceDecl) {
        StringBuilder nameBuf = new StringBuilder();
        NamespaceName name = namespaceDecl.getName();
        if (name == null) {
            return "\\";
        }
        for (Identifier identifier : name.segments()) {
            if (nameBuf.length() > 0) {
                nameBuf.append('\\');
            }
            nameBuf.append(identifier.getName());
        }
        return nameBuf.toString();
    }

    private boolean needsAliasPrepend(IModelElement modelElement) throws ModelException {
        if (modelElement instanceof IMethod) {
            if (modelElement instanceof FakeConstructor) {
                return true;
            }
            IType declaringType = ((IMethod)modelElement).getDeclaringType();
            return declaringType == null || PHPFlags.isNamespace((int)declaringType.getFlags());
        }
        if (modelElement instanceof IField) {
            IField field = (IField)modelElement;
            if (!PHPFlags.isConstant((int)field.getFlags())) {
                return false;
            }
            IType declaringType = ((IField)modelElement).getDeclaringType();
            return declaringType == null || PHPFlags.isNamespace((int)declaringType.getFlags());
        }
        return true;
    }

    private String readNamespacePrefix(ISourceModule sourceModule, IDocument document, int offset, PHPVersion phpVersion) {
        IStructuredDocumentRegion sRegion;
        if (offset > 0) {
            --offset;
        }
        if ((sRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset)) != null) {
            ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
            IStructuredDocumentRegion container = sRegion;
            if (tRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
            }
            if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
                IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                try {
                    tRegion = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                int elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart();
                TextSequence statement = PHPTextSequenceUtilities.getStatement((int)(elementStart + tRegion.getLength()), (IStructuredDocumentRegion)sRegion, (boolean)true);
                int endPosition = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statement, (int)statement.length());
                int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((PHPVersion)phpVersion, (CharSequence)statement, (int)endPosition, (boolean)true);
                String elementName = statement.subSequence(startPosition, endPosition).toString();
                if (elementName.length() > 0) {
                    return PHPModelUtils.extractNamespaceName((String)elementName, (ISourceModule)sourceModule, (int)offset);
                }
            }
        }
        return null;
    }

    public int inject(IDocument document, ITextViewer textViewer, int offset) {
        IModelElement editorElement;
        ITextEditor textEditor;
        IModelElement modelElement = this.proposal.getModelElement();
        if (modelElement == null) {
            return offset;
        }
        try {
            IModelElement type;
            if (modelElement.getElementType() == 7 && PHPFlags.isNamespace((int)((IType)modelElement).getFlags())) {
                return offset;
            }
            if (offset - this.proposal.getReplacementLength() > 0 && document.getChar(offset - this.proposal.getReplacementLength() - 1) == '\\') {
                return offset;
            }
            if (modelElement.getElementType() != 7 && !(modelElement instanceof FakeConstructor) && (type = modelElement.getAncestor(7)) != null && !PHPFlags.isNamespace((int)((IType)type).getFlags())) {
                return offset;
            }
        }
        catch (ModelException e) {
            Logger.logException((Throwable)e);
        }
        catch (BadLocationException e) {
            Logger.logException((Throwable)e);
        }
        IType namespace = PHPModelUtils.getCurrentNamespace((IModelElement)modelElement);
        if (namespace != null && textViewer instanceof PHPStructuredTextViewer && (textEditor = ((PHPStructuredTextViewer)textViewer).getTextEditor()) instanceof PHPStructuredEditor && (editorElement = ((PHPStructuredEditor)textEditor).getModelElement()) != null) {
            ISourceModule sourceModule = ((ModelElement)editorElement).getSourceModule();
            try {
                boolean useAlias;
                String namespaceName;
                String usePartName = namespaceName = namespace.getElementName();
                boolean bl = useAlias = !Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistInsertFullyQualifiedNameForNamespaceCheckBox", true, null);
                if (!useAlias) {
                    usePartName = String.valueOf(usePartName) + '\\' + modelElement.getElementName();
                }
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                TextEdit edits = null;
                UsePart usePart = ASTUtils.findUseStatementByNamespace((ModuleDeclaration)moduleDeclaration, (String)usePartName, (int)offset);
                if (usePart == null) {
                    ASTParser parser = ASTParser.newParser((ISourceModule)sourceModule);
                    parser.setSource(document.get().toCharArray());
                    Program program = parser.createAST(null);
                    program.recordModifications();
                    AST ast = program.getAST();
                    NamespaceName newNamespaceName = ast.newNamespaceName(this.createIdentifiers(ast, usePartName), false, false);
                    UseStatementPart newUseStatementPart = ast.newUseStatementPart(newNamespaceName, null);
                    UseStatement newUseStatement = ast.newUseStatement(Arrays.asList(newUseStatementPart));
                    NamespaceDeclaration currentNamespace = this.getCurrentNamespace(program, offset - 1);
                    if (currentNamespace != null) {
                        if (namespaceName.equals(this.getNamespaceName(currentNamespace))) {
                            return offset;
                        }
                        currentNamespace.getBody().statements().add(0, newUseStatement);
                    } else {
                        program.statements().add(0, newUseStatement);
                    }
                    HashMap<String, String> options = new HashMap<String, String>(PHPCorePlugin.getOptions());
                    IScopeContext[] contents = new IScopeContext[]{new ProjectScope(modelElement.getScriptProject().getProject()), new InstanceScope(), new DefaultScope()};
                    int i = 0;
                    while (i < contents.length) {
                        IScopeContext scopeContext = contents[i];
                        IEclipsePreferences node = scopeContext.getNode("org.eclipse.php.core");
                        if (node != null) {
                            String size;
                            String useTabs;
                            if (!options.containsKey("org.eclipse.php.core.phpForamtterUseTabs") && (useTabs = node.get("org.eclipse.php.core.phpForamtterUseTabs", null)) != null) {
                                options.put("org.eclipse.php.core.phpForamtterUseTabs", useTabs);
                            }
                            if (!options.containsKey("org.eclipse.php.core.phpForamtterIndentationSize") && (size = node.get("org.eclipse.php.core.phpForamtterIndentationSize", null)) != null) {
                                options.put("org.eclipse.php.core.phpForamtterIndentationSize", size);
                            }
                        }
                        ++i;
                    }
                    edits = program.rewrite(document, options);
                    edits.apply(document);
                }
                if (useAlias && this.needsAliasPrepend(modelElement)) {
                    String alias;
                    if (usePart != null && usePart.getAlias() != null && usePart.getAlias().getName() != null) {
                        alias = usePart.getAlias().getName();
                    } else {
                        int i = usePartName.lastIndexOf(92);
                        alias = usePartName;
                        if (i != -1) {
                            alias = usePartName.substring(i + 1);
                        }
                    }
                    String namespacePrefix = String.valueOf(alias) + '\\';
                    String replacementString = this.proposal.getReplacementString();
                    String existingNamespacePrefix = this.readNamespacePrefix(sourceModule, document, offset, ProjectOptions.getPhpVersion((IModelElement)editorElement));
                    if (!usePartName.equals(existingNamespacePrefix)) {
                        replacementString = String.valueOf(namespacePrefix) + replacementString;
                    }
                    this.proposal.setReplacementString(replacementString);
                }
                if (edits != null) {
                    int replacementOffset = this.proposal.getReplacementOffset() + edits.getLength();
                    offset += edits.getLength();
                    this.proposal.setReplacementOffset(replacementOffset);
                }
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
            }
        }
        return offset;
    }
}

