/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.dialogs.saveFiles.SaveAsDialog;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class UntitledPHPEditor
extends PHPStructuredEditor {
    public static final String ID = "org.eclipse.php.untitledPhpEditor";

    public void doSave(IProgressMonitor progressMonitor) {
        this.performSaveAs(progressMonitor);
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        IFile file;
        block21: {
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            IDocumentProvider provider = this.getDocumentProvider();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            dialog.setOriginalName(input.getName());
            dialog.create();
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath newPath = dialog.getResult();
            if (newPath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            file = workspace.getRoot().getFile(newPath);
            FileEditorInput newInput = new FileEditorInput(file);
            if (provider == null) {
                return;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                    success = true;
                }
                catch (CoreException x) {
                    Logger.logException(x);
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        String title = PHPUIMessages.UntitledPHPEditor_saveError;
                        String msg = NLSUtility.format((String)PHPUIMessages.UntitledPHPEditor_documentCannotBeSaved, (Object)x.getMessage());
                        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    }
                    this.close(false);
                    try {
                        IWorkbenchPage p = DLTKUIPlugin.getActivePage();
                        if (p != null) {
                            IDE.openEditor((IWorkbenchPage)p, (IEditorInput)newInput, (String)"org.eclipse.php.editor");
                        }
                        break block21;
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                this.close(false);
                try {
                    IWorkbenchPage p = DLTKUIPlugin.getActivePage();
                    if (p != null) {
                        IDE.openEditor((IWorkbenchPage)p, (IEditorInput)newInput, (String)"org.eclipse.php.editor");
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
                throw throwable;
            }
            this.close(false);
            try {
                IWorkbenchPage p = DLTKUIPlugin.getActivePage();
                if (p != null) {
                    IDE.openEditor((IWorkbenchPage)p, (IEditorInput)newInput, (String)"org.eclipse.php.editor");
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        this.deleteUntitledStorageFile(file);
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public void dispose() {
        this.deleteUntitledStorageFile(null);
        super.dispose();
    }

    private void deleteUntitledStorageFile(IFile newFile) {
        IPath oldPath = ((NonExistingPHPFileEditorInput)this.getEditorInput()).getPath(this.getEditorInput());
        File oldFile = new File(oldPath.toOSString());
        if (oldFile.exists() && oldFile.canWrite() && !oldFile.delete()) {
            Logger.log(2, PHPUIMessages.UntitledPHPEditor_deleteFailed);
        }
        NonExistingPHPFileEditorInput.dispose(oldPath);
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] markers = resource.findMarkers(null, true, 0);
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName;
                IMarker marker = iMarkerArray[n2];
                String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
                if (markerType != null && (fileName = (String)marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path")) != null && new File(fileName).equals(oldFile)) {
                    IBreakpoint breakpoint = breakpointManager.getBreakpoint(marker);
                    if (breakpoint != null) {
                        if (newFile != null) {
                            IMarker createdMarker = newFile.createMarker(markerType);
                            createdMarker.setAttributes(breakpoint.getMarker().getAttributes());
                            breakpointManager.removeBreakpoint(breakpoint, true);
                            breakpoint.setMarker(createdMarker);
                            breakpointManager.addBreakpoint(breakpoint);
                        } else {
                            breakpointManager.removeBreakpoint(breakpoint, true);
                        }
                    } else if (newFile != null) {
                        MarkerUtilities.createMarker((IResource)newFile, (Map)marker.getAttributes(), (String)markerType);
                    }
                }
                marker.delete();
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }
}

