/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dnd;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.ui.dnd.ExternalFileDropAdapter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.WorkbenchPage;

public class DNDUtils {
    private static final String DROP_TARGET_ID = "DropTarget";
    private static final IWindowListener WINDOW_LISTENER = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            DNDUtils.windowEnableExternalDrop(window);
        }
    };
    private static final IPageListener PAGE_LISTENER = new IPageListener(){

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
        }

        public void pageOpened(IWorkbenchPage page) {
            DNDUtils.pageEnableExternalDrop(page);
        }
    };
    private static final IPropertyChangeListener PART_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
        }
    };

    public static void initEditorSiteExternalDrop() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            DNDUtils.windowEnableExternalDrop(window);
        }
        PlatformUI.getWorkbench().addWindowListener(WINDOW_LISTENER);
    }

    public static void windowEnableExternalDrop(IWorkbenchWindow window) {
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            DNDUtils.pageEnableExternalDrop(activePage);
        }
        window.addPageListener(PAGE_LISTENER);
    }

    public static void pageEnableExternalDrop(IWorkbenchPage activePage) {
        Control[] children = ((WorkbenchPage)activePage).getClientComposite().getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                Control[] subChildren = ((Composite)children[i]).getChildren();
                int j = 0;
                while (j < subChildren.length) {
                    Object data;
                    if (subChildren[j] instanceof CTabFolder && (data = ((CTabFolder)subChildren[j]).getData()) instanceof EditorStack) {
                        DNDUtils.enableExternalDrop(subChildren[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        activePage.addPropertyChangeListener(PART_LISTENER);
    }

    public static void enableExternalDrop(Control control) {
        if (control.getData(DROP_TARGET_ID) != null) {
            return;
        }
        DropTarget target = new DropTarget(control, 1);
        ExternalFileDropAdapter transferDropAdapter = ExternalFileDropAdapter.getInstance();
        target.setTransfer(new Transfer[]{transferDropAdapter.getTransfer()});
        target.addDropListener((DropTargetListener)transferDropAdapter);
        target.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DNDUtils.initEditorSiteExternalDrop();
            }
        });
    }
}

