/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.osgi.framework.Bundle;

public class PhpDemoProject {
    private static final String SRC_FOLDER = "src/";
    private static final String FILES_PATH = "/resources/phpdemo/";
    private static final String TEST_PROJECT_NAME = "PHPDemo";
    private static final String FILE_NAME1 = "01-Visibility1.php";
    private static final String FILE_NAME2 = "02-Visibility2.php";
    private static final String FILE_NAME3 = "03-html.php";
    private static final String FILE_NAME5 = "05-Inherit.php";
    private static final String FILE_NAME6 = "06-FunctionParameter.php";
    private static final String FILE_NAME7 = "07-ClassExtension.php";
    private static final String FILE_NAME8 = "08-MemberReference.php";
    private static final String FILE_NAME9 = "09-Including.php";
    private static final String FILE_NAME10 = "Employee.php";
    private static final String FILE_NAME11 = "Manager.php";
    private static final String FILE_NAME12 = "Person.php";
    private static final String SRC_FILE_NAME1 = "01-included.php";

    public static void run() {
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
        if (testProject.exists()) {
            return;
        }
        try {
            testProject.create(null);
            testProject.open(null);
            PhpDemoProject.providePhpNatureToProject(testProject);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME1);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME2);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME3);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME5);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME6);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME7);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME8);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME9);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME10);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME11);
            PhpDemoProject.createFile(testProject, FILES_PATH, FILE_NAME12);
            PhpDemoProject.createFolder(testProject, FILES_PATH, SRC_FOLDER);
            PhpDemoProject.createFile(testProject, FILES_PATH, "src/01-included.php");
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private static IFile createFile(IProject testProject, String filePath, String fileName) throws IOException, CoreException {
        URL demoFileURL = FileLocator.find((Bundle)Platform.getBundle((String)PHPUiPlugin.getPluginId()), (IPath)new Path(String.valueOf(filePath) + fileName), null);
        demoFileURL = FileLocator.resolve((URL)demoFileURL);
        IPath p = testProject.getFullPath();
        p = p.append(fileName);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(p);
        InputStream inputStream = (InputStream)demoFileURL.getContent();
        file.create(inputStream, true, null);
        return file;
    }

    private static IFolder createFolder(IProject testProject, String filePath, String folderName) throws IOException, CoreException {
        URL demoFileURL = FileLocator.find((Bundle)Platform.getBundle((String)PHPUiPlugin.getPluginId()), (IPath)new Path(String.valueOf(filePath) + folderName), null);
        demoFileURL = FileLocator.resolve((URL)demoFileURL);
        IPath p = testProject.getFullPath();
        p = p.append(folderName);
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(p);
        folder.create(true, true, null);
        return folder;
    }

    private static void providePhpNatureToProject(IProject project) throws ExecutionException {
        try {
            IProjectDescription desc = null;
            String[] natureIds = new String[]{"org.eclipse.php.core.PHPNature"};
            desc = project.getDescription();
            desc.setNatureIds(natureIds);
            project.setDescription(desc, null);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }
}

