/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.typeinference.ArrayDeclaration;
import org.eclipse.php.internal.core.typeinference.Declaration;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.VariableDeclarationSearcher;
import org.eclipse.php.internal.core.typeinference.context.FileContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.goals.ArrayDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.ForeachStatementGoal;
import org.eclipse.php.internal.core.typeinference.goals.GlobalVariableReferencesGoal;

public class VariableReferenceEvaluator
extends GoalEvaluator {
    private List<IEvaluatedType> results = new ArrayList<IEvaluatedType>();

    public VariableReferenceEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        block17: {
            VariableReference variableReference = (VariableReference)((ExpressionTypeGoal)this.goal).getExpression();
            IContext context = this.goal.getContext();
            if (variableReference.getName().equals("$this") && context instanceof MethodContext) {
                MethodContext methodContext = (MethodContext)context;
                IEvaluatedType instanceType = methodContext.getInstanceType();
                if (instanceType != null) {
                    this.results.add(instanceType);
                } else {
                    this.results.add((IEvaluatedType)new SimpleType(8));
                }
                return IGoal.NO_GOALS;
            }
            try {
                if (context instanceof ISourceModuleContext) {
                    ModuleDeclaration rootNode;
                    ISourceModuleContext typedContext = (ISourceModuleContext)context;
                    ModuleDeclaration localScopeNode = rootNode = typedContext.getRootNode();
                    if (context instanceof MethodContext) {
                        localScopeNode = ((MethodContext)context).getMethodNode();
                    }
                    LocalReferenceDeclSearcher varDecSearcher = new LocalReferenceDeclSearcher(typedContext.getSourceModule(), variableReference, (ASTNode)localScopeNode);
                    rootNode.traverse((ASTVisitor)varDecSearcher);
                    LinkedList<Object> subGoals = new LinkedList<Object>();
                    List<VarComment> varComments = ((PHPModuleDeclaration)rootNode).getVarComments();
                    for (VarComment varComment : varComments) {
                        if (varComment.sourceStart() > variableReference.sourceStart()) break;
                        if (!varComment.getVariableReference().getName().equals(variableReference.getName())) continue;
                        LinkedList<ExpressionTypeGoal> goals = new LinkedList<ExpressionTypeGoal>();
                        TypeReference[] typeReferenceArray = varComment.getTypeReferences();
                        int n = typeReferenceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TypeReference ref = typeReferenceArray[n2];
                            goals.add(new ExpressionTypeGoal(context, (ASTNode)ref));
                            ++n2;
                        }
                        return goals.toArray(new IGoal[goals.size()]);
                    }
                    Declaration[] decls = varDecSearcher.getDeclarations();
                    boolean mergeWithGlobalScope = false;
                    int i = 0;
                    while (i < decls.length) {
                        Declaration decl = decls[i];
                        if (decl instanceof ArrayDeclaration) {
                            ArrayDeclaration arrayDeclaration = (ArrayDeclaration)decl;
                            subGoals.add((Object)new ArrayDeclarationGoal(context, arrayDeclaration));
                        } else if (decl.getNode() instanceof GlobalStatement) {
                            mergeWithGlobalScope = true;
                        } else {
                            ASTNode declNode = decl.getNode();
                            if (declNode instanceof ForEachStatement) {
                                subGoals.add((Object)new ForeachStatementGoal(context, ((ForEachStatement)declNode).getExpression()));
                            } else {
                                subGoals.add(new ExpressionTypeGoal(context, declNode));
                            }
                        }
                        ++i;
                    }
                    if (mergeWithGlobalScope || decls.length == 0 && context.getClass() == FileContext.class) {
                        subGoals.add((Object)new GlobalVariableReferencesGoal(context, variableReference.getName()));
                    }
                    return subGoals.toArray(new IGoal[subGoals.size()]);
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block17;
                e.printStackTrace();
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.results);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.results.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    public static class LocalReferenceDeclSearcher
    extends VariableDeclarationSearcher {
        private final String variableName;
        private final int variableOffset;
        private final ASTNode localScopeNode;
        private IContext variableContext;
        private int variableLevel;

        public LocalReferenceDeclSearcher(ISourceModule sourceModule, VariableReference variableReference, ASTNode localScopeNode) {
            super(sourceModule);
            this.variableName = variableReference.getName();
            this.variableOffset = variableReference.sourceStart();
            this.localScopeNode = localScopeNode;
        }

        public Declaration[] getDeclarations() {
            Declaration[] declarations = this.getScope(this.variableContext).getDeclarations(this.variableName);
            if (this.variableLevel > 0 && this.variableLevel < declarations.length) {
                Declaration[] newDecls = new Declaration[declarations.length - this.variableLevel];
                System.arraycopy(declarations, this.variableLevel, newDecls, 0, newDecls.length);
                declarations = newDecls;
            }
            LinkedList<Declaration> filteredDecls = new LinkedList<Declaration>();
            Declaration[] declarationArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                Declaration decl = declarationArray[n2];
                if (decl.getNode().sourceStart() > this.localScopeNode.sourceStart()) {
                    filteredDecls.add(decl);
                }
                ++n2;
            }
            return filteredDecls.toArray(new Declaration[filteredDecls.size()]);
        }

        protected void postProcess(Expression node) {
            VariableReference varReference;
            InstanceOfExpression expr;
            if (node instanceof InstanceOfExpression && (expr = (InstanceOfExpression)node).getExpr() instanceof VariableReference && this.variableName.equals((varReference = (VariableReference)expr.getExpr()).getName())) {
                this.getScope().addDeclaration(this.variableName, (ASTNode)expr.getClassName());
            }
        }

        protected void postProcessGeneral(ASTNode node) {
            if (node.sourceStart() <= this.variableOffset && node.sourceEnd() >= this.variableOffset) {
                this.variableContext = (IContext)this.contextStack.peek();
                this.variableLevel = this.getScope(this.variableContext).getInnerBlockLevel();
            }
        }

        protected void postProcess(Statement node) {
        }

        protected boolean isInteresting(ASTNode node) {
            return node.sourceStart() <= this.variableOffset;
        }
    }
}

