/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.context;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.context.FileContext;
import org.eclipse.php.internal.core.typeinference.context.INamespaceContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;

public abstract class ContextFinder
extends ASTVisitor {
    protected Stack<IContext> contextStack = new Stack();
    private ISourceModule sourceModule;

    public ContextFinder(ISourceModule sourceModule) {
        this.sourceModule = sourceModule;
    }

    public IContext getContext() {
        return null;
    }

    public boolean visit(ModuleDeclaration node) throws Exception {
        this.contextStack.push((IContext)new FileContext(this.sourceModule, node));
        boolean visitGeneral = this.visitGeneral((ASTNode)node);
        if (!visitGeneral) {
            this.contextStack.pop();
        }
        return visitGeneral;
    }

    public boolean visit(TypeDeclaration node) throws Exception {
        if (node instanceof NamespaceDeclaration) {
            if (!((NamespaceDeclaration)node).isGlobal()) {
                FileContext fileContext = (FileContext)this.contextStack.peek();
                fileContext.setNamespace(node.getName());
            }
        } else {
            ISourceModuleContext parentContext = (ISourceModuleContext)this.contextStack.peek();
            PHPClassType instanceType = parentContext instanceof INamespaceContext && ((INamespaceContext)parentContext).getNamespace() != null ? new PHPClassType(((INamespaceContext)parentContext).getNamespace(), node.getName()) : new PHPClassType(node.getName());
            this.contextStack.push((IContext)new TypeContext(parentContext, (IEvaluatedType)instanceType));
            boolean visitGeneral = this.visitGeneral((ASTNode)node);
            if (!visitGeneral) {
                this.contextStack.pop();
            }
            return visitGeneral;
        }
        return this.visitGeneral((ASTNode)node);
    }

    public boolean visit(MethodDeclaration node) throws Exception {
        LinkedList<String> argumentsList = new LinkedList<String>();
        LinkedList<IEvaluatedType> argTypes = new LinkedList<IEvaluatedType>();
        List args = node.getArguments();
        for (Argument a2 : args) {
            argumentsList.add(a2.getName());
            argTypes.add(UnknownType.INSTANCE);
        }
        IContext parent = this.contextStack.peek();
        ModuleDeclaration rootNode = ((ISourceModuleContext)parent).getRootNode();
        this.contextStack.push(new MethodContext(parent, this.sourceModule, rootNode, node, argumentsList.toArray(new String[argumentsList.size()]), argTypes.toArray(new IEvaluatedType[argTypes.size()])));
        boolean visitGeneral = this.visitGeneral((ASTNode)node);
        if (!visitGeneral) {
            this.contextStack.pop();
        }
        return visitGeneral;
    }

    public boolean endvisit(ModuleDeclaration node) throws Exception {
        this.contextStack.pop();
        this.endvisitGeneral((ASTNode)node);
        return true;
    }

    public boolean endvisit(TypeDeclaration node) throws Exception {
        if (!(node instanceof NamespaceDeclaration)) {
            this.contextStack.pop();
        }
        this.endvisitGeneral((ASTNode)node);
        return true;
    }

    public boolean endvisit(MethodDeclaration node) throws Exception {
        this.contextStack.pop();
        this.endvisitGeneral((ASTNode)node);
        return true;
    }
}

