/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.LinkedList;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.php.internal.core.compiler.ast.nodes.Comment;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;

public class PHPDocBlock
extends Comment {
    private String shortDescription;
    private PHPDocTag[] tags;

    public PHPDocBlock(int start, int end, String shortDescription, PHPDocTag[] tags) {
        super(start, end, 2);
        this.shortDescription = shortDescription;
        this.tags = tags;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((ASTNode)this);
        if (visit) {
            PHPDocTag[] pHPDocTagArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                tag.traverse(visitor);
                ++n2;
            }
        }
        visitor.endvisit((ASTNode)this);
    }

    public int getKind() {
        return 67;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public PHPDocTag[] getTags() {
        return this.tags;
    }

    public PHPDocTag[] getTags(int kind) {
        LinkedList<PHPDocTag> res = new LinkedList<PHPDocTag>();
        if (this.tags != null) {
            PHPDocTag[] pHPDocTagArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                if (tag.getTagKind() == kind) {
                    res.add(tag);
                }
                ++n2;
            }
        }
        return res.toArray(new PHPDocTag[res.size()]);
    }

    public void adjustStart(int start) {
        this.setStart(this.sourceStart() + start);
        this.setEnd(this.sourceEnd() + start);
        PHPDocTag[] pHPDocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag tag = pHPDocTagArray[n2];
            tag.adjustStart(start);
            ++n2;
        }
    }
}

