package jp.sourceforge.pdt_tools.codeChecker.visitor;

import jp.sourceforge.pdt_tools.codeChecker.CodeCheckerOptions;
import jp.sourceforge.pdt_tools.codeChecker.CodeCheckerPlugin;

import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.core.ISourceModule;

public class Options {

	// -- code style
	protected int static_access_receiver;
	protected int non_static_method;

	// -- potential programming problems
	protected int unresolved_types;
	protected int unresolved_methods;
	protected int unresolved_fields;
	protected int unresolved_functions;
	protected int redeclared_types;
	protected int redeclared_methods;
	protected int redeclared_fields;
	protected int redeclared_functions;
	protected int fall_through_case;
	protected int missing_arguments;
	protected int incompatible_method;
	protected int override_final_method;
	protected int include_not_found;
	protected int uninitialized_variable;
	protected int misc_compile_error;
	protected int misc_error;
	protected int misc_warning;
	protected int misc_strict;

	// -- deprecation
	protected int deprecation;

	// -- unnecessary code
	protected int unused_local;
	protected int unused_parameter;
	protected int unused_private;

	public Options(ISourceModule sourceModule) {
		IProject project = sourceModule.getScriptProject().getProject();
		PreferencesService service = PreferencesService.getDefault();
		IScopeContext[] contexts = (project != null) ? new IScopeContext[] {
				new ProjectScope(project), InstanceScope.INSTANCE }
				: new IScopeContext[] { InstanceScope.INSTANCE };

		static_access_receiver = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_STATIC_ACCESS_RECEIVER);
		non_static_method = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_NON_STATIC_METHOD);

		unresolved_types = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_UNRESOLVED_TYPES);
		unresolved_methods = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_UNRESOLVED_METHODS);
		unresolved_fields = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_UNRESOLVED_FIELDS);
		unresolved_functions = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_UNRESOLVED_FUNCTIONS);
		redeclared_types = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_REDECLARED_TYPES);
		redeclared_methods = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_REDECLARED_METHODS);
		redeclared_fields = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_REDECLARED_FIELDS);
		redeclared_functions = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_REDECLARED_FUNCTIONS);
		fall_through_case = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_FALLTHROUGH_CASE);
		missing_arguments = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_MISSING_ARGUMENTS);
		incompatible_method = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_INCOMPATIBLE_METHOD);
		override_final_method = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_OVERRIDE_FINAL_METHOD);
		include_not_found = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_INCLUDE_NOT_FOUND);
		uninitialized_variable = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_UNINITIALIZED_VARIABLE);
		misc_error = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_MISC_ERROR);
		misc_warning = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_MISC_WARNING);
		misc_strict = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_MISC_STRICT);
		misc_compile_error = misc_error;

		deprecation = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_DEPRECATION);

		unused_local = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_UNUSED_LOCAL);
		unused_parameter = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_UNUSED_PARAMETER);
		unused_private = getSeverity(service, contexts,
				CodeCheckerOptions.PROBLEM_UNUSED_PRIVATE_MEMBER);
	}

	private int getSeverity(PreferencesService service,
			IScopeContext[] contexts, String key) {
		String value = service.getString(CodeCheckerPlugin.PLUGIN_ID, key,
				CodeCheckerOptions.IGNORE, contexts);
		if (value.equals(CodeCheckerOptions.ERROR)) {
			return ProblemSeverities.Error.ordinal();
		} else if (value.equals(CodeCheckerOptions.WARNING)) {
			return ProblemSeverities.Warning.ordinal();
		}
		return ProblemSeverities.Ignore.ordinal();
	}
}
