package jp.sourceforge.pdt_tools.codeChecker.visitor;

import java.util.Stack;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.Dispatch;
import org.eclipse.php.internal.core.compiler.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameterByReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.GotoLabel;
import org.eclipse.php.internal.core.compiler.ast.nodes.GotoStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallArgumentsList;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.Quote;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReferenceExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionStaticMethodInvocation;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReflectionVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.compiler.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.compiler.ast.visitor.PHPASTVisitor;

public abstract class BaseVisitor extends PHPASTVisitor {

	protected Stack<ASTNode> stack;
	protected Stack<Integer> mode;
	protected static final Integer READ = 0;
	protected static final Integer WRITE = 1;

	public BaseVisitor() {
		stack = new Stack<ASTNode>();
		mode = new Stack<Integer>();
		mode.push(READ);
	}

	protected ASTNode getNode(int idx) {
		idx += stack.size() - 1;
		if (idx < 0 || stack.size() <= idx) {
			return null;
		}
		return stack.elementAt(idx);
	}

	@Override
	public boolean visit(ASTNode s) throws Exception {
		stack.push(s);
		return super.visit(s);
	}

	@Override
	public boolean endvisit(ASTNode s) throws Exception {
		try {
			return super.endvisit(s);
		} finally {
			stack.pop();
		}
	}

	@Override
	public boolean visit(ArrayCreation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ArrayElement s) throws Exception {
		mode.push(READ);
		Expression key = s.getKey();
		if (key != null) {
			key.traverse(this);
		}
		s.getValue().traverse(this);
		mode.pop();
		return false;
	}

	@Override
	public boolean visit(ArrayVariableReference s) throws Exception {
		mode.push(READ);
		if (s.getIndex() != null) {
			s.getIndex().traverse(this);
		}
		mode.pop();
		return false;
	}

	@Override
	public boolean visit(Assignment s) throws Exception {
		mode.push(WRITE);
		s.getVariable().traverse(this);
		mode.pop();
		s.getValue().traverse(this);
		return false;
	}

	@Override
	public boolean visit(BackTickExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(BreakStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(CastExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(CatchClause s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ConstantDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ClassDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ClassInstanceCreation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(CloneExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ConditionalExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ConstantReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ContinueStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(DeclareStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Dispatch s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(DoStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(EchoStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(EmptyStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ExpressionStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(FieldAccess s) throws Exception {
		mode.push(READ);
		s.getDispatcher().traverse(this);
		mode.pop();
		s.getField().traverse(this);
		return false;
	}

	@Override
	public boolean visit(ForEachStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(FormalParameter s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(FormalParameterByReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ForStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(GlobalStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(IfStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(IgnoreError s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Include s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(InfixExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(InstanceOfExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(InterfaceDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ListVariable s) throws Exception {
		mode.push(WRITE);
		for (Expression expression : s.getVariables()) {
			expression.traverse(this);
		}
		mode.pop();
		return super.visit(s);
	}

	@Override
	public boolean visit(PHPCallArgumentsList s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PHPCallExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PHPFieldDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PHPMethodDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(PostfixExpression s) throws Exception {
		mode.push(WRITE);
		s.getVariable().traverse(this);
		mode.pop();
		return false;
	}

	@Override
	public boolean visit(PrefixExpression s) throws Exception {
		mode.push(WRITE);
		s.getVariable().traverse(this);
		mode.pop();
		return false;
	}

	@Override
	public boolean visit(Quote s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReferenceExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReflectionArrayVariableReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReflectionCallExpression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReflectionStaticMethodInvocation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReflectionVariableReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ReturnStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Scalar s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(SimpleReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticConstantAccess s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticDispatch s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticFieldAccess s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticMethodInvocation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(StaticStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(SwitchCase s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(SwitchStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(ThrowStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(TryStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(TypeReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(UnaryOperation s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(VariableReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(WhileStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(UseStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(UsePart s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(NamespaceDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(NamespaceReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(FullyQualifiedReference s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(GotoLabel s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(GotoStatement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(LambdaFunctionDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Expression s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(MethodDeclaration s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(Statement s) throws Exception {
		return super.visit(s);
	}

	@Override
	public boolean visit(TypeDeclaration s) throws Exception {
		return super.visit(s);
	}

}
