package jp.sourceforge.pdt_tools.codeChecker;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantFactory;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class BuildParticipantFactory implements IBuildParticipantFactory {

	public IBuildParticipant createBuildParticipant(IScriptProject project)
			throws CoreException {
		if (ProjectOptions.getPhpVersion(project).equals(PHPVersion.PHP5_3)) {
			if (CodeCheckerOptions.realtimeDetectionEnabled(project)) {
				return new BuildParticipant();
			}
		}
		return null;
	}

}
