package jp.sourceforge.pdt_tools.variablefilter;

import java.util.regex.Pattern;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public class VariableFilter {

	public final static int BY_NAME = 1;
	public final static int BY_VALUE = 2;

	private int filterType;
	private String filteringPattern;
	private boolean regularExpression;
	private boolean enabled;

	public VariableFilter(int type, String pattern, boolean regex,
			boolean enable) {
		filterType = type;
		filteringPattern = pattern;
		regularExpression = regex;
		enabled = enable;
	}

	public static String getTypeName(int type) {
		switch (type) {
		case BY_NAME:
			return Messages.VariableFilter_type_name;
		case BY_VALUE:
			return Messages.VariableFilter_type_value;
		}
		return null;
	}

	public int getType() {
		return filterType;
	}

	public void setType(int type) {
		filterType = type;
	}

	public String getPattern() {
		return filteringPattern;
	}

	public void setPattern(String pattern) {
		filteringPattern = pattern;
	}

	public boolean isRegEx() {
		return regularExpression;
	}

	public void isRegEx(boolean regex) {
		regularExpression = regex;
	}

	public boolean isEnabled() {
		return enabled;
	}

	public void isEnabled(boolean enable) {
		enabled = enable;
	}

	public boolean isFiltered(IVariable variable) {
		if (!enabled) {
			return false;
		}
		boolean filtered = false;
		int flags;
		if (regularExpression) {
			flags = 0;
		} else {
			flags = Pattern.LITERAL;
		}
		Pattern pattern = Pattern.compile(filteringPattern, flags);
		try {
			switch (filterType) {
			case BY_NAME:
				String name = variable.getName();
				filtered = pattern.matcher(name).matches();
				break;
			case BY_VALUE:
				String value = variable.getValue().getValueString();
				filtered = pattern.matcher(value).matches();
				break;
			}
		} catch (DebugException e) {
			VariableFilterPlugin.log(e);
		}
		return filtered;
	}
}
