package jp.sourceforge.pdt_tools.variablefilter;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.handlers.RegistryToggleState;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class VariableFilterPlugin extends AbstractUIPlugin implements IStartup {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.sourceforge.pdt_tools.variablefilter"; //$NON-NLS-1$

	// The shared instance
	private static VariableFilterPlugin plugin;

	public static final String COMMAND_ID = "jp.sourceforge.pdt_tools.variablefilter.command"; //$NON-NLS-1$

	public VariableFilterPlugin() {
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	public static VariableFilterPlugin getDefault() {
		return plugin;
	}

	public static void log(Throwable e) {
		getDefault().getLog().log(
				new Status(IStatus.ERROR, PLUGIN_ID, e.getLocalizedMessage()));
	}

	public void earlyStartup() {
		UIJob job = new UIJob("") { //$NON-NLS-1$
			@Override
			public IStatus runInUIThread(IProgressMonitor monitor) {
				initialSetup();
				PlatformUI.getWorkbench().getActiveWorkbenchWindow()
						.getPartService().addPartListener(new PartListener());
				return Status.OK_STATUS;
			}
		};
		job.schedule();
	}

	private void initialSetup() {
		if (isVariablesViewActive()) {
			Command command = getCommand();
			if (command != null) {
				State state = command.getState(RegistryToggleState.STATE_ID);
				if (state != null) {
					Object value = state.getValue();
					if (value instanceof Boolean) {
						if (((Boolean) value).booleanValue()) {
							execCommand(command);
						}
					}
				}
			}
		}
	}

	private boolean isVariablesViewActive() {
		IWorkbenchWindow window = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		if (window != null) {
			IWorkbenchPage page = window.getActivePage();
			if (page != null) {
				IViewPart part = page
						.findView(IDebugUIConstants.ID_VARIABLE_VIEW);
				if (part instanceof IDebugView) {
					return true;
				}
			}
		}
		return false;
	}

	private Command getCommand() {
		Command command = null;
		Object service = getWorkbench().getService(ICommandService.class);
		if (service instanceof ICommandService) {
			command = ((ICommandService) service).getCommand(COMMAND_ID);
		}
		return command;
	}

	private void execCommand(Command command) {
		Object service = getWorkbench().getService(IHandlerService.class);
		if (service instanceof IHandlerService) {
			try {
				((IHandlerService) service).executeCommand(COMMAND_ID, null);
			} catch (ExecutionException e) {
				log(e);
			} catch (NotDefinedException e) {
				log(e);
			} catch (NotEnabledException e) {
				log(e);
			} catch (NotHandledException e) {
				log(e);
			}
		}
	}

	private class PartListener implements IPartListener {
		public void partOpened(IWorkbenchPart part) {
			initialSetup();
		}

		public void partDeactivated(IWorkbenchPart part) {
		}

		public void partClosed(IWorkbenchPart part) {
		}

		public void partBroughtToTop(IWorkbenchPart part) {
		}

		public void partActivated(IWorkbenchPart part) {
		}
	}
}
