/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.patch.Utilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class LineReader {
    private boolean fHaveChar = false;
    private int fLastChar;
    private boolean fSawEOF = false;
    private BufferedReader fReader;
    private boolean fIgnoreSingleCR = false;
    private StringBuffer fBuffer = new StringBuffer();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List load(IStorage file, boolean create) {
        List lines;
        block11: {
            lines = null;
            if (!create && file != null && LineReader.exists(file)) {
                String charset = Utilities.getCharset(file);
                InputStream is = null;
                try {
                    try {
                        is = file.getContents();
                        InputStreamReader streamReader = null;
                        try {
                            streamReader = new InputStreamReader(is, charset);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            streamReader = new InputStreamReader(is);
                        }
                        BufferedReader reader = new BufferedReader(streamReader);
                        lines = LineReader.readLines(reader);
                    }
                    catch (CoreException ex) {
                        CompareUIPlugin.log(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var7_10 = null;
                    if (is == null) break block11;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
            }
        }
        if (lines != null) return lines;
        return new ArrayList();
    }

    private static boolean exists(IStorage file) {
        if (file instanceof IFile) {
            return ((IFile)file).exists();
        }
        return true;
    }

    public static List readLines(BufferedReader reader) {
        LineReader lr = new LineReader(reader);
        if (!"carbon".equals(Platform.getWS())) {
            lr.ignoreSingleCR();
        }
        List lines = lr.readLines();
        return lines;
    }

    public static String createString(boolean preserveLineDelimeters, List lines) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = lines.iterator();
        if (preserveLineDelimeters) {
            while (iter.hasNext()) {
                sb.append((String)iter.next());
            }
        } else {
            String lineSeparator = System.getProperty("line.separator");
            while (iter.hasNext()) {
                String line = (String)iter.next();
                int l = LineReader.length(line);
                if (l < line.length()) {
                    sb.append(line.substring(0, l));
                    sb.append(lineSeparator);
                    continue;
                }
                sb.append(line);
            }
        }
        return sb.toString();
    }

    static int length(String s) {
        int l = s.length();
        if (l > 0) {
            char c = s.charAt(l - 1);
            if (c == '\r') {
                return l - 1;
            }
            if (c == '\n') {
                if (l > 1 && s.charAt(l - 2) == '\r') {
                    return l - 2;
                }
                return l - 1;
            }
        }
        return l;
    }

    public LineReader(BufferedReader reader) {
        this.fReader = reader;
        Assert.isNotNull((Object)reader);
    }

    public void ignoreSingleCR() {
        this.fIgnoreSingleCR = true;
    }

    String readLine() throws IOException {
        block8: {
            try {
                while (!this.fSawEOF) {
                    int c = this.readChar();
                    if (c == -1) {
                        this.fSawEOF = true;
                        break;
                    }
                    this.fBuffer.append((char)c);
                    if (c == 10) break;
                    if (c != 13) continue;
                    c = this.readChar();
                    if (c == -1) {
                        this.fSawEOF = true;
                        break;
                    }
                    if (c != 10) {
                        if (this.fIgnoreSingleCR) {
                            this.fBuffer.append((char)c);
                            continue;
                        }
                        this.fHaveChar = true;
                        this.fLastChar = c;
                        break;
                    }
                    this.fBuffer.append((char)c);
                    break;
                }
                if (this.fBuffer.length() == 0) break block8;
                String string = this.fBuffer.toString();
                Object var2_3 = null;
                this.fBuffer.setLength(0);
                return string;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.fBuffer.setLength(0);
                throw throwable;
            }
        }
        Object var2_4 = null;
        this.fBuffer.setLength(0);
        return null;
    }

    void close() {
        try {
            this.fReader.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List readLines() {
        try {
            try {
                ArrayList<String> lines = new ArrayList<String>();
                while (true) {
                    String line;
                    if ((line = this.readLine()) == null) {
                        ArrayList<String> arrayList = lines;
                        Object var3_4 = null;
                        this.close();
                        return arrayList;
                    }
                    lines.add(line);
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.close();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.close();
            return null;
        }
    }

    int lineContentLength(String line) {
        if (line == null) {
            return 0;
        }
        int length = line.length();
        int i = length - 1;
        while (i >= 0) {
            char c = line.charAt(i);
            if (c != '\n' && c != '\r') break;
            --length;
            --i;
        }
        return length;
    }

    private int readChar() throws IOException {
        if (this.fHaveChar) {
            this.fHaveChar = false;
            return this.fLastChar;
        }
        return this.fReader.read();
    }
}

