/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class InputPatchPage
extends WizardPage {
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    protected static final int COMBO_HISTORY_LENGTH = 5;
    private static final String PAGE_NAME = "PatchWizardPage1";
    private static final String STORE_PATCH_FILES_ID = "PatchWizardPage1.PATCH_FILES";
    private static final String STORE_PATCH_URLS_ID = "PatchWizardPage1.PATCH_URLS";
    private static final String STORE_INPUT_METHOD_ID = "PatchWizardPage1.INPUT_METHOD";
    private static final String STORE_WORKSPACE_PATH_ID = "PatchWizardPage1.WORKSPACE_PATH";
    protected static final int CLIPBOARD = 1;
    protected static final int FILE = 2;
    protected static final int WORKSPACE = 3;
    protected static final int URL = 4;
    protected static final String INPUTPATCHPAGE_NAME = "InputPatchPage";
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    private boolean fShowError = false;
    private String fPatchSource;
    private boolean fPatchRead = false;
    private PatchWizard fPatchWizard;
    private ActivationListener fActivationListener = new ActivationListener();
    private Button fUseClipboardButton;
    private Combo fPatchFileNameField;
    private Button fPatchFileBrowseButton;
    private Button fUsePatchFileButton;
    private Button fUseWorkspaceButton;
    private Button fUseURLButton;
    private Combo fPatchURLField;
    private Label fWorkspaceSelectLabel;
    private TreeViewer fTreeViewer;

    public InputPatchPage(PatchWizard pw) {
        super(INPUTPATCHPAGE_NAME, PatchMessages.InputPatchPage_title, null);
        this.fPatchWizard = pw;
        this.setMessage(PatchMessages.InputPatchPage_message);
    }

    protected IPath getPathFromText(Text textField) {
        return new Path(textField.getText()).makeAbsolute();
    }

    String getPatchName() {
        if (this.getInputMethod() == 1) {
            return PatchMessages.InputPatchPage_Clipboard;
        }
        return this.getPatchFilePath();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        this.buildPatchFileGroup(composite);
        this.restoreWidgetValues();
        this.adjustToCurrentTarget();
        this.fShowError = false;
        this.clearErrorMessage();
        this.updateWidgetEnablements();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.patch_input_wizard_page_context");
    }

    public IWizardPage getNextPage() {
        IWizardPage page;
        WorkspacePatcher patcher = ((PatchWizard)this.getWizard()).getPatcher();
        this.readInPatch();
        FilePatch2[] diffs = patcher.getDiffs();
        if (diffs == null || diffs.length == 0) {
            String format = PatchMessages.InputPatchPage_NoDiffsFound_format;
            String message = MessageFormat.format((String)format, (Object[])new String[]{this.fPatchSource});
            MessageDialog.openInformation(null, (String)PatchMessages.InputPatchPage_PatchErrorDialog_title, (String)message);
            return this;
        }
        int guess = 0;
        patcher.setStripPrefixSegments(guess);
        if (patcher.isWorkspacePatch() && (page = super.getNextPage()).getName().equals("PatchTargetPage")) {
            return page.getNextPage();
        }
        if (patcher.isGitPatch() && (page = super.getNextPage()).getName().equals("PatchTargetPage")) {
            patcher.setTarget((IResource)ResourcesPlugin.getWorkspace().getRoot());
            return page.getNextPage();
        }
        return super.getNextPage();
    }

    /*
     * Exception decompiling
     */
    public void readInPatch() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [9 : 364->368)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void setEnablePatchFile(boolean enable) {
        this.fPatchFileNameField.setEnabled(enable);
        this.fPatchFileBrowseButton.setEnabled(enable);
    }

    private void setEnableWorkspacePatch(boolean enable) {
        this.fWorkspaceSelectLabel.setEnabled(enable);
        this.fTreeViewer.getTree().setEnabled(enable);
    }

    private void setEnableURLPatch(boolean enable) {
        this.fPatchURLField.setEnabled(enable);
    }

    private void buildPatchFileGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.fUseClipboardButton = new Button(composite, 16);
        this.fUseClipboardButton.setText(PatchMessages.InputPatchPage_UseClipboardButton_text);
        this.fUseClipboardButton.setLayoutData((Object)gd);
        this.fUsePatchFileButton = new Button(composite, 16);
        this.fUsePatchFileButton.setText(PatchMessages.InputPatchPage_FileButton_text);
        this.fPatchFileNameField = new Combo(composite, 2048);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.fPatchFileNameField.setLayoutData((Object)gd);
        this.fPatchFileBrowseButton = new Button(composite, 8);
        this.fPatchFileBrowseButton.setText(PatchMessages.InputPatchPage_ChooseFileButton_text);
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = this.fPatchFileBrowseButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        this.fPatchFileBrowseButton.setLayoutData((Object)data);
        this.fUseURLButton = new Button(composite, 16);
        this.fUseURLButton.setText(PatchMessages.InputPatchPage_URLButton_text);
        this.fPatchURLField = new Combo(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fPatchURLField.setLayoutData((Object)gd);
        this.fUseWorkspaceButton = new Button(composite, 16);
        this.fUseWorkspaceButton.setText(PatchMessages.InputPatchPage_UseWorkspaceButton_text);
        gd = new GridData(32);
        this.fUseWorkspaceButton.setLayoutData((Object)gd);
        this.addWorkspaceControls(parent);
        this.fUseClipboardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!InputPatchPage.this.fUseClipboardButton.getSelection()) {
                    return;
                }
                InputPatchPage.this.clearErrorMessage();
                InputPatchPage.this.fShowError = true;
                int state = InputPatchPage.this.getInputMethod();
                InputPatchPage.this.setEnablePatchFile(state == 2);
                InputPatchPage.this.setEnableURLPatch(state == 4);
                InputPatchPage.this.setEnableWorkspacePatch(state == 3);
                InputPatchPage.this.updateWidgetEnablements();
                InputPatchPage.this.fPatchRead = false;
            }
        });
        this.fUsePatchFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!InputPatchPage.this.fUsePatchFileButton.getSelection()) {
                    return;
                }
                InputPatchPage.this.clearErrorMessage();
                InputPatchPage.this.fShowError = InputPatchPage.this.fPatchFileNameField.getText() != "";
                int state = InputPatchPage.this.getInputMethod();
                InputPatchPage.this.setEnablePatchFile(state == 2);
                InputPatchPage.this.setEnableURLPatch(state == 4);
                InputPatchPage.this.setEnableWorkspacePatch(state == 3);
                InputPatchPage.this.updateWidgetEnablements();
                InputPatchPage.this.fPatchRead = false;
            }
        });
        this.fPatchFileNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fPatchFileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputPatchPage.this.clearErrorMessage();
                InputPatchPage.this.fShowError = true;
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fPatchFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputPatchPage.this.clearErrorMessage();
                InputPatchPage.this.fShowError = true;
                InputPatchPage.this.handlePatchFileBrowseButtonPressed();
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fUseURLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputPatchPage.this.clearErrorMessage();
                InputPatchPage.this.fShowError = InputPatchPage.this.fPatchURLField.getText() != "";
                int state = InputPatchPage.this.getInputMethod();
                InputPatchPage.this.setEnablePatchFile(state == 2);
                InputPatchPage.this.setEnableURLPatch(state == 4);
                InputPatchPage.this.setEnableWorkspacePatch(state == 3);
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fPatchURLField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputPatchPage.this.clearErrorMessage();
                InputPatchPage.this.fShowError = true;
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fUseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!InputPatchPage.this.fUseWorkspaceButton.getSelection()) {
                    return;
                }
                InputPatchPage.this.clearErrorMessage();
                InputPatchPage.this.fShowError = !InputPatchPage.this.fTreeViewer.getSelection().isEmpty();
                int state = InputPatchPage.this.getInputMethod();
                InputPatchPage.this.setEnablePatchFile(state == 2);
                InputPatchPage.this.setEnableURLPatch(state == 4);
                InputPatchPage.this.setEnableWorkspacePatch(state == 3);
                InputPatchPage.this.updateWidgetEnablements();
                InputPatchPage.this.fPatchRead = false;
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InputPatchPage.this.clearErrorMessage();
                InputPatchPage.this.updateWidgetEnablements();
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection treeSel;
                Object res;
                ISelection selection = event.getSelection();
                if (selection instanceof TreeSelection && (res = (treeSel = (TreeSelection)selection).getFirstElement()) != null) {
                    if (res instanceof IProject || res instanceof IFolder) {
                        if (InputPatchPage.this.fTreeViewer.getExpandedState(res)) {
                            InputPatchPage.this.fTreeViewer.collapseToLevel(res, 1);
                        } else {
                            InputPatchPage.this.fTreeViewer.expandToLevel(res, 1);
                        }
                    } else if (res instanceof IFile) {
                        InputPatchPage.this.fPatchWizard.showPage(InputPatchPage.this.getNextPage());
                    }
                }
            }
        });
    }

    private void addWorkspaceControls(Composite composite) {
        Composite newComp = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 16;
        newComp.setLayout((Layout)layout);
        newComp.setLayoutData((Object)new GridData(1808));
        this.fWorkspaceSelectLabel = new Label(newComp, 16384);
        this.fWorkspaceSelectLabel.setText(PatchMessages.InputPatchPage_WorkspaceSelectPatch_text);
        this.fTreeViewer = new TreeViewer(newComp, 2048);
        this.fTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fTreeViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.fTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
    }

    private void updateWidgetEnablements() {
        String error = null;
        boolean gotPatch = false;
        int inputMethod = this.getInputMethod();
        if (inputMethod == 1) {
            Control c = this.getControl();
            if (c != null) {
                Clipboard clipboard = new Clipboard(c.getDisplay());
                Object o = clipboard.getContents((Transfer)TextTransfer.getInstance());
                clipboard.dispose();
                if (o instanceof String) {
                    String s = ((String)o).trim();
                    if (s.length() > 0) {
                        gotPatch = true;
                    } else {
                        error = PatchMessages.InputPatchPage_ClipboardIsEmpty_message;
                    }
                } else {
                    error = PatchMessages.InputPatchPage_NoTextInClipboard_message;
                }
            } else {
                error = PatchMessages.InputPatchPage_CouldNotReadClipboard_message;
            }
        } else if (inputMethod == 2) {
            String path = this.fPatchFileNameField.getText();
            if (path != null && path.length() > 0) {
                File file = new File(path);
                boolean bl = gotPatch = file.exists() && file.isFile() && file.length() > 0L;
                if (!gotPatch) {
                    error = String.valueOf(PatchMessages.InputPatchPage_CannotLocatePatch_message) + path;
                }
            } else {
                error = PatchMessages.InputPatchPage_NoFileName_message;
            }
        } else if (inputMethod == 4) {
            String urlText = this.fPatchURLField.getText();
            if (urlText != null) {
                try {
                    new URL(urlText);
                    gotPatch = true;
                }
                catch (MalformedURLException malformedURLException) {
                    error = PatchMessages.InputPatchPage_MalformedURL;
                }
            } else {
                error = PatchMessages.InputPatchPage_NoURL;
            }
        } else if (inputMethod == 3) {
            IResource[] resources = Utilities.getResources(this.fTreeViewer.getSelection());
            if (resources != null && resources.length > 0) {
                IResource patchFile = resources[0];
                if (patchFile != null && patchFile.getType() == 1) {
                    IPath location = patchFile.getLocation();
                    if (location == null) {
                        error = PatchMessages.InputPatchPage_PatchFileNotFound_message;
                    } else {
                        File actualFile = location.toFile();
                        boolean bl = gotPatch = actualFile.exists() && actualFile.isFile() && actualFile.length() > 0L;
                        if (!gotPatch) {
                            error = PatchMessages.InputPatchPage_FileSelectedNotPatch_message;
                        }
                    }
                }
            } else {
                error = PatchMessages.InputPatchPage_NoFileName_message;
            }
        }
        this.setPageComplete(gotPatch);
        if (this.fShowError) {
            this.setErrorMessage(error);
        }
    }

    protected void handlePatchFileBrowseButtonPressed() {
        int lastSegment;
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(PatchMessages.InputPatchPage_SelectPatchFileDialog_title);
        String patchFilePath = this.getPatchFilePath();
        if (patchFilePath != null && (lastSegment = patchFilePath.lastIndexOf(SEPARATOR)) > 0) {
            patchFilePath = patchFilePath.substring(0, lastSegment);
        }
        dialog.setFilterPath(patchFilePath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        patchFilePath = dialog.getFileName();
        Path filterPath = new Path(dialog.getFilterPath());
        IPath path = filterPath.append(patchFilePath).makeAbsolute();
        patchFilePath = path.toOSString();
        this.fPatchFileNameField.setText(patchFilePath);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.fPatchFileNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.fPatchFileNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.fPatchFileNameField.select(selectionIndex);
        }
    }

    public boolean finish() {
        this.saveWidgetValues();
        return true;
    }

    private void restoreWidgetValues() {
        int inputMethod = 2;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String workspaceSetting;
            String[] sourceURLs;
            String patchFilePath;
            try {
                inputMethod = settings.getInt(STORE_INPUT_METHOD_ID);
            }
            catch (NumberFormatException numberFormatException) {}
            String[] sourceNames = settings.getArray(STORE_PATCH_FILES_ID);
            if (sourceNames != null) {
                int i = 0;
                while (i < sourceNames.length) {
                    if (sourceNames[i] != null && sourceNames[i].length() > 0) {
                        this.fPatchFileNameField.add(sourceNames[i]);
                    }
                    ++i;
                }
            }
            if ((patchFilePath = settings.get(STORE_PATCH_FILES_ID)) != null) {
                this.setSourceName(patchFilePath);
            }
            if ((sourceURLs = settings.getArray(STORE_PATCH_URLS_ID)) != null) {
                int i = 0;
                while (i < sourceURLs.length) {
                    if (sourceURLs[i] != null && sourceURLs[i].length() > 0) {
                        this.fPatchURLField.add(sourceURLs[i]);
                    }
                    ++i;
                }
            }
            if (inputMethod == 1) {
                inputMethod = 2;
                this.fPatchFileNameField.deselectAll();
            }
            if ((workspaceSetting = settings.get(STORE_WORKSPACE_PATH_ID)) != null && workspaceSetting.length() > 0) {
                try {
                    Path path = new Path(workspaceSetting);
                    IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    if (this.fTreeViewer != null && targetFile.exists()) {
                        this.fTreeViewer.expandToLevel((Object)targetFile, 0);
                        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)targetFile));
                    }
                }
                catch (RuntimeException runtimeException) {}
            } else if (inputMethod == 3) {
                inputMethod = 2;
            }
        }
        this.setInputButtonState(inputMethod);
    }

    void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_INPUT_METHOD_ID, this.getInputMethod());
            settings.put(STORE_PATCH_FILES_ID, this.getPatchFilePath());
            String[] sourceNames = settings.getArray(STORE_PATCH_FILES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = InputPatchPage.addToHistory(sourceNames, this.getPatchFilePath());
            settings.put(STORE_PATCH_FILES_ID, sourceNames);
            String[] sourceURLs = settings.getArray(STORE_PATCH_URLS_ID);
            if (sourceURLs == null) {
                sourceURLs = new String[]{};
            }
            sourceURLs = InputPatchPage.addToHistory(sourceURLs, this.fPatchURLField.getText());
            settings.put(STORE_PATCH_URLS_ID, sourceURLs);
            settings.put(STORE_WORKSPACE_PATH_ID, this.getWorkspacePath());
        }
    }

    private String getWorkspacePath() {
        IResource[] resources;
        if (this.fTreeViewer != null && (resources = Utilities.getResources(this.fTreeViewer.getSelection())).length > 0) {
            IResource patchFile = resources[0];
            return patchFile.getFullPath().toString();
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    private boolean adjustToCurrentTarget() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 125->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isPatchFile(Reader reader) {
        WorkspacePatcher patcher = ((PatchWizard)this.getWizard()).getPatcher();
        try {
            patcher.parse(new BufferedReader(reader));
        }
        catch (Exception exception) {
            return false;
        }
        FilePatch2[] diffs = patcher.getDiffs();
        return diffs != null && diffs.length != 0;
    }

    private void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    private void setInputButtonState(int state) {
        switch (state) {
            case 1: {
                this.fUseClipboardButton.setSelection(true);
                this.fUsePatchFileButton.setSelection(false);
                this.fUseURLButton.setSelection(false);
                this.fUseWorkspaceButton.setSelection(false);
                break;
            }
            case 2: {
                this.fUseClipboardButton.setSelection(false);
                this.fUsePatchFileButton.setSelection(true);
                this.fUseURLButton.setSelection(false);
                this.fUseWorkspaceButton.setSelection(false);
                break;
            }
            case 4: {
                this.fUseClipboardButton.setSelection(false);
                this.fUsePatchFileButton.setSelection(false);
                this.fUseURLButton.setSelection(true);
                this.fUseWorkspaceButton.setSelection(false);
                break;
            }
            case 3: {
                this.fUseClipboardButton.setSelection(false);
                this.fUsePatchFileButton.setSelection(false);
                this.fUseURLButton.setSelection(false);
                this.fUseWorkspaceButton.setSelection(true);
            }
        }
        this.setEnablePatchFile(state == 2);
        this.setEnableWorkspacePatch(state == 3);
        this.setEnableURLPatch(state == 4);
    }

    protected int getInputMethod() {
        if (this.fUseClipboardButton.getSelection()) {
            return 1;
        }
        if (this.fUsePatchFileButton.getSelection()) {
            return 2;
        }
        if (this.fUseURLButton.getSelection()) {
            return 4;
        }
        return 3;
    }

    private String getPatchFilePath() {
        if (this.fPatchFileNameField != null) {
            return this.fPatchFileNameField.getText();
        }
        return "";
    }

    protected static String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        l.remove(newEntry);
        l.add(0, newEntry);
        if (l.size() > 5) {
            l.remove(5);
        }
        return l.toArray(new String[l.size()]);
    }

    public boolean isPatchRead() {
        return this.fPatchRead;
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            InputPatchPage.this.fShowError = true;
            switch (InputPatchPage.this.getInputMethod()) {
                case 2: {
                    InputPatchPage.this.fShowError = InputPatchPage.this.fPatchFileNameField.getText() != "";
                    break;
                }
                case 4: {
                    InputPatchPage.this.fShowError = InputPatchPage.this.fPatchURLField.getText() != "";
                    break;
                }
                case 3: {
                    InputPatchPage.this.fShowError = !InputPatchPage.this.fTreeViewer.getSelection().isEmpty();
                }
            }
            InputPatchPage.this.updateWidgetEnablements();
        }
    }
}

