package jp.sourceforge.pdt_tools.newfiletemplates.preferences;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.template.php.CodeTemplateContextType;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

@SuppressWarnings("restriction")
public class NewFileTemplatesPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private TableViewer viewer;
	private List<TemplatePersistenceData> templateList;

	private static final String PHPCodeTemplatePreferencePage = "org.eclipse.php.ui.preferences.PHPCodeTemplatePreferencePage"; //$NON-NLS-1$

	public NewFileTemplatesPreferencePage() {
		setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
		setDescription(Messages.PreferencePage_description);
	}

	public void init(IWorkbench workbench) {
	}

	@Override
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));

		final Shell shell = parent.getShell();
		Link link = new Link(composite, SWT.NONE);
		link.setText(Messages.PreferencePage_guide);
		link.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				PreferencesUtil.createPreferenceDialogOn(shell,
						PHPCodeTemplatePreferencePage, null, null);
			}
		});
		link.setToolTipText(Messages.PreferencePage_tooltip);
		GridData gridData = new GridData(SWT.FILL, SWT.BEGINNING, true, false);
		gridData.horizontalSpan = 2;
		gridData.widthHint = 300;
		link.setLayoutData(gridData);

		viewer = new TableViewer(composite, SWT.BORDER | SWT.SINGLE
				| SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
		viewer.setContentProvider(new ArrayContentProvider());

		TableViewerColumn nameColumn = new TableViewerColumn(viewer, SWT.LEFT);
		nameColumn.setLabelProvider(new NameLabelProvider());
		TableColumn tableColumn1 = nameColumn.getColumn();
		tableColumn1.setText(Messages.PreferencePage_name_column_caption);
		tableColumn1.setWidth(150);
		nameColumn.setEditingSupport(new NameEditingSupport(viewer));

		TableViewerColumn descColumn = new TableViewerColumn(viewer, SWT.LEFT);
		descColumn.setLabelProvider(new DescriptionLabelProvider());
		TableColumn tableColumn2 = descColumn.getColumn();
		tableColumn2.setText(Messages.PreferencePage_desc_column_caption);
		tableColumn2.setWidth(150);
		descColumn.setEditingSupport(new DescriptionEditingSupport(viewer));

		Table table = viewer.getTable();
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		TemplateStore store = PHPUiPlugin.getDefault().getCodeTemplateStore();
		templateList = new ArrayList<TemplatePersistenceData>();
		for (TemplatePersistenceData template : store.getTemplateData(false)) {
			if (isUserTemplate(template)) {
				templateList.add(template);
			}
		}
		viewer.setInput(templateList);

		Composite composite2 = new Composite(composite, SWT.NONE);
		composite2.setLayout(new GridLayout(1, false));
		composite2.setLayoutData(new GridData(SWT.DEFAULT, SWT.BEGINNING,
				false, false));
		Button btnAdd = new Button(composite2, SWT.PUSH);
		btnAdd.setText(Messages.PreferencePage_add_button_caption);
		btnAdd.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, false, false));
		btnAdd.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Template template = new Template(
						createNewName(Messages.PreferencePage_template_default_name),
						createNewDescription(Messages.PreferencePage_template_default_description),
						CodeTemplateContextType.NEW_FILE_CONTEXTTYPE,
						Messages.PreferencePage_template_default_pattern, true);
				TemplatePersistenceData data = new TemplatePersistenceData(
						template, true, null);
				templateList.add(data);
				viewer.setInput(templateList);
			}
		});
		Button btnDelete = new Button(composite2, SWT.PUSH);
		btnDelete.setText(Messages.PreferencePage_delete_button_caption);
		btnDelete.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, false,
				false));
		btnDelete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) viewer
						.getSelection();
				TemplatePersistenceData data = (TemplatePersistenceData) selection
						.getFirstElement();
				templateList.remove(data);
				viewer.setInput(templateList);
			}
		});
		Button btnImport = new Button(composite2, SWT.PUSH);
		btnImport.setText(Messages.PreferencePage_import_button_caption);
		btnImport.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, false,
				false));
		btnImport.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				import_();
				viewer.setInput(templateList);
			}
		});

		return composite;
	}

	@Override
	protected void performDefaults() {
		templateList.clear();
		viewer.setInput(templateList);
		super.performDefaults();
	}

	@Override
	public boolean performOk() {
		TemplateStore store = PHPUiPlugin.getDefault().getCodeTemplateStore();
		for (TemplatePersistenceData data : store.getTemplateData(false)) {
			if (isUserTemplate(data)) {
				store.delete(data);
			}
		}
		for (TemplatePersistenceData data : templateList) {
			store.add(data);
		}
		try {
			store.save();
		} catch (IOException e) {
			PHPUiPlugin.log(e);
		}
		return true;
	}

	private boolean isUserTemplate(TemplatePersistenceData data) {
		if (data.isUserAdded()
				&& data.getTemplate().getContextTypeId()
						.equals(CodeTemplateContextType.NEW_FILE_CONTEXTTYPE)) {
			return true;
		}
		return false;
	}

	private String createNewName(String name) {
		String newName = name;
		for (TemplatePersistenceData data : templateList) {
			if (isUserTemplate(data)
					&& data.getTemplate().getName().equals(newName)) {
				Pattern pattern = Pattern.compile("^(.*)\\s\\(([0-9]+)\\)$");
				Matcher matcher = pattern.matcher(newName);
				if (matcher.matches()) {
					int numb = Integer.parseInt(matcher.group(2)) + 1;
					newName = matcher.group(1) + " (" + numb + ")";
				} else {
					newName = newName + " (1)";
				}
				return createNewName(newName);
			}
		}
		return newName;
	}

	private String createNewDescription(String description) {
		String newDescription = description;
		for (TemplatePersistenceData data : templateList) {
			if (isUserTemplate(data)
					&& data.getTemplate().getDescription()
							.equals(newDescription)) {
				Pattern pattern = Pattern.compile("^(.*)\\s\\(([0-9]+)\\)$");
				Matcher matcher = pattern.matcher(newDescription);
				if (matcher.matches()) {
					int numb = Integer.parseInt(matcher.group(2)) + 1;
					newDescription = matcher.group(1) + " (" + numb + ")";
				} else {
					newDescription = newDescription + " (1)";
				}
				return createNewDescription(newDescription);
			}
		}
		return newDescription;
	}

	/**
	 *
	 */
	private class NameLabelProvider extends CellLabelProvider {
		@Override
		public void update(ViewerCell cell) {
			Object element = cell.getElement();
			if (element instanceof TemplatePersistenceData) {
				cell.setText(((TemplatePersistenceData) element).getTemplate()
						.getName());
			}
		}
	}

	/**
	 * 
	 */
	private class DescriptionLabelProvider extends CellLabelProvider {
		@Override
		public void update(ViewerCell cell) {
			Object element = cell.getElement();
			if (element instanceof TemplatePersistenceData) {
				cell.setText(((TemplatePersistenceData) element).getTemplate()
						.getDescription());
			}
		}
	}

	/**
	 * 
	 */
	private class NameEditingSupport extends EditingSupport {

		private TextCellEditor cellEditor;

		public NameEditingSupport(ColumnViewer columnViewer) {
			super(columnViewer);
			cellEditor = new TextCellEditor(viewer.getTable());
		}

		@Override
		protected CellEditor getCellEditor(Object element) {
			return cellEditor;
		}

		@Override
		protected boolean canEdit(Object element) {
			return true;
		}

		@Override
		protected Object getValue(Object element) {
			if (element instanceof TemplatePersistenceData) {
				return ((TemplatePersistenceData) element).getTemplate()
						.getName();
			}
			return null;
		}

		@Override
		protected void setValue(Object element, Object value) {
			if (element instanceof TemplatePersistenceData) {
				Template oldTemplate = ((TemplatePersistenceData) element)
						.getTemplate();
				Template newTemplate = new Template(value.toString(),
						oldTemplate.getDescription(),
						oldTemplate.getContextTypeId(),
						oldTemplate.getPattern(),
						oldTemplate.isAutoInsertable());
				((TemplatePersistenceData) element).setTemplate(newTemplate);
				viewer.refresh();
			}
		}
	}

	/**
	 * 
	 */
	private class DescriptionEditingSupport extends EditingSupport {

		private TextCellEditor cellEditor;

		public DescriptionEditingSupport(ColumnViewer columnViewer) {
			super(columnViewer);
			cellEditor = new TextCellEditor(viewer.getTable());
		}

		@Override
		protected CellEditor getCellEditor(Object element) {
			return cellEditor;
		}

		@Override
		protected boolean canEdit(Object element) {
			return true;
		}

		@Override
		protected Object getValue(Object element) {
			if (element instanceof TemplatePersistenceData) {
				return ((TemplatePersistenceData) element).getTemplate()
						.getDescription();
			}
			return null;
		}

		@Override
		protected void setValue(Object element, Object value) {
			if (element instanceof TemplatePersistenceData) {
				Template oldTemplate = ((TemplatePersistenceData) element)
						.getTemplate();
				Template newTemplate = new Template(oldTemplate.getName(),
						value.toString(), oldTemplate.getContextTypeId(),
						oldTemplate.getPattern(),
						oldTemplate.isAutoInsertable());
				((TemplatePersistenceData) element).setTemplate(newTemplate);
				viewer.refresh();
			}
		}
	}

	/*
	 * @see org.eclipse.jdt.internal.ui.preferences.CodeTemplateBlock.import_()
	 */
	private void import_() {
		FileDialog dialog = new FileDialog(getShell());
		dialog.setText(Messages.PreferencePage_import_title);
		dialog.setFilterExtensions(new String[] { Messages.PreferencePage_import_extension });
		String path = dialog.open();

		if (path == null) {
			return;
		}

		try {
			TemplateReaderWriter reader = new TemplateReaderWriter();
			File file = new File(path);
			if (file.exists()) {
				InputStream input = new BufferedInputStream(
						new FileInputStream(file));
				try {
					TemplatePersistenceData[] datas = reader.read(input, null);
					for (int i = 0; i < datas.length; i++) {
						updateTemplate(datas[i]);
					}
				} finally {
					try {
						input.close();
					} catch (IOException x) {
					}
				}
			}
		} catch (FileNotFoundException e) {
			openReadErrorDialog(e);
		} catch (IOException e) {
			openReadErrorDialog(e);
		}
	}

	private void updateTemplate(TemplatePersistenceData data) {
		if (isUserTemplate(data)) {
			Template template = data.getTemplate();
			for (TemplatePersistenceData data2 : templateList) {
				Template template2 = data2.getTemplate();
				if (template.getName().equals(template2.getName())
						&& template.getDescription().equals(
								template2.getDescription())) {
					data2.setTemplate(data.getTemplate());
					return;
				}
			}
			templateList.add(data);
		}
	}

	/*
	 * @see
	 * org.eclipse.jdt.internal.ui.preferences.CodeTemplateBlock.openReadErrorDialog
	 * (Exception)
	 */
	private void openReadErrorDialog(Exception e) {
		String title = Messages.PreferencePage_error_read_title;
		String message = e.getLocalizedMessage();
		if (message != null) {
			message = Messages.format(
					Messages.PreferencePage_error_parse_message, message);
		} else {
			message = Messages.PreferencePage_error_read_message;
		}
		MessageDialog.openError(getShell(), title, message);
	}

}
