package jp.sourceforge.pdt_tools.codeFolding.preferences;

import jp.sourceforge.pdt_tools.codeFolding.CodeFolding;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceInitializer extends AbstractPreferenceInitializer {

	public PreferenceInitializer() {
	}

	@Override
	public void initializeDefaultPreferences() {
		IPreferenceStore pref = CodeFolding.getDefault().getPreferenceStore();
		pref.setDefault(FoldingPreference.FOLD_CLASSES, FoldingPreference.FOLD_ENABLE);
		pref.setDefault(FoldingPreference.FOLD_INTERFACES, FoldingPreference.FOLD_ENABLE);
		pref.setDefault(FoldingPreference.FOLD_METHODS, FoldingPreference.FOLD_ENABLE);
		pref.setDefault(FoldingPreference.FOLD_FUNCTIONS, FoldingPreference.FOLD_ENABLE);
		pref.setDefault(FoldingPreference.FOLD_PHPDOC, FoldingPreference.FOLD_ENABLE);
		pref.setDefault(FoldingPreference.FOLD_COMMENTS, FoldingPreference.FOLD_ENABLE);
		pref.setDefault(FoldingPreference.FOLD_IF, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_FOR, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_WHILE, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_DO, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_SWITCH, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_CASE, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_TRY, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_CATCH, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_ARRAY, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_HEREDOC, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.FOLD_REGION, FoldingPreference.FOLD_DISABLE);
		pref.setDefault(FoldingPreference.REGION_BEGINNING, ""); //$NON-NLS-1$
		pref.setDefault(FoldingPreference.REGION_ENDING, ""); //$NON-NLS-1$
		pref.setDefault(FoldingPreference.FOLD_BLOCKS, FoldingPreference.FOLD_DISABLE);
	}

}
