﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Lugens.Components
{


    public enum Keycode
    {
        Escape = 27,
        F1 = 112,
        F2 = 113,
        F3 = 114,
        F4 = 115,
        F5 = 116,
        F6 = 117,
        F7 = 118,
        F8 = 119,
        F9 = 120,
        F10 = 121,
        F11 = 122,
        F12 = 123,
        PrintScreen = 44,
        ScrollLock = 145,
        Pause = 19,

        Kanji = 244,
        D1 = 49,
        D2 = 50,
        D3 = 51,
        D4 = 52,
        D5 = 53,
        D6 = 54,
        D7 = 55,
        D8 = 56,
        D9 = 57,
        D0 = 48,
        Equals = 189,       // =
        Tilde = 222,        // ~
        VerticalBar = 220,  // |
        BackSpace = 8,

        Tab = 9,
        Q = 81,
        W = 87,
        E = 69,
        R = 82,
        T = 84,
        Y = 89,
        U = 85,
        I = 73,
        O = 79,
        P = 80,
        At = 192,           // @
        OpenBracket = 219,  // [
        Enter = 13,

        CapsLock = 240,
        A = 65,
        S = 83,
        D = 68,
        F = 70,
        G = 71,
        H = 72,
        J = 74,
        K = 75,
        L = 76,
        SemiColon = 187,    // ;
        Colon = 186,        // :
        CloseBracket = 221, // ]

        LShift = 160,
        Z = 90,
        X = 88,
        C = 67,
        V = 86,
        B = 66,
        N = 78,
        M = 77,
        Less = 188,         // <
        Greater = 190,      // >
        Question = 191,     // ?
        Underscore = 226,   // _
        RShift = 161,

        LControl = 162,
        Win = 91,
        LAlt = 164,
        NonConvert = 29,
        Space = 32,
        Convert = 28,
        Kana = 242,
        RAlt = 165,
        AppMenu = 93,
        RControl = 163,

        Insert = 45,
        Home = 36,
        PageUp = 33,
        Delete = 46,
        End = 35,
        PageDown = 34,
        Up = 38,            // ↑
        Left = 37,          // ←
        Down = 40,          // ↓
        Right = 39,         // →

        NumLock = 144,
        Slash = 111,        // /
        Asterisk = 106,     // *
        Hyphen = 109,       // -

        NumPad7 = 103,
        NumPad8 = 104,
        NumPad9 = 105,
        Plus = 107,         // +

        NumPad4 = 100,
        NumPad5 = 101,
        NumPad6 = 102,

        NumPad1 = 97,
        NumPad2 = 98,
        NumPad3 = 99,

        NumPad0 = 96,
        Period = 110,       // .

        Shift = 16,
        Control = 17,
        Alt = 18

    }

    public static class KeycodeText
    {
        private static string[] keyText = new string[256];
        public static string[] KeyText
        {
            get { return keyText; }
        }

        static KeycodeText()
        {
            keyText[27] = "Escape";
            keyText[112] = "F1";
            keyText[113] = "F2";
            keyText[114] = "F3";
            keyText[115] = "F4";
            keyText[116] = "F5";
            keyText[117] = "F6";
            keyText[118] = "F7";
            keyText[119] = "F8";
            keyText[120] = "F9";
            keyText[121] = "F10";
            keyText[122] = "F11";
            keyText[123] = "F12";
            keyText[44] = "PrintScreen";
            keyText[145] = "ScrollLock";
            keyText[19] = "Pause/Break";

            keyText[243] = "半角/全角";
            keyText[244] = "漢字";
            keyText[49] = "D1";
            keyText[50] = "D2";
            keyText[51] = "D3";
            keyText[52] = "D4";
            keyText[53] = "D5";
            keyText[54] = "D6";
            keyText[55] = "D7";
            keyText[56] = "D8";
            keyText[57] = "D9";
            keyText[48] = "D0";
            keyText[189] = "=";
            keyText[222] = "~";
            keyText[220] = "|";
            keyText[8] = "BackSpace";

            keyText[9] = "Tab";
            keyText[81] = "Q";
            keyText[87] = "W";
            keyText[69] = "E";
            keyText[82] = "R";
            keyText[84] = "T";
            keyText[89] = "Y";
            keyText[85] = "U";
            keyText[73] = "I";
            keyText[79] = "O";
            keyText[80] = "P";
            keyText[192] = "@";
            keyText[219] = "[";
            keyText[13] = "Enter";

            keyText[240] = "CapsLock";
            keyText[65] = "A";
            keyText[83] = "S";
            keyText[68] = "D";
            keyText[70] = "F";
            keyText[71] = "G";
            keyText[72] = "H";
            keyText[74] = "J";
            keyText[75] = "K";
            keyText[76] = "L";
            keyText[187] = ";";
            keyText[186] = ":";
            keyText[221] = "]";

            keyText[160] = "LShift";
            keyText[90] = "Z";
            keyText[88] = "X";
            keyText[67] = "C";
            keyText[86] = "V";
            keyText[66] = "B";
            keyText[78] = "N";
            keyText[77] = "M";
            keyText[188] = "<";
            keyText[190] = ">";
            keyText[191] = "?";
            keyText[226] = "_";
            keyText[161] = "RShift";

            keyText[162] = "LControl";
            keyText[91] = "Win";
            keyText[164] = "LAlt";
            keyText[29] = "無変換";
            keyText[32] = "Space";
            keyText[28] = "前候補/変換";
            keyText[242] = "カタカナ";
            keyText[165] = "RAlt";
            keyText[93] = "AppMenu";
            keyText[163] = "RControl";

            keyText[45] = "Insert";
            keyText[36] = "Home";
            keyText[33] = "PageUp";
            keyText[46] = "Delete";
            keyText[35] = "End";
            keyText[34] = "PageDown";
            keyText[38] = "↑";
            keyText[37] = "←";
            keyText[40] = "↓";
            keyText[39] = "→";

            keyText[144] = "NumLock";
            keyText[111] = "/";
            keyText[106] = "*";
            keyText[109] = "-";

            keyText[103] = "NumPad7";
            keyText[104] = "NumPad8";
            keyText[105] = "NumPad9";
            keyText[107] = "+";

            keyText[100] = "NumPad4";
            keyText[101] = "NumPad5";
            keyText[102] = "NumPad6";

            keyText[97] = "NumPad1";
            keyText[98] = "NumPad2";
            keyText[99] = "NumPad3";

            keyText[96] = "NumPad0";
            keyText[110] = ".";

            keyText[16] = "Shift";
            keyText[17] = "Control";
            keyText[18] = "Alt";
        }
    }

}

/*
 BackSpace 		= 8,
 Tab 			= 9,
 Enter 			= 13,
 Shift 			= 16,
 Control 		= 17,
 Alt 			= 18
 Pause 			= 19,
 Escape 		= 27,
 Convert 		= 28,
 NonConvert 	= 29,
 Space 			= 32,
 PageUp 		= 33,
 PageDown 		= 34,
 End 			= 35,
 Home 			= 36,
 Left			= 37,  // ←
 Up 			= 38,  // ↑
 Right 			= 39,  // →
 Down 			= 40,  // ↓
 PrintScreen 	= 44,
 Insert 		= 45,
 Delete 		= 46,

 D0 			= 48,
 D1 			= 49,
 D2 			= 50,
 D3 			= 51,
 D4 			= 52,
 D5 			= 53,
 D6 			= 54,
 D7 			= 55,
 D8 			= 56,
 D9 			= 57,

 A				= 65,
 B				= 66,
 C				= 67,
 D				= 68,
 E				= 69,
 F				= 70,
 G				= 71,
 H				= 72,
 I				= 73,
 J				= 74,
 K				= 75,
 L				= 76,
 M				= 77,
 N				= 78,
 O				= 79,
 P				= 80,
 Q				= 81,
 R				= 82,
 S				= 83,
 T				= 84,
 U				= 85,
 V				= 86,
 W				= 87,
 X				= 88,
 Y				= 89,
 Z				= 90,
 Win 			= 91,
 AppMenu 		= 93,
 NumPad0 		= 96,
 NumPad1 		= 97,
 NumPad2 		= 98,
 NumPad3 		= 99,
 NumPad4 		= 100,
 NumPad5 		= 101,
 NumPad6 		= 102,
 NumPad7 		= 103,
 NumPad8 		= 104,
 NumPad9 		= 105,
 Asterisk 		= 106, // *
 Plus 			= 107, // +
 Hyphen 		= 109, // -
 Period 		= 110, // .
 Slash 			= 111, // /
 F1 			= 112,
 F2 			= 113,
 F3 			= 114,
 F4 			= 115,
 F5 			= 116,
 F6 			= 117,
 F7 			= 118,
 F8 			= 119,
 F9 			= 120,
 F10 			= 121,
 F11 			= 122,
 F12 			= 123,
 NumLock 		= 144,
 ScrollLock 	= 145,
 LShift 		= 160,
 RShift 		= 161,
 LControl 		= 162,
 RControl 		= 163,
 LAlt 			= 164,
 RAlt 			= 165,
 Colon 			= 186, // :
 SemiColon 		= 187, // ;
 Less 			= 188, // <
 Equals 		= 189, // =
 Greater 		= 190, // >
 Question 		= 191, // ?
 At 			= 192, // @
 OpenBracket 	= 219, // [
 VerticalBar 	= 220, // |
 CloseBracket 	= 221, // ]
 Tilde 			= 222, // ~
 Underscore 	= 226, // _
 CapsLock 		= 240,
 Kana 			= 242,
 Kanji = 244,

*/
