#include<windows.h>

#define WM_APP_KEYDOWN   (WM_APP | 0x0100)
#define WM_APP_KEYUP     (WM_APP | 0x0101)
#define WM_APP_CHAR      (WM_APP | 0x0102)
#define WM_APP_IME_START (WM_APP | 0x0103)
#define WM_APP_IME_END   (WM_APP | 0x0104)
#define WM_APP_IME_COMP  (WM_APP | 0x0105)
#define WM_APP_REC_START (WM_APP | 0x0106)
#define WM_APP_REC_END   (WM_APP | 0x0107)

#define WM_APP_LBUTTONDOWN (WM_APP | 0x0110)
#define WM_APP_LBUTTONUP   (WM_APP | 0x0111)
#define WM_APP_RBUTTONDOWN (WM_APP | 0x0112)
#define WM_APP_RBUTTONUP   (WM_APP | 0x0113)

#pragma data_seg(".GLOBALS")
HHOOK g_hHook = NULL;
HHOOK g_hMouseHook = NULL;
HWND g_hWnd = NULL;
POINT g_caretPos = {0, 0};
char g_imeString[1024] = {'\0'};
#pragma data_seg()


static HINSTANCE hInst = NULL;

int WINAPI DllMain(HINSTANCE hInstance, DWORD fdReason, LPVOID lpReserved)
{
	hInst = hInstance;
	return TRUE;
}

LRESULT CALLBACK CallMouseProc(int nCode,WPARAM wp,LPARAM lp)
{
	POINT pt;
    MOUSEHOOKSTRUCT *pms = (MOUSEHOOKSTRUCT*)lp;

	if (nCode < 0 || g_hWnd == pms->hwnd) { 
		return CallNextHookEx(g_hMouseHook, nCode, wp, lp); 
	} 

	switch(wp){
		case WM_LBUTTONDOWN:
		case WM_NCLBUTTONDOWN:
			pt.x = pms->pt.x;
			pt.y = pms->pt.y;
			//if(wp == WM_LBUTTONDOWN)
			//	ClientToScreen(pms->hwnd, &pt);
			PostMessage(g_hWnd, WM_APP_LBUTTONDOWN, pt.x, pt.y);
			break;
		case WM_RBUTTONDOWN:
		case WM_NCRBUTTONDOWN:
			pt.x = pms->pt.x;
			pt.y = pms->pt.y;
			//if(wp == WM_RBUTTONDOWN)
			//	ClientToScreen(pms->hwnd, &pt);
			PostMessage(g_hWnd, WM_APP_RBUTTONDOWN, pt.x, pt.y);
			break;
	}

	return CallNextHookEx(g_hMouseHook, nCode, wp, lp); 

}

LRESULT CALLBACK CallMsgProc(int nCode,WPARAM wp,LPARAM lp)
{
	int size;
	MSG *msg;
	HWND hWnd;

	if (nCode < 0 || wp == PM_NOREMOVE) { 
		return CallNextHookEx(g_hHook, nCode, wp, lp); 
	} 
	
	if (nCode == HC_ACTION) { 
		msg = (MSG *)lp;

		switch(msg->message){
/*
			case WM_LBUTTONDOWN:
			case WM_NCLBUTTONDOWN:
				pt.x = LOWORD(msg->lParam);
				pt.y = HIWORD(msg->lParam);
				if(msg->message == WM_LBUTTONDOWN)
					ClientToScreen(msg->hwnd, &pt);
				PostMessage(g_hWnd, WM_APP_LBUTTONDOWN, pt.x, pt.y);
				break;
			case WM_RBUTTONDOWN:
			case WM_NCRBUTTONDOWN:
				pt.x = LOWORD(msg->lParam);
				pt.y = HIWORD(msg->lParam);
				if(msg->message == WM_RBUTTONDOWN)
					ClientToScreen(msg->hwnd, &pt);
				PostMessage(g_hWnd, WM_APP_RBUTTONDOWN, pt.x, pt.y);
				break;*/
			case WM_KEYUP:
			case WM_SYSKEYUP:
				PostMessage(g_hWnd, WM_APP_KEYUP, msg->wParam, msg->lParam);
				break;

			case WM_KEYDOWN:
			case WM_SYSKEYDOWN:
		        hWnd = GetFocus();
				g_caretPos.x = g_caretPos.y = 0;
				if(hWnd){
					char className[256];
					GetClassName(hWnd, className, 255);
					if(!strcmp("MozillaWindowClass", className)){
						IMECHARPOSITION imeCharPosition = {sizeof(IMECHARPOSITION)};
						CallWindowProc((WNDPROC)GetWindowLong(hWnd, GWL_WNDPROC), hWnd, WM_IME_REQUEST, IMR_QUERYCHARPOSITION, (LPARAM)&imeCharPosition);
						if(imeCharPosition.pt.x || imeCharPosition.pt.y)
							g_caretPos = imeCharPosition.pt;
					}
				}
		
				PostMessage(g_hWnd, WM_APP_KEYDOWN, msg->wParam, msg->lParam);
				break;

			case WM_CHAR:
				PostMessage(g_hWnd, WM_APP_CHAR, msg->wParam, msg->lParam);
				break;

			case WM_IME_STARTCOMPOSITION:
				PostMessage(g_hWnd, WM_APP_IME_START, 0, 0);
				break;

			case WM_IME_ENDCOMPOSITION:
				PostMessage(g_hWnd, WM_APP_IME_END, 0, 0);
				break;

			case WM_IME_COMPOSITION:
				if(msg->lParam & GCS_RESULTSTR){
					HIMC hImc = ImmGetContext(msg->hwnd);
					size = ImmGetCompositionString(hImc, GCS_RESULTSTR, g_imeString, 1023);
					g_imeString[size] = '\0';
					PostMessage(g_hWnd, WM_APP_IME_COMP, msg->wParam, msg->lParam);
				}
				break;
		}

	}
	return CallNextHookEx(g_hHook, nCode, wp, lp); 
}

//tbNgݍ
extern "C" __declspec(dllexport) void SetHook(HWND hWnd)
{
	g_hWnd = hWnd;
    g_hHook = SetWindowsHookEx(WH_GETMESSAGE, CallMsgProc, hInst, 0);
    g_hMouseHook = SetWindowsHookEx(WH_MOUSE_LL, CallMouseProc, hInst, 0);
}

//tbN
extern "C" __declspec(dllexport) void FreeHook(void)
{
    UnhookWindowsHookEx(g_hHook);
    UnhookWindowsHookEx(g_hMouseHook);
}

//Lbgʒu擾
extern "C" __declspec(dllexport) void GetCaretPoint(LPPOINT lpPoint)
{
	*lpPoint = g_caretPos;
}

//IMEm蕶擾
extern "C" __declspec(dllexport) void GetImeString(char *str, int count)
{
	strcpy_s(str, count, g_imeString);
}
