﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Windows.Forms;

namespace Lugens.Utils
{
    public delegate int MouseHookEventProc(int nCode, IntPtr wParam, IntPtr lParam);
    public delegate int MouseHookEventHandler(int nCode, IntPtr wParam, IntPtr lParam, ref Win32.MouseHookStruct mouseHookStruct);

    public class MouseHook
    {

        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        private static extern IntPtr SetWindowsHookEx(int idHook, MouseHookEventProc lpfn, IntPtr hInstance, int threadId);

        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        private static extern bool UnhookWindowsHookEx(IntPtr idHook);

        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        private static extern int CallNextHookEx(IntPtr idHook, int nCode, IntPtr wParam, IntPtr lParam);

        [DllImport("kernel32.dll", SetLastError = true)]
        private static extern IntPtr GetModuleHandle(string lpModuleName);

        private const int WH_MOUSE_LL = 14;

        private MouseHookEventProc mouseHookEventProc;

        private MouseHookEventHandler handler;

        private IntPtr hHook = IntPtr.Zero;

        
        public MouseHook(MouseHookEventHandler handler)
        {
            this.handler = handler;
            this.mouseHookEventProc = new MouseHookEventProc(MouseHookProc);
        }

        /// <summary>
        /// キーボードフック開始
        /// </summary>
        public void Start()
        {
            hHook = SetWindowsHookEx(WH_MOUSE_LL, this.mouseHookEventProc, GetModuleHandle(Process.GetCurrentProcess().MainModule.ModuleName), 0);
        }

        /// <summary>
        /// キーボードフック停止
        /// </summary>
        public void Stop()
        {
            if (hHook != IntPtr.Zero)
            {
                UnhookWindowsHookEx(hHook);
                hHook = IntPtr.Zero;
            }
        }

        public int CallNextHook(int nCode, IntPtr wParam, IntPtr lParam)
        {
            return CallNextHookEx(hHook, nCode, wParam, lParam);
        }

        /// <summary>
        /// マウスフックプロシージャ
        /// </summary>
        /// <param name="nCode"></param>
        /// <param name="wParam"></param>
        /// <param name="lParam"></param>
        /// <returns></returns>
        private int MouseHookProc(int nCode, IntPtr wParam, IntPtr lParam)
        {
            if (nCode < 0)
                return CallNextHookEx(hHook, nCode, wParam, lParam);
            
            Win32.MouseHookStruct mouseHookStruct = (Win32.MouseHookStruct)Marshal.PtrToStructure(lParam, typeof(Win32.MouseHookStruct));
            return this.handler(nCode, wParam, lParam, ref mouseHookStruct);
        }
    }
}
