﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

using Lugens.Components;
using System.Runtime.InteropServices;
using Lugens.Utils;
using Lugens.Passer.Macro;

namespace Lugens.Passer
{
    public partial class SentenceForm : Form
    {
        private const int SWP_NOSIZE = 1;
        private const int SWP_NOMOVE = 2;
        private const int SWP_NOACTIVATE = 0x10;
        private const int HWND_TOPMOST = -1;
        private const int GWL_EXSTYLE = -20;

        private bool fixData = false;
        public bool FixData
        {
            get { return fixData; }
            set { fixData = value; }
        }
        
        private int group = Program.SentenceSelectedGroup;

        private bool groupMove = false;

        private int scrollPos = 0;

        private Point mousePoint;

        private bool windowMoveFlag = false;
        
        /// <summary>
        /// ボーダーのサイズ
        /// </summary>
        private Size borderSize;

        public SentenceForm()
        {
            InitializeComponent();
            borderSize = this.Size - this.ClientSize;
            this.MinimumSize = new Size(this.MinimumSize.Width, borderSize.Height + this.label_groupName.Height + (3 * this.iconListBox.ItemHeight) + 1);
        }

        public void SetData()
        {
            Program.SentenceSelectedGroup = group;
            Settings.Set(Settings.PASSER_SENTENCE_SELECTEDGROUP, group);
            Program.HideToolTip();
            this.label_groupName.Text = Program.sentenceGroupName[group];
            this.iconListBox.Items.Clear();
            foreach (SentenceInfo info in Program.SentenceGroupList[group])
                this.iconListBox.Items.Add(info.Item);
            if (this.iconListBox.Items.Count > 0)
            {
                this.iconListBox.Focus();
                this.iconListBox.SelectedIndex = 0;
            }
            this.groupMove = true;
        }

        public void SetData(List<HotKeyProcess> processList)
        {
            Program.HideToolTip();
            this.label_groupName.Text = HotKeyTextBox.GetKeyText(processList[0].HotKey);

            this.iconListBox.Items.Clear();
            foreach (HotKeyProcess process in processList)
                this.iconListBox.Items.Add(process.SentenceInfo.Item);

            if (this.iconListBox.Items.Count > 0)
            {
                this.iconListBox.Focus();
                this.iconListBox.SelectedIndex = 0;
            }
            this.groupMove = false;
        }

        private void CopyText()
        {
            if (this.iconListBox.SelectedIndex == -1)
                return;
            SentenceInfo info = (SentenceInfo)((IconListBoxItem)this.iconListBox.SelectedItem).Data;
            if (info.Type == 2)
                return;
            Program.Status = ProgramStatus.Executing;
            Clipboard.SetText(info.Value);
            Program.Status = ProgramStatus.SentenceFormOpen;
            Program.HideToolTip();
            this.DoVisibleChange(false);
            Program.Status = ProgramStatus.Waiting;
        }


        private void SendText()
        {
            Program.HideToolTip();
            this.DoVisibleChange(false);
            if (this.iconListBox.SelectedIndex >= 0)
            {
                SentenceInfo info = (SentenceInfo)((IconListBoxItem)this.iconListBox.SelectedItem).Data;
                switch (info.Type)
                {
                    case 0:
                        if (!String.IsNullOrEmpty(info.Value))
                        {
                            Program.Status = ProgramStatus.SendMessaging;
                            Clipboard.SetText(info.Value);
                            Program.SendMessage("${LControl+}${V}${LControl-}");
                        }
                        Program.Status = ProgramStatus.Waiting;
                        break;

                    case 1:
                        Program.SendMessage(info.Value);
                        break;

                    case 2:
                        Program.Status = ProgramStatus.Executing;
                        IMacro macro = Program.MacroDic[info.Id].Macro;
                        MacroExecuter.ExecuteAsync(0, macro, info.Value.Split(' '));
                        break;
                }
            }
        }

        public void DoVisibleChange(bool visible)
        {
             if (visible)
            {
                Program.Status = ProgramStatus.SentenceFormOpen;
                this.Invalidate();
                if (!this.Visible)
                {
                    this.Visible = true;
                    if (this.iconListBox.Items.Count > 0)
                    {
                        this.iconListBox.SelectedIndex = 0;
                    }
                }

                this.timer1.Start();
                ShowToolTip();
            }
            else
            {
                Settings.Set(Settings.PASSER_FORM_SENTENCE_WIDTH, this.Size.Width);
                Settings.Set(Settings.PASSER_FORM_SENTENCE_HEIGHT, this.Size.Height);
                Program.Status = ProgramStatus.Waiting;
                Program.HideToolTip();
                this.Close();
            }
        }

        private void SentenceForm_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch ((Keys)e.KeyChar)
            {
                case Keys.Escape:
                    this.DoVisibleChange(false);
                    break;

                case Keys.Enter:
                    SendText();
                    break;
            }

        }

        protected override bool ProcessDialogKey(Keys keyData)
        {
            if ((keyData & Keys.KeyCode) == Keys.Tab)
            {
                SendText();
                return true;
            }

            return base.ProcessDialogKey(keyData);
        }

        private void SentenceForm_Resize(object sender, EventArgs e)
        {
            Size size = new Size();
            if (this.Size.Height > this.MaximumSize.Height)
                this.Size = new Size(this.Size.Width, this.MaximumSize.Height);
            
            size.Width = this.ClientSize.Width - 2;
            size.Height = 18;
            this.label_groupName.Size = size;

            size.Height = this.ClientSize.Height - this.label_groupName.Size.Height;
            this.iconListBox.Size = size;
        }

        protected override void CreateHandle()
        {
            base.CreateHandle();
            Win32.SetWindowPos(new HandleRef(this, this.Handle), (IntPtr)HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);
        }

        protected override CreateParams CreateParams
        {
            get
            {
                 CreateParams cp = base.CreateParams;
                cp.Style = (-2147483648) | 0x00040000;
                cp.ExStyle |= Win32.WS_EX_NOACTIVATE;
                return cp;
            }
        }

        protected override bool ShowWithoutActivation
        {
            get
            {
                return true;
            }
        }

        public bool IsProcessKey(int code)
        {
            switch (code & 0xFF)
            {
                case (int)Keycode.C:
                    if ((code & 0x3000) != 0)
                        return true;
                    return false;
                case (int)Keycode.D0:
                case (int)Keycode.D1:
                case (int)Keycode.D2:
                case (int)Keycode.D3:
                case (int)Keycode.D4:
                case (int)Keycode.D5:
                case (int)Keycode.D6:
                case (int)Keycode.D7:
                case (int)Keycode.D8:
                case (int)Keycode.D9:
                case (int)Keycode.NumPad0:
                case (int)Keycode.NumPad1:
                case (int)Keycode.NumPad2:
                case (int)Keycode.NumPad3:
                case (int)Keycode.NumPad4:
                case (int)Keycode.NumPad5:
                case (int)Keycode.NumPad6:
                case (int)Keycode.NumPad7:
                case (int)Keycode.NumPad8:
                case (int)Keycode.NumPad9:
                case (int)Keycode.Left:
                case (int)Keycode.Right:
                    return !this.fixData;

                case (int)Keycode.Up:
                case (int)Keycode.Down:
                case (int)Keycode.Tab:
                case (int)Keycode.Enter:
                case (int)Keycode.Home:
                case (int)Keycode.End:
                case (int)Keycode.PageUp:
                case (int)Keycode.PageDown:
                    return true;
            }
            return false;
        }

        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case 0x201:
                case 0x0A1:
                    Program.HideToolTip();
                    break;

                case Win32.WM_VSCROLL:
                    int code = ((int)m.WParam & 0xFFFF);
                    int pos = ((int)m.WParam >> 16);
                    switch (code)
                    {
                        case Win32.SB_LINEUP:
                        case Win32.SB_LINEDOWN:
                            this.iconListBox_SelectedIndexChanged(null, null);
                            break;

                        case Win32.SB_THUMBTRACK:
                            if (this.scrollPos != pos)
                            {
                                this.iconListBox_SelectedIndexChanged(null, null);
                                this.scrollPos = pos;
                            }
                            break;
                    }
                    break;

                case 0x0214:
                    Rectangle sizing = (Rectangle)Marshal.PtrToStructure(m.LParam, typeof(Rectangle));
                    Rectangle org = this.Bounds;
                    int height = (sizing.Height - sizing.Y - label_groupName.Height - borderSize.Height) / this.iconListBox.ItemHeight * this.iconListBox.ItemHeight;
                    if (sizing.Y != org.Y)
                    {
                        sizing.Y = sizing.Height - height - label_groupName.Height - borderSize.Height - 1;
                        //newHeight = sizing.Height - height - borderSize.Height;
                        //if (sizing.Height - newHeight > this.MaximumSize.Height)
                        //    sizing.Y = sizing.Height - MaximumSize.Height;
                        //else
                        //    sizing.Y = sizing.Height - height - borderSize.Height;
                    }
                    else
                        sizing.Height = sizing.Y + height + label_groupName.Height + borderSize.Height + 1;
                    
                    if (this.MaximumSize.Height < (sizing.Height - sizing.Y))
                        sizing.Height = sizing.Y + this.MaximumSize.Height;

                    Marshal.StructureToPtr(sizing, m.LParam, true);
                    org = sizing;
                    org.Width -= org.X;
                    org.Height -= org.Y;
                    this.Bounds = org;
                    break;

                case Win32.WM_CHAR:
                    if (this.iconListBox.Items.Count > 0)
                        this.iconListBox.SearchItem((char)m.WParam);
                    break;
/*
                case Win32.WM_KEYDOWN:
                case Win32.WM_SYSKEYDOWN:
                    switch ((int)m.WParam)
                    {
                        case (int)Keycode.Up:
                            if (this.iconListBox.SelectedIndex > 0)
                            {
                                this.iconListBox.SelectedIndex--;
                            }
                            break;

                        case (int)Keycode.Down:
                            if (this.iconListBox.SelectedIndex >= 0 && this.iconListBox.Items.Count - 1 > this.iconListBox.SelectedIndex)
                            {
                                this.iconListBox.SelectedIndex++;
                            }
                            break;
                    }
            
                    break;
*/
                case Program.WM_APP_KHOOK:
                    if ((int)m.WParam == Win32.WM_KEYDOWN || (int)m.WParam == Win32.WM_SYSKEYDOWN)
                    {
                        switch ((int)m.LParam & 0xFF)
                        {
                            case (int)Keycode.C:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                    this.CopyText();
                                break;

                            case (int)Keycode.Enter:
                            case (int)Keycode.Tab:
                                SendText();
                                break;

                            case (int)Keycode.D0:
                            case (int)Keycode.NumPad0:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                {
                                    this.group = 0;
                                    this.SetData();
                                }
                                break;

                            case (int)Keycode.D1:
                            case (int)Keycode.NumPad1:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                {
                                    this.group = 1;
                                    this.SetData();
                                }
                                break;

                            case (int)Keycode.D2:
                            case (int)Keycode.NumPad2:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                {
                                    this.group = 2;
                                    this.SetData();
                                }
                                break;

                            case (int)Keycode.D3:
                            case (int)Keycode.NumPad3:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                {
                                    this.group = 3;
                                    this.SetData();
                                }
                                break;

                            case (int)Keycode.D4:
                            case (int)Keycode.NumPad4:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                {
                                    this.group = 4;
                                    this.SetData();
                                }
                                break;

                            case (int)Keycode.D5:
                            case (int)Keycode.NumPad5:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                {
                                    this.group = 5;
                                    this.SetData();
                                }
                                break;

                            case (int)Keycode.Left:
                                if (this.groupMove)
                                {
                                    if (this.group == 0)
                                        this.group = 5;
                                    else
                                        this.group--;
                                    this.SetData();
                                }
                                break;

                            case (int)Keycode.Right:
                                if (this.groupMove)
                                {
                                    if (this.group == 5)
                                        this.group = 0;
                                    else
                                        this.group++;
                                    this.SetData();
                                }
                                break;

                            case (int)Keycode.Escape:
                                this.DoVisibleChange(false);
                                break;

                            case (int)Keycode.Up:
                                if (this.iconListBox.SelectedIndex > 0)
                                {
                                    this.iconListBox.SelectedIndex--;
                                }
                                break;

                            case (int)Keycode.Down:
                                if (this.iconListBox.SelectedIndex >= 0 && this.iconListBox.Items.Count - 1 > this.iconListBox.SelectedIndex)
                                {
                                    this.iconListBox.SelectedIndex++;
                                }
                                break;

                            case (int)Keycode.PageUp:
                                if (this.iconListBox.SelectedIndex >= 0)
                                {
                                    if (this.iconListBox.SelectedIndex - (this.iconListBox.ShowItemCount - 1) > 0)
                                        this.iconListBox.SelectedIndex = this.iconListBox.SelectedIndex - (this.iconListBox.ShowItemCount - 1);
                                    else
                                        this.iconListBox.SelectedIndex = 0;
                                }                                
                                break;

                            case (int)Keycode.PageDown:
                                if (this.iconListBox.SelectedIndex >= 0)
                                {
                                    if (this.iconListBox.SelectedIndex + this.iconListBox.ShowItemCount < this.iconListBox.Items.Count)
                                        this.iconListBox.SelectedIndex = this.iconListBox.SelectedIndex + (this.iconListBox.ShowItemCount - 1);
                                    else
                                        this.iconListBox.SelectedIndex = this.iconListBox.Items.Count - 1;
                                }
                                break;

                            case (int)Keycode.Home:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                    if (this.iconListBox.SelectedIndex >= 0)
                                    {
                                        this.iconListBox.SelectedIndex = 0;
                                    }
                                break;

                            case (int)Keycode.End:
                                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 1 || KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                                    if (this.iconListBox.SelectedIndex >= 0)
                                    {
                                        this.iconListBox.SelectedIndex = this.iconListBox.Items.Count - 1;
                                    }
                                break;
                        }
                    }

                    break;
            }
            base.WndProc(ref m);
        }

        private void iconListBox_DoubleClick(object sender, EventArgs e)
        {
            SendText();
        }

        private void iconListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.Visible)
                ShowToolTip();
        }

        public void ShowToolTip()
        {
            Program.HideToolTip();
            IconListBox listBox = this.iconListBox;
            if (listBox.SelectedIndex < 0 || ((IconListBoxItem)listBox.Items[listBox.SelectedIndex]).ToolTipText == null)
                return;

            int lastIndex = listBox.ClientRectangle.Height / listBox.ItemHeight;
            if (listBox.TopIndex > listBox.SelectedIndex || (listBox.TopIndex + lastIndex) <= listBox.SelectedIndex)
                return;

            if (!Settings.GetBool(Settings.PASSER_SENTENCE_SHOWSCRIPTTOOLTIP))
            {
                SentenceInfo info = (SentenceInfo)listBox.Data;
                if (info.Type == 1)
                    return;
            }

            Rectangle r = this.Bounds;
            r.Y = this.RectangleToScreen(listBox.Bounds).Y + listBox.GetItemRectangle(listBox.SelectedIndex).Y;
            string text = ((IconListBoxItem)listBox.Items[listBox.SelectedIndex]).ToolTipText;
            Program.ShowToolTip(text, r, 12000, true);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (this.Visible)
            {
                if (this.Opacity + Program.FadeInSpeed < Program.FormOpacity)
                {
                    this.Opacity += Program.FadeInSpeed;
                }
                else
                {
                    this.Opacity = Program.FormOpacity;
                    this.timer1.Stop();
                }
            }
        }

        private void SentenceForm_Load(object sender, EventArgs e)
        {

        }

        private void iconListBox_MouseUp(object sender, MouseEventArgs e)
        {
            this.iconListBox_SelectedIndexChanged(null, null);
        }

        private void label_groupName_MouseDown(object sender, MouseEventArgs e)
        {
            this.windowMoveFlag = true;
            this.mousePoint = new Point(-e.X, -e.Y);
        }

        private void label_groupName_MouseUp(object sender, MouseEventArgs e)
        {
            this.windowMoveFlag = false;
        }

        private void label_groupName_MouseMove(object sender, MouseEventArgs e)
        {
            if (this.windowMoveFlag && (e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                //ウィンドウの移動
                this.Location = new Point(this.Left + mousePoint.X + e.X, this.Top + mousePoint.Y + e.Y);
            }
        }
    }
}
