﻿/**
 * $Revision: 249 $
 * $Date: 2010-03-25 01:02:01 +0900 (木, 25 3 2010) $
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Xml;

using Lugens.Components;
using Lugens.Utils;
using System.Reflection;
using System.Threading;
using Lugens.Passer.Macro;
using Lugens.Components.IME;
using System.Windows.Media.Imaging;
using Microsoft.WindowsAPICodePack.Shell;

namespace Lugens.Passer
{
    public static partial class Program
    {
        private static Mutex mutex;

        //public static bool DEBUG = false;

        public static double OSVersion = Double.Parse(Environment.OSVersion.Version.Major + "." + Environment.OSVersion.Version.Minor);

        public static ImeLanguage Ime = new ImeLanguage();
        
        public const int WM_APP_KHOOK = Win32.WM_APP | 0x0001;
        public const int WM_APP_MHOOK = Win32.WM_APP | 0x0002;

        public const int WM_APP_KEYDOWN   = Win32.WM_APP | 0x0100;
        public const int WM_APP_KEYUP     = Win32.WM_APP | 0x0101;
        public const int WM_APP_CHAR      = Win32.WM_APP | 0x0102;
        public const int WM_APP_IME_START = Win32.WM_APP | 0x0103;
        public const int WM_APP_IME_END   = Win32.WM_APP | 0x0104;
        public const int WM_APP_IME_COMP  = Win32.WM_APP | 0x0105;
        public const int WM_APP_REC_START = Win32.WM_APP | 0x0106;
        public const int WM_APP_REC_END   = Win32.WM_APP | 0x0107;

        public const int WM_APP_LBUTTONDOWN = Win32.WM_APP | 0x0110;
        public const int WM_APP_LBUTTONUP   = Win32.WM_APP | 0x0111;
        public const int WM_APP_RBUTTONDOWN = Win32.WM_APP | 0x0112;
        public const int WM_APP_RBUTTONUP   = Win32.WM_APP | 0x0113;

        public const int WM_APP_SHOWFORM  = Win32.WM_APP | 0x0120;
        public const int WM_APP_SCROLLEND = Win32.WM_APP | 0x0121;

        public const int WM_HOTKEY_EXECUTE = Win32.WM_APP | 0x1000;

        public const int WM_SUGGEST_END    = Win32.WM_APP | 0x1100;

        public static ProgramStatus Status = ProgramStatus.Loading;
        public static int closingKeycode = 0;

        public static readonly string SettingFileName = Application.StartupPath + @"\Passer.ini";
        public static readonly string CommandFileName = Application.StartupPath + @"\CommandList.xml";
        public static readonly string StringFileName = Application.StartupPath + @"\StringList.xml";
        public static readonly string SentenceFileName = Application.StartupPath + @"\SentenceList.xml";
        public static readonly string CommandHistoryFileName = Application.StartupPath + @"\CommandHistoryList.xml";
        public static readonly string MacroFileName = Application.StartupPath + @"\MacroList.xml";
        public static readonly string MacroDirectory = Application.StartupPath + @"\macro";
        
        public static readonly string UserAgent = "Passer " + Process.GetCurrentProcess().MainModule.FileVersionInfo.FileVersion;

        public static readonly string DefaultCommand = "@default";
        
        public static bool Main_FadeIn;
        public static bool Main_ShowBalloonWhileRecoding;
        public static bool Main_SendRecordToClipboard;
        public static bool Main_MemorizeEngine;
        public static int HotKey_Main;
        public static int HotKey_Clip;
        public static int HotKey_ClipPaste;
        public static int HotKey_KeyRecord;
        public static int HotKey_KeyPlay;
        public static int SentenceSelectedGroup;
        public static bool SentenceShowScriptToolTip;
        public static double FormOpacity;
        public static double FadeInSpeed;

        public static IntPtr HotKeyTextBoxHandle = IntPtr.Zero;
        public static IntPtr BallonWindowHandle = IntPtr.Zero;

        /// <summary>
        /// ↑↓キーによるコマンド履歴検索用インデックス
        /// </summary>
        public static int CommandHistoryIndex = 0;

        /// <summary>
        /// キー再生スクリプト
        /// </summary>
        public static string KeyRecordString = null;

        /// <summary>
        /// キー記憶レコードリスト
        /// </summary>
        public static List<KeyRecordInfo> KeyRecordList = new List<KeyRecordInfo>();

        /// <summary>
        /// ホットキー押下時の処理リスト
        /// StructHotKeyProcess or List
        /// </summary>
        public static Dictionary<int, List<HotKeyProcess>> HotKeyProcessDic = new Dictionary<int, List<HotKeyProcess>>();

        /// <summary>
        /// 設定コマンドリスト
        /// </summary>
        public static List<string> CommandList = new List<string>();
        public static Dictionary<string, CommandInfo> CommandDic = new Dictionary<string, CommandInfo>();

        /// <summary>
        /// マクロリスト
        /// </summary>
        public static SortedDictionary<string, MacroInfo> MacroDic = new SortedDictionary<string, MacroInfo>();
        public static SortedDictionary<string, MacroInfo> MacroNameDic = new SortedDictionary<string, MacroInfo>();
        
        /// <summary>
        /// グループ毎の定型文リスト
        /// </summary>
        public static List<SentenceInfo>[] SentenceGroupList = new List<SentenceInfo>[6];

        /// <summary>
        /// コマンド履歴リスト
        /// </summary>
        public static List<string> CommandHistoryList = new List<string>();

        /// <summary>
        /// ルートドライブリスト
        /// </summary>
        public static List<IconListBoxItem> RootDriveList = new List<IconListBoxItem>();

        /// <summary>
        /// ディレクトリアイコン
        /// </summary>
        public static Icon DirectoryIcon;

        public static Dictionary<string, Icon> ExtIconCacheDic = new Dictionary<string, Icon>();

        /// <summary>
        /// エイリアスリスト
        /// </summary>
        public static Dictionary<string, string> AliasDic = new Dictionary<string, string>();

        /// <summary>
        /// ShellObjectアイコンリスト
        /// </summary>
        public static Dictionary<string, Bitmap> ShellIconDic = new Dictionary<string, Bitmap>();

        /// <summary>
        /// 定型文グループ名
        /// </summary>
        public static string[] sentenceGroupName = new string[6];

        public static int ClipboardMaxSize = 256;

        public static int CommandHistoryMaxSize = 256;

        /// <summary>
        /// クリップボードデータ履歴用フラグ
        /// </summary>
        public static bool ClipboardFirstTime = true;

        /// <summary>
        /// キーコード変換処理
        /// </summary>
        private static MatchEvaluator matchEvaluator = new MatchEvaluator(ReplaceKeyCode);

        static Win32.Input[] input = new Win32.Input[2];

        public static MainForm MainForm = null;
        public static IntPtr MainFormHandle;
        public static SettingForm SettingForm = null;
        public static ToolTipForm ToolTipForm = null;
        public static SentenceForm SentenceForm = null;
        public static PopupForm PopupForm = null;

        /// <summary>
        /// キーコードの正規表現
        /// </summary>
        private static Regex regex = new Regex(@"\$\{([a-zA-Z0-9]+)(\+|\-)?\}");

        private static string regexStr;

        /// <summary>
        /// 定型文用アイコン
        /// </summary>
        public static Icon[] SentenceIcons = 
        {
            Properties.Resources.IconSentence,
            Properties.Resources.IconScript,
            Properties.Resources.IconMacro
        };

        public static Rectangle GetCaretRect()
        {
            Rectangle r = new Rectangle(0, 0, 0, 0);
            IntPtr hWnd = Win32.GetForegroundWindow();
            Win32.RECT rect = new Win32.RECT();
            Win32.GUITHREADINFO info = new Win32.GUITHREADINFO();
            uint current;
            uint threadId = Win32.GetWindowThreadProcessId(hWnd, out current);

            info.cbSize = (uint)Marshal.SizeOf(info);
            Win32.GetGUIThreadInfo(threadId, ref info);
            if (info.rcCaret.Left == 0 && info.rcCaret.Top == 0)
                return r;

            r.X = info.rcCaret.Left;
            r.Y = info.rcCaret.Top;
            r.Width = info.rcCaret.Right;
            r.Height = info.rcCaret.Bottom;

            Win32.GetWindowRect(info.hWndFocus, ref rect);
            r.X += rect.Left;
            r.Y += rect.Top;
            r.Width += rect.Left;
            r.Height += rect.Top;

            return r;
        }

        /// <summary>
        /// 強制的にウィンドウをアクティブにし、前面に表示する
        /// </summary>
        /// <param name="hWnd"></param>
        public static void ForceForegroundWindow(IntPtr hWnd)
        {
            if (hWnd == IntPtr.Zero)
            {
                return;
            }
            uint processId = 0;
            uint targetProcessId = Win32.GetWindowThreadProcessId(hWnd, out processId);
            uint currentProcessId = Win32.GetWindowThreadProcessId(Win32.GetForegroundWindow(), out processId);

            if (targetProcessId == currentProcessId)
            {
                Win32.BringWindowToTop(hWnd);
            }
            else
            {
                Win32.AttachThreadInput(targetProcessId, currentProcessId, true);
                Win32.BringWindowToTop(hWnd);
                Win32.AttachThreadInput(targetProcessId, currentProcessId, false);
            }
        }

        public static string ReplaceKeyCode(Match m)
        {
            StringBuilder sb = new StringBuilder();
            string text = m.Groups[1].Value;

            if (m.Captures[0].Index == 0 || regexStr[m.Captures[0].Index - 1] != '$')
            {
                if (Enum.IsDefined(typeof(Keycode), text))
                {
                    char code = (char)(Keycode)Enum.Parse(typeof(Keycode), text);
                    if ("+".Equals(m.Groups[2].Value))
                        code |= (char)0xA100;
                    else if ("-".Equals(m.Groups[2].Value))
                        code |= (char)0xA200;
                    else
                        code |= (char)0xA300;

                    sb.Append(code);
                }
            }
            else if (m.Captures[0].Index == 0 || regexStr[m.Captures[0].Index - 1] == '$')
            {
                sb.Append(m.Value.Substring(1));
            }
            else
            {
                sb.Append(m.Value);
            }
            return sb.ToString();
        }


        public static bool IsExtendKey(Keycode code)
        {
            switch (code)
            {
                case Keycode.Home:
                case Keycode.End:
                case Keycode.Up:
                case Keycode.Left:
                case Keycode.Down:
                case Keycode.Right:
                case Keycode.Insert:
                case Keycode.Delete:
                case Keycode.NumLock:
                case Keycode.RShift:
                case Keycode.RControl:
                case Keycode.RAlt:
                    return true;
            }
            return false;
        }

        public static IntPtr GetTargetHWnd()
        {
            IntPtr hWnd = IntPtr.Zero;
            uint processId = 0;
            uint currentThreadId = Win32.GetCurrentThreadId();
            uint threadId = Win32.GetWindowThreadProcessId(Win32.GetForegroundWindow(), out processId);

            if (currentThreadId == threadId)
            {
                hWnd = Win32.GetFocus();
            }
            else
            {
                if (Win32.AttachThreadInput(threadId, currentThreadId, true))
                {
                    hWnd = Win32.GetFocus();
                    Win32.AttachThreadInput(threadId, currentThreadId, false);
                }
            }
            return hWnd;
        }

        /// <summary>
        /// 文字列＆キーイベント送信
        /// </summary>
        /// <param name="str"></param>
        public static void SendMessage(string str)
        {
            if (str == null || str.Length == 0)
                return;

            IntPtr hWnd = Program.GetTargetHWnd();
            if (hWnd == null)
                return;

            Program.regexStr = str;
            str = Program.regex.Replace(str, matchEvaluator);
            Encoding encoding = Encoding.GetEncoding("Shift_JIS");
            char[] chars = new char[1];
            char sendChar;
            str = str.Replace("\r", "");

            foreach (char c in str)
            {
                if (c <= 127)
                {
                    Win32.SendMessage(hWnd, Win32.WM_CHAR, (IntPtr)c, (IntPtr)0);
                }
                else if ((c >> 12) == 0x0A)
                {
                    int action = (c >> 8) & 0x0F;
                    char code = (char)(c & 0x00FF);
                    bool extend = IsExtendKey((Keycode)code);
                    switch (action)
                    {
                        case 1:
                        case 2:
                            input[0].type = Win32.INPUT_KEYBOARD;
                            input[0].ki.wVk = code;
                            input[0].ki.wScan = (ushort)Win32.MapVirtualKey(input[0].ki.wVk, 0);
                            input[0].ki.dwFlags = (uint)(action == 1 ? 0 : Win32.KEYEVENTF_KEYUP);
                            input[0].ki.dwExtraInfo = (IntPtr)((action == 1 ? 0 : 1) + (1 << 3)); //28ビット目を立てる
                            if (extend)
                            {
                                input[0].ki.dwFlags |= Win32.KEYEVENTF_EXTENDEDKEY;
                            }
                            Win32.SendInput(1, input, Marshal.SizeOf(input[0]));
                            break;

                        case 3:
                            input[0].type = Win32.INPUT_KEYBOARD;
                            input[0].ki.wVk = code;
                            input[0].ki.wScan = (ushort)Win32.MapVirtualKey(input[0].ki.wVk, 0);
                            input[0].ki.dwFlags = 0;
                            input[0].ki.dwExtraInfo = (IntPtr)(1 << 3);
                            input[1].type = Win32.INPUT_KEYBOARD;
                            input[1].ki.wVk = code;
                            input[1].ki.wScan = (ushort)Win32.MapVirtualKey(input[1].ki.wVk, 0);
                            input[1].ki.dwFlags = Win32.KEYEVENTF_KEYUP;
                            input[1].ki.dwExtraInfo = (IntPtr)(1 + (1 << 3));
                            if (extend)
                            {
                                input[0].ki.dwFlags |= Win32.KEYEVENTF_EXTENDEDKEY;
                                input[1].ki.dwFlags |= Win32.KEYEVENTF_EXTENDEDKEY;
                            }
                            Win32.SendInput(2, input, Marshal.SizeOf(input[0]));
                            break;
                    }
                    if (code == (int)Keycode.Tab || code == (int)Keycode.Enter || code == (int)Keycode.Home || code == (int)Keycode.End || code == (int)Keycode.PageUp || code == (int)Keycode.PageDown)
                        Win32.Sleep(15);
                    else
                        Win32.Sleep(10);

                    Application.DoEvents();
                    if (code == (int)Keycode.F2)
                    {
                        hWnd = Program.GetTargetHWnd();
                    }
                }
                else
                {
                    chars[0] = c;
                    byte[] b = encoding.GetBytes(chars);
                    sendChar = (char)((b[0] << 8) + b[1]);
                    //Win32.SendMessage(hWnd, Win32.WM_IME_CHAR, (IntPtr)sendChar, (IntPtr)0);
                    Win32.SendMessage(hWnd, Win32.WM_CHAR, (IntPtr)(sendChar >> 8), (IntPtr)0);
                    Win32.SendMessage(hWnd, Win32.WM_CHAR, (IntPtr)(sendChar & 0xFF), (IntPtr)0);
                }
                Application.DoEvents();
            }
        }

        public static int EnabledKeycode(int keycode)
        {
            if ((keycode & 0x2000) == 0x2000)
            {
                if (KeyboardHook.KeyState[(int)Keycode.LControl] == 0)
                    keycode &= 0xDFFF;
            }
            if ((keycode & 0x1000) == 0x1000)
            {
                if (KeyboardHook.KeyState[(int)Keycode.RControl] == 0)
                    keycode &= 0xEFFF;
            }
            if ((keycode & 0x0800) == 0x0800)
            {
                if (KeyboardHook.KeyState[(int)Keycode.LAlt] == 0)
                    keycode &= 0xF7FF;
            }
            if ((keycode & 0x0400) == 0x0400)
            {
                if (KeyboardHook.KeyState[(int)Keycode.RAlt] == 0)
                    keycode &= 0xFBFF;
            }
            if ((keycode & 0x0200) == 0x0200)
            {
                if (KeyboardHook.KeyState[(int)Keycode.LShift] == 0)
                    keycode &= 0xFDFF;
            }
            if ((keycode & 0x0100) == 0x0100)
            {
                if (KeyboardHook.KeyState[(int)Keycode.RShift] == 0)
                    keycode &= 0xFEFF;
            }
            
            return keycode;
        }


        /// <summary>
        /// ホットキーを離した状態にする
        /// </summary>
        /// <param name="keycode"></param>
        public static void HotKeyLeaveStart(int keycode)
        {
            if ((keycode & 0x2000) == 0x2000)
            {
                SendMessage("${LControl-}");
                KeyboardHook.KeyState[(int)Keycode.LControl] = 1;
            }
            if ((keycode & 0x1000) == 0x1000)
            {
                SendMessage("${RControl-}");
                KeyboardHook.KeyState[(int)Keycode.RControl] = 1;
            }
            if ((keycode & 0x0800) == 0x0800)
            {
                SendMessage("${LAlt-}");
                KeyboardHook.KeyState[(int)Keycode.LAlt] = 1;
            }
            if ((keycode & 0x0400) == 0x0400)
            {
                SendMessage("${RAlt-}");
                KeyboardHook.KeyState[(int)Keycode.RAlt] = 1;
            }
            if ((keycode & 0x0200) == 0x0200)
            {
                SendMessage("${LShift-}");
                KeyboardHook.KeyState[(int)Keycode.LShift] = 1;
            }
            if ((keycode & 0x0100) == 0x0100)
            {
                SendMessage("${RShift-}");
                KeyboardHook.KeyState[(int)Keycode.RShift] = 1;
            }
        }

        /// <summary>
        /// ホットキーを押した状態にする
        /// </summary>
        /// <param name="keycode"></param>
        public static void HotKeyLeaveEnd(int keycode)
        {
            KeyboardHook.RecodingStop(keycode);
            Application.DoEvents();
            //ホットキーが離されていない場合は、押した状態にする
            if ((keycode & 0x2000) == 0x2000 && KeyboardHook.KeyState[(int)Keycode.LControl] == 1)
                SendMessage("${LControl+}");
            if ((keycode & 0x1000) == 0x1000 && KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                SendMessage("${RControl+}");
            if ((keycode & 0x0800) == 0x0800 && KeyboardHook.KeyState[(int)Keycode.LAlt] == 1)
                SendMessage("${LAlt+}");
            if ((keycode & 0x0400) == 0x0400 && KeyboardHook.KeyState[(int)Keycode.RAlt] == 1)
                SendMessage("${RAlt+}");
            if ((keycode & 0x0200) == 0x0200 && KeyboardHook.KeyState[(int)Keycode.LShift] == 1)
                SendMessage("${LShift+}");
            if ((keycode & 0x0100) == 0x0100 && KeyboardHook.KeyState[(int)Keycode.RShift] == 1)
                SendMessage("${RShift+}");
        }


        /// <summary>
        /// ホットキーを離した状態にして文字列＆キーイベント送信
        /// </summary>
        /// <param name="str"></param>
        /// <param name="keycode"></param>
        public static void SendMessage(string str, int keycode)
        {
            KeyboardHook.RecodingStart();
            if ((keycode & 0x2000) == 0x2000)
            {
                SendMessage("${LControl-}");
                KeyboardHook.KeyState[(int)Keycode.LControl] = 1;
            }
            if ((keycode & 0x1000) == 0x1000)
            {
                SendMessage("${RControl-}");
                KeyboardHook.KeyState[(int)Keycode.RControl] = 1;
            }
            if ((keycode & 0x0800) == 0x0800)
            {
                SendMessage("${LAlt-}");
                KeyboardHook.KeyState[(int)Keycode.LAlt] = 1;
            }
            if ((keycode & 0x0400) == 0x0400)
            {
                SendMessage("${RAlt-}");
                KeyboardHook.KeyState[(int)Keycode.RAlt] = 1;
            }
            if ((keycode & 0x0200) == 0x0200)
            {
                SendMessage("${LShift-}");
                KeyboardHook.KeyState[(int)Keycode.LShift] = 1;
            }
            if ((keycode & 0x0100) == 0x0100)
            {
                SendMessage("${RShift-}");
                KeyboardHook.KeyState[(int)Keycode.RShift] = 1;
            }
            Application.DoEvents();
            SendMessage(str);
            KeyboardHook.RecodingStop(keycode);
            Program.Status = ProgramStatus.SendMessageClosing;
            Program.closingKeycode = 0;
            Application.DoEvents();
            //ホットキーが離されていない場合は、押した状態にする
            if ((keycode & 0x2000) == 0x2000 && KeyboardHook.KeyState[(int)Keycode.LControl] == 1)
                SendMessage("${LControl+}");
            if ((keycode & 0x1000) == 0x1000 && KeyboardHook.KeyState[(int)Keycode.RControl] == 1)
                SendMessage("${RControl+}");
            if ((keycode & 0x0800) == 0x0800 && KeyboardHook.KeyState[(int)Keycode.LAlt] == 1)
                SendMessage("${LAlt+}");
            if ((keycode & 0x0400) == 0x0400 && KeyboardHook.KeyState[(int)Keycode.RAlt] == 1)
                SendMessage("${RAlt+}");
            if ((keycode & 0x0200) == 0x0200 && KeyboardHook.KeyState[(int)Keycode.LShift] == 1)
                SendMessage("${LShift+}");
            if ((keycode & 0x0100) == 0x0100 && KeyboardHook.KeyState[(int)Keycode.RShift] == 1)
                SendMessage("${RShift+}");
            Application.DoEvents();
        }

        public static void AddCommand(CommandInfo info)
        {
            AddCommand(Program.CommandDic, Program.CommandList, info);
        }

        public static void AddCommand(Dictionary<string, CommandInfo> commandDic, List<string> commandList, CommandInfo info)
        {
            if (commandDic.ContainsKey(info.Name))
                commandDic.Remove(info.Name);

            if (File.Exists(info.Target) || Directory.Exists(info.Target))
            {
                try
                {
                    Win32.SHFILEINFO shinfo = new Win32.SHFILEINFO();
                    Win32.SHGetFileInfo(info.Target, 0, ref shinfo, Marshal.SizeOf(shinfo), Win32.SHGFI_ICON | Win32.SHGFI_SMALLICON);
                    info.ApplicationIcon = Icon.FromHandle(shinfo.hIcon);
                }
                catch (Exception ex) { ex.ToString(); }
            }
            commandDic.Add(info.Name, info);
            if (commandList != null)
                commandList.Add(info.Name);
        }

        public static void AddHistoryList(string str)
        {
            for (int i = 0; i < Program.CommandHistoryList.Count; i++)
            {
                if (str.Equals(Program.CommandHistoryList[i]))
                {
                    Program.CommandHistoryList.RemoveAt(i);
                    Program.CommandHistoryList.Insert(0, str);
                    return;
                }
            }

            if (Program.CommandHistoryList.Count >= Program.CommandHistoryMaxSize)
            {
                Program.CommandHistoryList.RemoveAt(Program.CommandHistoryMaxSize - 1);
            }
            Program.CommandHistoryList.Insert(0, str);
        }

        public static void AddClipboardList(string str, int type)
        {
            if (Program.SentenceGroupList[0].Count >= Program.ClipboardMaxSize)
            {
                Program.SentenceGroupList[0].RemoveAt(Program.ClipboardMaxSize - 1);
            }
            SentenceInfo info = new SentenceInfo();
            info.Name = Util.TrimCutText(str, 30);
            info.Shortcut = 0;
            info.Type = type;
            info.Value = str;
            IconListBoxItem item = new IconListBoxItem();
            item.Name = info.Name;
            item.Text = info.Name;
            item.Regex = Program.Ime.GetRomaji(info.Name.Substring(0, info.Name.Length > 30 ? 30 : info.Name.Length));
            item.IconImage = type == 0 ? Properties.Resources.IconSentence.ToBitmap() : Properties.Resources.IconScript.ToBitmap();
            item.ToolTipText = Util.CutText(str, 80, 20);
            item.Data = info;
            info.Item = item;
            Program.SentenceGroupList[0].Insert(0, info);
        }

        public static void AddClipboardList(string str)
        {
            AddClipboardList(str, 0);
        }

        public static void ShowToolTip(string text, Rectangle r, int duration, bool top)
        {
            if (Program.ToolTipForm == null || !Program.ToolTipForm.Alive)
            {
                Program.ToolTipForm = new ToolTipForm(top);
                Program.ToolTipForm.Opacity = 0D;
            }

            Program.ToolTipForm.Text = text;
            Point p = Util.CalcWindowLocate(r, Program.ToolTipForm.Size, Util.Locate.Right);
            Program.ToolTipForm.Show(p, duration, false);
        }

        [STAThread]
        public static void HideToolTip()
        {
            if (Program.ToolTipForm != null)
            {
                //Program.ToolTipForm.Visible = false;
                Program.ToolTipForm.Close();
                Program.ToolTipForm = null;
            }
        }

        /// <summary>
        /// 設定のロード
        /// </summary>
        public static void ReadSetting()
        {
            Program.Main_FadeIn = Settings.GetBool(Settings.PASSER_MAIN_FADEIN);
            Program.Main_ShowBalloonWhileRecoding = Settings.GetBool(Settings.PASSER_MAIN_SHOWBALLOONWHILERECODING);
            Program.Main_SendRecordToClipboard = Settings.GetBool(Settings.PASSER_MAIN_SENDRECORDTOCLIPBOARD);
            Program.Main_MemorizeEngine = Settings.GetBool(Settings.PASSER_MAIN_MEMORIZE_ENGINE);
            Program.HotKey_Main = Settings.GetInt(Settings.PASSER_HOTKEY_MAIN);
            Program.HotKey_Clip = Settings.GetInt(Settings.PASSER_HOTKEY_CLIP);
            Program.HotKey_ClipPaste = Settings.GetInt(Settings.PASSER_HOTKEY_CLIP_PASTE);
            Program.HotKey_KeyRecord = Settings.GetInt(Settings.PASSER_HOTKEY_KEY_RECORD);
            Program.HotKey_KeyPlay = Settings.GetInt(Settings.PASSER_HOTKEY_KEY_PLAY);
            Program.FormOpacity = Settings.GetDouble(Settings.PASSER_FORM_OPACITY) / 100;
            Program.SentenceSelectedGroup = Settings.GetInt(Settings.PASSER_SENTENCE_SELECTEDGROUP);
            Program.SentenceShowScriptToolTip = Settings.GetBool(Settings.PASSER_SENTENCE_SHOWSCRIPTTOOLTIP);

            Program.FadeInSpeed = Program.Main_FadeIn ? 0.18 : 1.0;

            Program.HotKeyProcessDic.Clear();
            HotKeyProcess process;


            //メインフォームオープン
            if (Program.HotKey_Main > 0)
            {
                process = new HotKeyProcess();
                process.ProcessType = HotKeyProcessType.OpenMainForm;
                process.HotKey = Program.HotKey_Main;
                List<HotKeyProcess> processList = new List<HotKeyProcess>();
                processList.Add(process);
                Program.HotKeyProcessDic.Add(process.HotKey, processList);
            }

            //クリップボードフォームオープン
            if (Program.HotKey_Clip > 0)
            {
                process = new HotKeyProcess();
                process.ProcessType = HotKeyProcessType.OpenSentenceForm;
                process.HotKey = Program.HotKey_Clip;
                List<HotKeyProcess> processList = new List<HotKeyProcess>();
                processList.Add(process);
                Program.HotKeyProcessDic.Add(process.HotKey, processList);
            }

            //クリップボード文字列貼り付け
            if (Program.HotKey_ClipPaste > 0)
            {
                process = new HotKeyProcess();
                process.ProcessType = HotKeyProcessType.PasteClipboard;
                process.HotKey = Program.HotKey_ClipPaste;
                List<HotKeyProcess> processList = new List<HotKeyProcess>();
                processList.Add(process);
                Program.HotKeyProcessDic.Add(process.HotKey, processList);
            }

            //キーボード記憶
            if (Program.HotKey_KeyRecord > 0)
            {
                process = new HotKeyProcess();
                process.ProcessType = HotKeyProcessType.KeyRecord;
                process.HotKey = Program.HotKey_KeyRecord;
                List<HotKeyProcess> processList = new List<HotKeyProcess>();
                processList.Add(process);
                Program.HotKeyProcessDic.Add(process.HotKey, processList);
            }

            //キーボード再生
            if (Program.HotKey_KeyPlay > 0)
            {
                process = new HotKeyProcess();
                process.ProcessType = HotKeyProcessType.KeyPlay;
                process.HotKey = Program.HotKey_KeyPlay;
                List<HotKeyProcess> processList = new List<HotKeyProcess>();
                processList.Add(process);
                Program.HotKeyProcessDic.Add(process.HotKey, processList);
            }

            //定型文
            foreach (List<SentenceInfo> list in Program.SentenceGroupList)
            {
                if (list == null)
                    continue;
                foreach (SentenceInfo info in list)
                {
                    if (info.Shortcut == 0)
                        continue;

                    process = new HotKeyProcess();
                    process.HotKey = info.Shortcut;
                    switch (info.Type)
                    {
                        case 0:
                            process.ProcessType = HotKeyProcessType.PasteSentence;
                            break;
                        case 1:
                            process.ProcessType = HotKeyProcessType.ExecScript;
                            break;
                        case 2:
                            process.ProcessType = HotKeyProcessType.ExecMacro;
                            process.Id = info.Id;
                            break;
                    }
                    process.Value = info.Value;
                    process.SentenceInfo = info;

                    if (Program.HotKeyProcessDic.ContainsKey(process.HotKey))
                    {
                        List<HotKeyProcess> processList = Program.HotKeyProcessDic[process.HotKey];
                        processList.Add(process);

                    }
                    else
                    {
                        List<HotKeyProcess> processList = new List<HotKeyProcess>();
                        processList.Add(process);
                        Program.HotKeyProcessDic.Add(process.HotKey, processList);
                    }
                }
            }
        }

        public static bool ReadCommandList()
        {
            string file = null;

            if (Settings.ContainsKey(Settings.PASSER_COMMANDLIST_DIR))
            {
                file = Settings.Get(Settings.PASSER_COMMANDLIST_DIR);
                if (file[file.Length - 1] == '\\')
                    file = file.Substring(0, file.Length - 1);
                file += @"\CommandList.xml";
                if (!File.Exists(Program.CommandFileName))
                    file = null;
            }

            if (file == null)
                file = Program.CommandFileName;
            
            if (!File.Exists(Program.CommandFileName))
                return false;

            CommandInfo commandInfo = new CommandInfo();
            Type type = typeof(CommandInfo);
            XmlTextReader reader = null;
            Program.CommandList.Clear();
            Program.CommandDic.Clear();

            try
            {
                using (reader = new XmlTextReader(file))
                {
                    while (reader.Read())
                    {
                        if (reader.IsStartElement() && !reader.IsEmptyElement)
                        {
                            if (reader.LocalName.Equals("Command"))
                            {
                                commandInfo = new CommandInfo();
                                continue;
                            }
                            if (reader.LocalName.Equals("Name"))
                            {
                                reader.Read();
                                commandInfo.Name = reader.Value;
                                continue;
                            }
                            if (reader.LocalName.Equals("Target"))
                            {
                                reader.Read();
                                commandInfo.Target = reader.Value;
                                continue;
                            }
                            if (reader.LocalName.Equals("Path"))
                            {
                                reader.Read();
                                commandInfo.Path = reader.Value;
                                continue;
                            }
                            if (reader.LocalName.Equals("Path"))
                            {
                                reader.Read();
                                commandInfo.Arguments = reader.Value;
                                continue;
                            }
                            if (reader.LocalName.Equals("Comment"))
                            {
                                reader.Read();
                                commandInfo.Comment = reader.Value;
                                continue;
                            }
                            if (reader.LocalName.Equals("Arguments"))
                            {
                                reader.Read();
                                commandInfo.Arguments = reader.Value;
                                continue;
                            }
                        }
                        else if (reader.LocalName.Equals("Command"))
                        {
                            Program.AddCommand(commandInfo);
                            //IconListBoxItem item = new IconListBoxItem();
                            //item.Icon = commandInfo.ApplicationIcon;
                            //item.Text = commandInfo.Name;
                            //this.textBox_cmd.Items.Add(item);
                        }
                    }
                }
                return true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return false;
            }
        }

        public static bool ReadCommandHistoryList()
        {
            if (!File.Exists(Program.CommandHistoryFileName))
                return false;

            XmlTextReader reader = null;
            Program.CommandHistoryList.Clear();

            try
            {
                using (reader = new XmlTextReader(Program.CommandHistoryFileName))
                {
                    while (reader.Read())
                    {
                        if (reader.IsStartElement() && !reader.IsEmptyElement)
                        {
                            if (reader.LocalName.Equals("Command"))
                            {
                                reader.Read();
                                Program.CommandHistoryList.Add(reader.Value);
                                continue;
                            }
                        }
                    }
                }
                return true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return false;
            }
        }

        /// <summary>
        /// マクロのロード
        /// </summary>
        public static bool ReadMacroList()
        {
            MacroDic.Clear();
            MacroNameDic.Clear();

            string typeName = typeof(IMacro).FullName;
            //string[] dlls = Directory.GetFiles(Program.MacroDirectory, "*.dll");
            string[] dlls = Directory.GetFiles(".\\", "*.exe");
            try
            {
                foreach (string dll in dlls)
                {
                    System.Reflection.Assembly asm = System.Reflection.Assembly.LoadFrom(dll);
                    foreach (Type t in asm.GetTypes())
                    {
                        if (t.GetInterface(typeName) != null)
                        {
                            IMacro macro = (IMacro)asm.CreateInstance(t.FullName);
                            if (macro.Test())
                            {
                                MacroInfo info = new MacroInfo();
                                info.Item = new IconListBoxItem();
                                info.Macro = macro;
                                info.Item.Name = macro.Name();
                                info.Item.Text = macro.Id();
                                Program.MacroDic.Add(macro.Id(), info);
                                Program.MacroNameDic.Add(macro.Name(), info);
                            }
                        }
                    }
                }
            }
            catch
            {
                MessageBox.Show("DLLがロードできません。ブロックの解除を行っていない場合、\nreadme.txt の手順に従ってブロックの解除を行ってください。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return false;
            }

            if (!File.Exists(Program.MacroFileName))
                return true;

            string id = null;
            XmlTextReader reader = null;

            try
            {
                using (reader = new XmlTextReader(Program.MacroFileName))
                {
                    while (reader.Read())
                    {
                        if (reader.IsStartElement() && !reader.IsEmptyElement)
                        {
                            if (reader.LocalName.Equals("Id"))
                            {
                                reader.Read();
                                id = reader.Value;
                                continue;
                            }
                            if (reader.LocalName.Equals("Shortcut"))
                            {
                                reader.Read();
                                if (!String.IsNullOrEmpty(id) && Program.MacroDic.ContainsKey(id))
                                {
                                    //Program.MacroDic[id].Shortcut = Convert.ToInt32(reader.Value);
                                }
                                continue;
                            }
                        }
                    }
                }
                return true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return false;
            }
        }

        public static bool ReadSentenceList()
        {
            for (int i = 0; i < Program.SentenceGroupList.Length; i++)
            {
                Program.sentenceGroupName[i] = i.ToString();
                if (Program.SentenceGroupList[i] == null)
                    Program.SentenceGroupList[i] = new List<SentenceInfo>();
                else
                    Program.SentenceGroupList[i].Clear();
            }
            Program.sentenceGroupName[0] = "クリップボード";

            string file = null;
            if (Settings.ContainsKey(Settings.PASSER_SENTENCELIST_DIR))
            {
                file = Settings.Get(Settings.PASSER_SENTENCELIST_DIR);
                if (file[file.Length - 1] == '\\')
                    file = file.Substring(0, file.Length - 1);
                file += @"\SentenceList.xml";
                if (!File.Exists(Program.SentenceFileName))
                    file = null;
            }

            if (file == null)
                file = Program.SentenceFileName;

            if (!File.Exists(file))
                return false;

            SentenceInfo info = new SentenceInfo();
            IconListBoxItem iconListBoxItem = new IconListBoxItem();
            XmlTextReader reader = null;
            int group = -1;

            try
            {
                using (reader = new XmlTextReader(file))
                {
                    while (reader.Read())
                    {
                        if (reader.IsStartElement() && !reader.IsEmptyElement)
                        {
                            if (reader.LocalName.Equals("Sentence"))
                            {
                                info = new SentenceInfo();
                                iconListBoxItem = new IconListBoxItem();
                                info.Value = "";
                                continue;
                            }
                            if (reader.LocalName.Equals("Name"))
                            {
                                reader.Read();
                                info.Name = reader.Value;
                                continue;
                            }
                            if (reader.LocalName.Equals("Id"))
                            {
                                reader.Read();
                                info.Id = reader.Value;
                                continue;
                            }
                            if (reader.LocalName.Equals("Type"))
                            {
                                reader.Read();
                                info.Type = int.Parse(reader.Value);
                                continue;
                            }
                            if (reader.LocalName.Equals("Shortcut"))
                            {
                                reader.Read();
                                info.Shortcut = int.Parse(reader.Value);
                                continue;
                            }
                            if (reader.LocalName.Equals("Value"))
                            {
                                reader.Read();
                                info.Value = reader.Value;
                                continue;
                            }
                            if (reader.Name.Equals("Group"))
                            {
                                while (reader.MoveToNextAttribute())
                                {
                                    if (reader.Name.Equals("id"))
                                    {
                                        if (!int.TryParse(reader.Value, out group))
                                            group = 0;
                                        continue;
                                    }
                                    else if (reader.Name.Equals("name"))
                                    {
                                        if (group != 0)
                                            Program.sentenceGroupName[group] = reader.Value;
                                        continue;
                                    }
                                }
                            }
                        }
                        else if (reader.IsStartElement() && reader.LocalName.Equals("Group"))
                        {
                            while (reader.MoveToNextAttribute())
                            {
                                if (reader.Name.Equals("id"))
                                {
                                    if (!int.TryParse(reader.Value, out group))
                                        group = 0;
                                    continue;
                                }
                                else if (reader.Name.Equals("name"))
                                {
                                    if (group != 0)
                                        Program.sentenceGroupName[group] = reader.Value;
                                    continue;
                                }
                            }
                        }
                        else if (reader.LocalName.Equals("Sentence"))
                        {
                            iconListBoxItem.Name = info.Name;
                            iconListBoxItem.Text = info.Name;
                            iconListBoxItem.IconImage = Program.SentenceIcons[info.Type].ToBitmap();
                            iconListBoxItem.Data = info;
                            iconListBoxItem.Regex = Program.Ime.GetRomaji(iconListBoxItem.Name);
                            if (info.Type == 2)
                            {
                                if (Program.MacroDic.ContainsKey(info.Id))
                                {
                                    IMacro macro = Program.MacroDic[info.Id].Macro;
                                    StringBuilder sb = new StringBuilder();
                                    sb.Append("マクロ ： ").Append(macro.Name()).Append(Environment.NewLine);
                                    sb.Append(" 引 数 ： ").Append(String.IsNullOrEmpty(info.Value) ? "なし" : info.Value).Append(Environment.NewLine);
                                    sb.Append(Environment.NewLine);
                                    sb.Append(macro.Summary());
                                    iconListBoxItem.ToolTipText = Util.CutText(sb.ToString(), 80, 40);
                                }
                            }
                            else
                            {
                                iconListBoxItem.ToolTipText = Util.CutText(info.Value, 80, 40);
                            }

                            if (!String.IsNullOrEmpty(info.Name))
                            {
                                info.Item = iconListBoxItem;
                                Program.SentenceGroupList[group].Add(info);
                            }
                        }
                    }
                }
                return true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return false;
            }
        }
            

        public static void WriteCommandList()
        {
            Version version = Assembly.GetExecutingAssembly().GetName().Version;
            XmlTextWriter writer = null;

            using (writer = new XmlTextWriter(Program.CommandFileName, Encoding.UTF8))
            {
                writer.Formatting = Formatting.Indented;

                writer.WriteStartDocument();
                writer.WriteStartElement(Assembly.GetExecutingAssembly().GetName().Name);
                writer.WriteAttributeString("version", version.Major.ToString() + "." + version.Minor.ToString());
                writer.WriteStartElement("CommandList");

                foreach (string key in Program.CommandList)
                {
                    CommandInfo info = Program.CommandDic[key];
                    writer.WriteStartElement("Command");

                    writer.WriteStartElement("Name");
                    writer.WriteString(info.Name);
                    writer.WriteEndElement();

                    writer.WriteStartElement("Target");
                    writer.WriteString(info.Target);
                    writer.WriteEndElement();

                    writer.WriteStartElement("Path");
                    writer.WriteString(info.Path);
                    writer.WriteEndElement();

                    writer.WriteStartElement("Arguments");
                    writer.WriteString(info.Arguments);
                    writer.WriteEndElement();

                    writer.WriteStartElement("Comment");
                    writer.WriteString(info.Comment);
                    writer.WriteEndElement();

                    writer.WriteEndElement();
                }
                writer.WriteEndElement();
                writer.WriteEndElement();
                writer.Flush();
                writer.Close();
            }
        }

        public static void WriteCommandHistoryList()
        {
            Version version = Assembly.GetExecutingAssembly().GetName().Version;
            XmlTextWriter writer = null;

            using (writer = new XmlTextWriter(Program.CommandHistoryFileName, Encoding.UTF8))
            {
                writer.Formatting = Formatting.Indented;

                writer.WriteStartDocument();
                writer.WriteStartElement(Assembly.GetExecutingAssembly().GetName().Name);
                writer.WriteAttributeString("version", version.Major.ToString() + "." + version.Minor.ToString());
                writer.WriteStartElement("CommandHistoryList");

                foreach (string str in Program.CommandHistoryList)
                {
                    writer.WriteStartElement("CommandHistory");

                    writer.WriteStartElement("Command");
                    writer.WriteString(str);
                    writer.WriteEndElement();

                    writer.WriteEndElement();
                }
                writer.WriteEndElement();
                writer.WriteEndElement();
                writer.Flush();
                writer.Close();
            }
        }

        public static bool WriteMacroList()
        {
            Version version = Assembly.GetExecutingAssembly().GetName().Version;
            XmlTextWriter writer = null;

            using (writer = new XmlTextWriter(Program.MacroFileName, Encoding.UTF8))
            {
                writer.Formatting = Formatting.Indented;

                writer.WriteStartDocument();
                writer.WriteStartElement(Assembly.GetExecutingAssembly().GetName().Name);
                writer.WriteAttributeString("version", version.Major.ToString() + "." + version.Minor.ToString());
                writer.WriteStartElement("MacroList");

                foreach (MacroInfo info in Program.MacroDic.Values)
                {
                    writer.WriteStartElement("Macro");

                    writer.WriteStartElement("Id");
                    writer.WriteString(info.Macro.Id());
                    writer.WriteEndElement();

                    writer.WriteStartElement("Shortcut");
                    //writer.WriteString(info.Shortcut.ToString());
                    writer.WriteEndElement();

                    writer.WriteEndElement();
                }
                writer.WriteEndElement();
                writer.WriteEndElement();
                writer.Flush();
                writer.Close();
            }

            return true;
        }

        public static bool WriteSentenceList()
        {
            Version version = Assembly.GetExecutingAssembly().GetName().Version;
            XmlTextWriter writer = null;

            string file;

            if (Settings.ContainsKey(Settings.PASSER_SENTENCELIST_DIR))
            {
                file = Settings.Get(Settings.PASSER_SENTENCELIST_DIR);
                if (file[file.Length - 1] == '\\')
                    file = file.Substring(0, file.Length - 1);
                file += @"\SentenceList.xml";
            }
            else
                file = Program.SentenceFileName;

            using (writer = new XmlTextWriter(file, Encoding.UTF8))
            {
                writer.Formatting = Formatting.Indented;

                writer.WriteStartDocument();
                writer.WriteStartElement(Assembly.GetExecutingAssembly().GetName().Name);
                writer.WriteAttributeString("version", version.Major.ToString() + "." + version.Minor.ToString());
                writer.WriteStartElement("SentenceList");
                for (int i = 0; i < Program.SentenceGroupList.Length; i++)
                {
                    List<SentenceInfo> list = Program.SentenceGroupList[i];
                    writer.WriteStartElement("Group");
                    writer.WriteAttributeString("id", i.ToString());
                    writer.WriteAttributeString("name", Program.sentenceGroupName[i]);

                    if (list != null)
                    {
                        foreach (SentenceInfo info in list)
                        {
                            writer.WriteStartElement("Sentence");

                            writer.WriteStartElement("Name");
                            writer.WriteString(info.Name);
                            writer.WriteEndElement();

                            writer.WriteStartElement("Id");
                            writer.WriteString(info.Id);
                            writer.WriteEndElement();

                            writer.WriteStartElement("Type");
                            writer.WriteString(info.Type.ToString());
                            writer.WriteEndElement();

                            writer.WriteStartElement("Shortcut");
                            writer.WriteString(info.Shortcut.ToString());
                            writer.WriteEndElement();

                            writer.WriteStartElement("Value");
                            writer.WriteString(info.Value);
                            writer.WriteEndElement();

                            writer.WriteEndElement();
                        }
                    }
                    writer.WriteEndElement();
                }
                writer.WriteEndElement();
                writer.WriteEndElement();

                writer.Flush();
                writer.Close();
            }
            
            return true;
        }


        /// <summary>
        /// Passerのコマンド解析
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string[] ParseCommand(string str)
        {
            List<string> ret = new List<string>();
            string[] lines = str.Split(' ');

            for (int i = 0; i < lines.Length; i++)
            {
                string line = lines[i];
                ret.Add(line);
            }

            while (ret.Count > 1)
            {
                if (!"".Equals(ret[ret.Count - 1].Trim()))
                    break;

                string s = ret[ret.Count - 1];
                ret.RemoveAt(ret.Count - 1);
                ret[ret.Count - 1] += " " + s;

            }
            return ret.ToArray();
        }


        /// <summary>
        /// FileSearchのファイル解析
        /// 
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string[] ParseFile(string str)
        {
/*
            //エイリアスを書き換え
            StringBuilder sb = new StringBuilder();
            string[] lines = str.Split('\\');
            int j = lines.Length;
            for(int i = 0; i < j; i++)
            {
                if (Program.AliasDic.ContainsKey(lines[i]))
                    sb.Append(Program.AliasDic[lines[i]]);
                else
                    sb.Append(lines[i]);

                if(i + 1 < j)
                    sb.Append('\\');
            }

            str = sb.ToString();
*/
            int j;
            List<string> ret = new List<string>();
            string[] lines = str.Split(' ');

            for (int i = 0; i < lines.Length; i++)
            {
                string line = lines[i];
                
                //ドライブが指定されている
                if (line.Length > 1 && line.Substring(1).StartsWith(@":\"))
                {
                    int lindex = line.LastIndexOf('\\') + 1;
                    int fileCount = 0;
                    string buf;
                    string directory = line.Substring(0, lindex);
                    string file = line.Substring(lindex);
                    try
                    {
                        fileCount = Directory.GetFileSystemEntries(directory, file + "*").Length;
                    }
                    catch
                    {
                        //return ret.ToArray(); ;
                    }
                    if (fileCount == 0)
                    {
                        ret.Add(line);
                    }
                    else
                    {
                        j = 1;
                        while (lines.Length > i + j)
                        {
                            if (lines[i + j].Length > 1 && lines[i + j].Substring(1).StartsWith(@":\"))
                            {
                                j--;
                                break;
                            }

                            buf = line + " " + lines[i + j];
                            lindex = buf.LastIndexOf('\\') + 1;
                            directory = buf.Substring(0, lindex);
                            file = buf.Substring(lindex);
                            line = buf;
                            try
                            {
                                if (!Directory.Exists(directory) || Directory.GetFileSystemEntries(directory, file + "*").Length == 0)
                                    break;
                            }
                            catch
                            {
                                j--;
                                break;
                            }
                            j++;
                        }
                        ret.Add(line);
                        i += j;
                    }
                }
                else
                {
                    ret.Add(line);
                }
            }

            while (ret.Count > 1)
            {
                if (!"".Equals(ret[ret.Count - 1].Trim()))
                    break;

                string s = ret[ret.Count - 1];
                ret.RemoveAt(ret.Count - 1);
                ret[ret.Count - 1] += " " + s;

            }
            return ret.ToArray();
        }
        
        public static Rectangle GetSentenceFormBaseRectangle()
        {
            Rectangle r = Program.GetCaretRect();
            if (r.Top == 0)
            {
                Point p = new Point();
                ghook.GetCaretPoint(ref p);
                if (p.X != 0 && p.Y != 0)
                {
                    r.Location = p;
                    r.Width = r.Left + 2;
                    r.Height = r.Top + 16;
                }
                else
                {
                    r.Location = Control.MousePosition;
                    //r.Width = r.X + Cursors.Default.Size.Width;
                    //r.Height = r.Y + Cursors.Default.Size.Height;
                    r.Width = r.Left + 2;
                    r.Height = r.Top + 16;
                }
            }
            return r;
        }

        public static Bitmap GetBitmap(ShellObject o)
        {
            if(Program.ShellIconDic.ContainsKey(o.ParsingName))
                return Program.ShellIconDic[o.ParsingName];

            Bitmap bitmap;
            PngBitmapEncoder encoder = new PngBitmapEncoder();
            using (Stream stream = new MemoryStream())
            {
                encoder.Frames.Add(BitmapFrame.Create(o.Thumbnail.SmallBitmapSource));
                encoder.Save(stream);
                bitmap = new Bitmap(Image.FromStream(stream));
            }
            Program.ShellIconDic.Add(o.ParsingName, bitmap);
            return bitmap;
        }

        public static ShellLibrary GetShellLibrary(string name)
        {
            if("ドキュメント".Equals(name))
            {
                return ShellLibrary.Load("Documents", false);
            }
            if("ピクチャ".Equals(name))
            {
                return ShellLibrary.Load("Pictures", false);
            }
            if("ビデオ".Equals(name))
            {
                return ShellLibrary.Load("Videos", false);
            }
            if("ミュージック".Equals(name))
            {
                return ShellLibrary.Load("Music", false);
            }

            try
            {
                return ShellLibrary.Load(name, false);
            }
            catch
            {
                return null;
            }
        }

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            if (Environment.OSVersion.Platform != PlatformID.Win32NT)
            {
                MessageBox.Show("動作対象外のOSです", "Passer");
                Application.Exit();
                return;
            }
            if (Environment.OSVersion.Version.Major < 5) //2000,XP
            {
                MessageBox.Show("動作対象外のOSです", "Passer");
                Application.Exit();
                return;
            }

            mutex = new Mutex(false, "Lugens.Passer");
            if (!mutex.WaitOne(0, false))
            {
                MessageBox.Show("既に起動しています", "Passer");
                Application.Exit();
                return;
            }

            //ディレクトリアイコン取得
            Win32.SHFILEINFO shinfo = new Win32.SHFILEINFO();
            Win32.SHGetFileInfo(Environment.SystemDirectory, 0, ref shinfo, Marshal.SizeOf(shinfo), Win32.SHGFI_ICON | Win32.SHGFI_LARGEICON);
            Program.DirectoryIcon = System.Drawing.Icon.FromHandle(shinfo.hIcon);

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Settings.Load(Program.SettingFileName);
            Program.ReadCommandList();
            Program.ReadCommandHistoryList();
            if (!Program.ReadMacroList())
            {
                Application.Exit();
                return;
            }
            Program.ReadSentenceList();
            Program.ReadEngineList();
            Program.ReadSetting();
            Program.MainForm = new MainForm();
            Program.MainFormHandle = Program.MainForm.Handle;
            Program.MainForm.ReadSetting();
            Program.MainForm.ReadCommandList();
            Program.SettingForm = new SettingForm();
            Program.Status = ProgramStatus.Waiting;
            Application.Run();
            
        }
    }

    /// <summary>
    /// プログラムのステータス
    /// </summary>
    public enum ProgramStatus
    {
        /// <summary>
        /// 初期化中
        /// </summary>
        Loading,

        /// <summary>
        /// 入力待ち状態
        /// </summary>
        Waiting,

        /// <summary>
        /// メッセージ送信中
        /// </summary>
        SendMessaging,

        /// <summary>
        /// メッセージ送信終了中
        /// </summary>
        SendMessageClosing,

        /// <summary>
        /// メインフォーム表示状態
        /// </summary>
        MainFormOpen,

        /// <summary>
        /// 検索エンジン選択状態
        /// </summary>
        SelectingSearchEngine,

        /// <summary>
        /// 設定フォーム表示状態
        /// </summary>
        SettingFormOpen,

        /// <summary>
        /// 定型文フォーム表示状態
        /// </summary>
        SentenceFormOpen,

        /// <summary>
        /// ポップアップフォーム表示状態
        /// </summary>
        PopupFormOpen,

        /// <summary>
        /// バージョンフォーム表示状態
        /// </summary>
        VersionFormOpen,

        /// <summary>
        /// 処理実行中
        /// </summary>
        Executing,

        /// <summary>
        /// キーボード記憶中
        /// </summary>
        KeyRecoding,

        /// <summary>
        /// ホットキーコントロールフォーカス状態
        /// </summary>
        HotKeyTextBoxFocus
    }
    
    public class CommandInfo
    {
        /// <summary>
        /// コマンド名
        /// </summary>
        public string Name;

        /// <summary>
        /// 対象ファイル
        /// </summary>
        public string Target;

        /// <summary>
        /// 実行時のパス
        /// </summary>
        public string Path;

        /// <summary>
        /// 引数
        /// </summary>
        public string Arguments;

        /// <summary>
        /// コメント
        /// </summary>
        public string Comment;

        /// <summary>
        /// アイコン
        /// </summary>
        public Icon ApplicationIcon;
    }

    public class SentenceInfo
    {
        /// <summary>
        /// 設定名
        /// </summary>
        public string Name;

        /// <summary>
        /// ID
        /// </summary>
        public string Id;

        /// <summary>
        /// グループ
        /// </summary>
        public int Group;

        /// <summary>
        /// ショートカットキー
        /// </summary>
        public int Shortcut;

        /// <summary>
        /// タイプ(0.SENTENCE 1.SCRIPT)
        /// </summary>
        public int Type;

        /// <summary>
        /// 定型文
        /// </summary>
        public string Value;

        /// <summary>
        /// リスト表示用
        /// </summary>
        public IconListBoxItem Item;
    }

    public class KeyRecordInfo
    {
        /// <summary>
        /// 次のいずれかメッセージ
        /// WM_APP_KEYDOWN  WM_APP_KEYUP  WM_APP_CHAR WM_APP_IME_START  WM_APP_IME_END  WM_APP_IME_COMP
        /// </summary>
        public int Message;

        /// <summary>
        /// キーコード
        /// </summary>
        public int Keycode;

        /// <summary>
        /// バーチャルキー
        /// </summary>
        public int VkCode;

        /// <summary>
        /// 出力文字列
        /// </summary>
        public string Str;

        public void DebugPrint()
        {
            switch (Message)
            {
                case Program.WM_APP_KEYDOWN:
                    Debug.WriteLine("WM_APP_KEYDOWN:" + Keycode + "," + VkCode.ToString("X") + "," + Str);
                    break;
                case Program.WM_APP_KEYUP:
                    Debug.WriteLine("WM_APP_KEYUP:" + Keycode + "," + VkCode.ToString("X") + "," + Str);
                    break;
                case Program.WM_APP_CHAR:
                    Debug.WriteLine("WM_APP_CHAR:" + Keycode + "," + VkCode.ToString("X") + "," + Str);
                    break;
                case Program.WM_APP_IME_START:
                    Debug.WriteLine("WM_APP_IME_START");
                    break;
                case Program.WM_APP_IME_END:
                    Debug.WriteLine("WM_APP_IME_END");
                    break;
                case Program.WM_APP_IME_COMP:
                    Debug.WriteLine("WM_APP_IME_COMP:" + Str);
                    break;
            }
        }
    }

    public class MacroInfo
    {
        /// <summary>
        /// マクロ
        /// </summary>
        public IMacro Macro;

        /// <summary>
        /// リスト表示用
        /// </summary>
        public IconListBoxItem Item;
    }
    



}