﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Lugens.Passer
{
    static class Crypt
    {
        static Random rand = new Random();
        static char[] invalidChars = { '<', '>', '&', '[', (char)127 };

        public static String Encrypt(String str)
        {
            uint dummyKey = 0;
            ushort symmetricalKey = 0;
            String encryptString = "";

            //ダミー鍵をランダム生成(32bit)
            for (int i = 0; i < 4; i++)
            {
                dummyKey <<= 8;
                dummyKey += NextValidChar();
            }

            //ダミー鍵から共通鍵を作成(16bit) 端同士のビットのXORを鍵とする
            byte left, right;
            for (int i = 0; i < 16; i++)
            {
                left = (byte)(dummyKey >> (31 - i) & 0x01);
                right = (byte)(dummyKey >> i & 0x01);
                symmetricalKey <<= 1;
                symmetricalKey += (byte)((left ^ right) & 0x01);
            }

            //ダミー鍵を暗号文字列に組み込み
            for (int i = 0; i < 4; i++)
            {
                encryptString = (char)(dummyKey >> (i * 8) & 0xFF) + encryptString;
            }

            //1バイトずつXORを取る
            char c;
            char[] nibble = new char[5];

            for (int i = 0; i < str.Length; i++)
            {
                c = str[i];
                nibble[0] = (char)(c >> 12 & 0x0F);
                nibble[1] = (char)(c >> 8 & 0x0F);
                nibble[2] = (char)(c >> 4 & 0x0F);
                nibble[3] = (char)(c & 0x0F);

                for (int j = 0; j < 4; j++)
                {
                    while (true)
                    {
                        nibble[4] = (char)(nibble[j] ^ (char)(symmetricalKey & 0x0F));
                        nibble[4] = (char)(nibble[4] | (char)(rand.Next(3, 8) << 4));
                        if (Check(nibble[4]))
                        {
                            break;
                        }
                    }
                    symmetricalKey = (ushort)(((symmetricalKey >> 1) & 0x7FFF) | ((symmetricalKey & 0x01) << 15)); //ローテートシフト
                    encryptString += nibble[4];
                }
            }
            return encryptString;
        }

        public static String Decrypt(String str)
        {
            char c;
            uint dummyKey = 0;
            ushort symmetricalKey = 0;
            String decryptString = "";

            //フォーマットチェック
            for (int i = 0; i < str.Length; i++)
            {
                c = str[i];
                if (!Check(c))
                {
                    return null;
                }
            }


            //ダミー鍵を取得(32bit)
            for (int i = 0; i < 4; i++)
            {
                dummyKey <<= 8;
                dummyKey += str[i];
            }
            str = str.Substring(4);
            if (str.Length == 0)
            {
                return "";
            }

            //ダミー鍵から共通鍵を作成(16bit) 端同士のビットのXORを鍵とする
            byte left, right;
            for (int i = 0; i < 16; i++)
            {
                left = (byte)(dummyKey >> (31 - i) & 0x01);
                right = (byte)(dummyKey >> i & 0x01);
                symmetricalKey <<= 1;
                symmetricalKey += (byte)((left ^ right) & 0x01);
            }


            //1バイトずつXORを取る
            int len = str.Length >> 2;
            char[] nibble = new char[5];

            for (int i = 0; i < len; i++)
            {
                nibble[0] = (char)((char)str[i * 4 + 0] & 0x0F);
                nibble[1] = (char)((char)str[i * 4 + 1] & 0x0F);
                nibble[2] = (char)((char)str[i * 4 + 2] & 0x0F);
                nibble[3] = (char)((char)str[i * 4 + 3] & 0x0F);
                nibble[4] -= nibble[4];
                for (int j = 0; j < 4; j++)
                {
                    nibble[4] <<= 4;
                    nibble[4] |= (char)(nibble[j] ^ (char)((symmetricalKey & 0x0F)));
                    symmetricalKey = (ushort)(((symmetricalKey >> 1) & 0x7FFF) | ((symmetricalKey & 0x01) << 15)); //ローテートシフト
                }
                decryptString += nibble[4];
            }
            return decryptString;
        }

        private static String ToBin(int n)
        {
            String str = "";
            for (int i = 0; i < 32; i++)
            {
                if (i > 0 && ((i & 0x03) == 0))
                {
                    str = ' ' + str;
                }
                str = (n & 0x01).ToString() + str;
                n >>= 1;
            }

            return str;
        }

        private static bool Check(char c)
        {
            foreach (char check in invalidChars)
            {
                if (check == c)
                {
                    return false;
                }
            }
            return true;
        }

        private static char NextValidChar()
        {
            char c;
            while (true)
            {
                c = (char)rand.Next(33, 127);
                if (Check(c))
                {
                    return c;
                }
            }
        }

    }
}
