using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Text;
using System.IO;
using System.Windows.Forms;
using Lugens.Utils;

namespace Lugens.Passer
{
    public partial class AddCommandForm : Form
    {
        public AddCommandForm()
        {
            InitializeComponent();
            this.Init();
        }

        public AddCommandForm(string targetFile) : this()
        {
            SetSelectedFile(targetFile);
        }

        public void Init()
        {
            this.textBox_command.Text = "VR}h";
            this.textBox_target.Text = "";
            this.textBox_path.Text = "";
            this.textBox_arguments.Text = "";
            this.textBox_comment.Text = "";
        }

        private string ExtractCommandName(string filename)
        {
            int fileIndex = filename.LastIndexOf('\\');
            if (fileIndex == -1)
            {
                fileIndex = 0;
            }
            string command = filename.Substring(fileIndex + 1);
            if (command.LastIndexOf('.') != -1)
            {
                command = command.Substring(0, command.LastIndexOf('.'));
            }
            return command;
        }

        private string ExtraCommandPath(string filename)
        {
            int fileIndex = filename.LastIndexOf('\\');
            if (fileIndex == -1)
            {
                fileIndex = 0;
            }
            return filename.Substring(0, fileIndex);
        }

        public void SetSelectedFile(string filename)
        {
            IntPtr ret;
            Win32.SHFILEINFO info = new Win32.SHFILEINFO();

            ret = Win32.SHGetFileInfo(filename, 0, ref info, Marshal.SizeOf(info), Win32.SHGFI_ATTRIBUTES);
            if (ret == IntPtr.Zero) return;


            if ((info.dwAttributes & Win32.SFGAO_LINK) != 0)
            {
                //V[gJbg̏ꍇ
                ShellLink shellLink = new ShellLink(filename);
                string targetfile = shellLink.TargetPath;
                this.textBox_command.Text = ExtractCommandName(filename);
                this.textBox_target.Text = targetfile;
                this.textBox_path.Text = shellLink.WorkingDirectory;
                this.textBox_arguments.Text = shellLink.Arguments;
                this.textBox_comment.Text = shellLink.Description;
                if (this.textBox_path.Text.Length == 0)
                {
                    this.textBox_path.Text = ExtraCommandPath(targetfile);
                }
                shellLink.Close();
                shellLink = null;
            }
            else
            {
                //t@CAtH_̏ꍇ
                this.textBox_command.Text = ExtractCommandName(filename);
                this.textBox_target.Text = filename;
                this.textBox_path.Text = ExtraCommandPath(filename);
            }
            this.textBox_command.Text = this.textBox_command.Text.Replace(' ', '_');

            if(Program.SettingForm.CommandDicTmp.ContainsKey(this.textBox_command.Text))
            {
                string text;
                for (int i = 2; i < 256; i++)
                {
                    text = this.textBox_command.Text + i;
                    if (!Program.SettingForm.CommandDicTmp.ContainsKey(text))
                    {
                        this.textBox_command.Text = text;
                        break;
                    }

                }
            }

        }

        private void button_view_Click(object sender, EventArgs e)
        {

            if (DialogResult.OK == openFileDialog1.ShowDialog(this))
            {
                SetSelectedFile(openFileDialog1.FileName);
            }
        }

        private void textBox_command_TextChanged(object sender, EventArgs e)
        {
            if (Program.SettingForm == null)
                return;

            if (String.IsNullOrEmpty(this.textBox_command.Text))
            {
                this.label_duplicate.Visible = false;
                this.button_ok.Enabled = false;
                return;
            }
            if (Program.DefaultCommand.Equals(this.textBox_command.Text))
            {
                this.label_duplicate.Visible = false;
                this.button_ok.Enabled = true;
                return;
            }
            if (this.textBox_command.Text[0] == '\\' || this.textBox_command.Text[0] == '!' || this.textBox_command.Text[0] == '$' || this.textBox_command.Text[0] == ':' || this.textBox_command.Text[0] == '@')
            {
                this.label_duplicate.Text = "͂ꂽL͎gpł܂";
                this.label_duplicate.Visible = true;
                this.button_ok.Enabled = false;
                return;
            }
            if (this.textBox_command.Text.IndexOf(' ') != -1)
            {
                this.label_duplicate.Text = "Xy[X͎gpł܂";
                this.label_duplicate.Visible = true;
                this.button_ok.Enabled = false;
                return;
            }
            if (Program.SettingForm.CommandDicTmp.ContainsKey(this.textBox_command.Text))
            {
                this.label_duplicate.Text = "dĂ܂";
                this.label_duplicate.Visible = true;
                this.button_ok.Enabled = false;
            }
            else
            {
                this.label_duplicate.Visible = false;
                this.button_ok.Enabled = true;
            }
        }

        private void AddCommandForm_Load(object sender, EventArgs e)
        {
            //this.textBox_command.Text = "VR}h";
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            if (Program.SettingForm.CommandDicTmp.ContainsKey(this.textBox_command.Text))
            {
                MessageBox.Show(this, "R}hdĂ܂", "o^G[", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (String.IsNullOrEmpty(this.textBox_target.Text))
            {
                MessageBox.Show(this, "t@Cw肳Ă܂", "o^G[", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!File.Exists(this.textBox_target.Text))
            {
                MessageBox.Show(this, "t@C݂܂\n" + this.textBox_target.Text, "o^G[", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            CommandInfo info = new CommandInfo();
            info.Name = this.textBox_command.Text;
            info.Target = this.textBox_target.Text;
            info.Path = this.textBox_path.Text;
            info.Arguments = this.textBox_arguments.Text;
            info.Comment = this.textBox_comment.Text.Length == 0 ? null : this.textBox_comment.Text;
            Program.AddCommand(Program.SettingForm.CommandDicTmp, Program.SettingForm.CommandListTmp, info);
            Program.SettingForm.ReadCommandList(true);
            Program.SettingForm.RequestCommandListViewSelect(info.Name);

            this.Visible = false;
        }

        private void button_cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void AddCommandForm_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.Copy;
            }
        }

        private void AddCommandForm_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (String[])e.Data.GetData(DataFormats.FileDrop);
            if (files == null || files.Length == 0)
            {
                return;
            }
            string file = files[0];

            this.SetSelectedFile(file);
        }

        private void AddCommandForm_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible)
                Program.ForceForegroundWindow(this.Handle);
        }
    }
}