﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using System.Drawing;
using Lugens.Utils;
using System.Diagnostics;

namespace Lugens.Passer.Macro
{
    public delegate void MacroEventHandler(string result);

    public enum MacroType
    {
        InOutText,
        CutOutText,
        OutText,
        InOutPopup,
        OutPopup
    }

    public interface IMacro
    {
        event MacroEventHandler OnMacroCompleted;

        /// <summary>
        /// マクロID
        /// </summary>
        /// <returns></returns>
        string Id();

        /// <summary>
        /// マクロ機能初期化
        /// </summary>
        bool Init();

        /// <summary>
        /// マクロタイプ
        /// </summary>
        /// <returns></returns>
        MacroType Type();

        /// <summary>
        /// マクロ機能名
        /// </summary>
        /// <returns></returns>
        string Name();

        /// <summary>
        /// マクロ機能概要
        /// </summary>
        /// <returns></returns>
        string Summary();
        
        /// <summary>
        /// マクロ機能説明
        /// </summary>
        /// <returns></returns>
        string Description();

        /// <summary>
        /// マクロテスト実行
        /// </summary>
        /// <returns></returns>
        bool Test();

        /// <summary>
        /// マクロ実行
        /// </summary>
        /// <param name="str"></param>
        /// <param name="args"></param>
        void ExecuteAsync(string str, params string[] args);
    }

    public static class MacroExecuter
    {
        private delegate void PopupTextDelegate(string text);

        private static int currentCode = -1;

        private static IMacro currentMacro = null;

        private static int keycode;
        public static void ExecuteAsync(int keycode, IMacro macro, params string[] args)
        {
            string str;
            MacroExecuter.keycode = keycode;
            MacroExecuter.currentCode = macro.GetHashCode();
            MacroExecuter.currentMacro = macro;

            switch (macro.Type())
            {
                case MacroType.CutOutText:
                    Program.SendMessage("${LControl+}${X}${LControl-}", keycode);
                    str = Clipboard.GetText();
                    macro.OnMacroCompleted += OnMacroCompleted;
                    MacroExecuter.currentMacro.ExecuteAsync(str, args);
                    break;

                case MacroType.OutText:
                    macro.OnMacroCompleted += OnMacroCompleted;
                    MacroExecuter.currentMacro.ExecuteAsync(null, args);
                    break;

                case MacroType.InOutPopup:
                    Program.SendMessage("${LControl+}${C}${LControl-}", keycode);
                    str = Clipboard.GetText();
                    if (!String.IsNullOrEmpty(str))
                    {
                        Program.PopupForm = new PopupForm();
                        Point p = Control.MousePosition;
                        p.X += 2;
                        p.Y += 16;
                        Program.PopupForm.Location = p;
                        Program.PopupForm.DoVisibleChange(true);
                        macro.OnMacroCompleted += OnMacroCompleted;
                        MacroExecuter.currentMacro.ExecuteAsync(str, args);
                    }
                    else
                    {
                        Program.Status = ProgramStatus.Waiting;
                    }
                    break;
            }
        }

        public static void SetPopupText(string text)
        {
            Program.PopupForm.Loading = false;
            Program.PopupForm.Text = text;
        }

        public static void OnMacroCompleted(string result)
        {
            if (MacroExecuter.currentCode == -1)
            {
                Program.Status = ProgramStatus.Waiting;
                return;
            }

            switch (MacroExecuter.currentMacro.Type())
            {
                case MacroType.InOutText:
                case MacroType.CutOutText:
                case MacroType.OutText:
                    if (!String.IsNullOrEmpty(result))
                    {
                        Clipboard.SetText(result);
                        Application.DoEvents();
                        int keycode = Program.EnabledKeycode(MacroExecuter.keycode);
                        Program.SendMessage("${LControl+}${V}${LControl-}", keycode);
                    }
                    Program.Status = ProgramStatus.Waiting;
                    break;

                case MacroType.InOutPopup:
                case MacroType.OutPopup:
                    if(!Program.PopupForm.IsDisposed)
                    {
                        Program.PopupForm.RequestSetText(result);
                    }
                    break;

            }
            currentCode = -1;
            currentMacro.OnMacroCompleted -= OnMacroCompleted;
            currentMacro = null;
        }
    }
}
