﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.VisualBasic;

namespace Lugens.Passer.Macro.Text
{
    public class ToUpperMacro : IMacro
    {

        event MacroEventHandler macroCompletedEvent;

        event MacroEventHandler IMacro.OnMacroCompleted
        {
            add { macroCompletedEvent += value; }
            remove { macroCompletedEvent -= value; }
        }

        public string Id()
        {
            return "Lugens.Passer.Macro.Text.ToUpper";
        }

        public MacroType Type()
        {
            return MacroType.CutOutText;
        }

        public bool Init()
        {
            return true;
        }

        public string Name()
        {
            return "ToUpper";
        }

        public string Summary()
        {
            return "アルファベットの小文字を大文字に変換します";
        }

        public string Description()
        {
            return new StringBuilder()
                .Append("引数：なし").Append(Environment.NewLine)
                .Append(Environment.NewLine)
                .Append("abcａｂｃ　⇒　 ABCＡＢＣ").ToString();
        }

        public bool Test()
        {
            return true;
        }

        public void ExecuteAsync(string str, string[] args)
        {
            string result = "";
            if (!String.IsNullOrEmpty(str))
                result = Strings.StrConv(str, VbStrConv.Uppercase, 0);

            if (macroCompletedEvent != null)
                macroCompletedEvent(result);
        }

    }
}
