﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.VisualBasic;
using System.Globalization;

namespace Lugens.Passer.Macro.Text
{
    public class DateTimeMacro : IMacro
    {

        event MacroEventHandler macroCompletedEvent;

        event MacroEventHandler IMacro.OnMacroCompleted
        {
            add { macroCompletedEvent += value; }
            remove { macroCompletedEvent -= value; }
        }

        public string Id()
        {
            return "Lugens.Passer.Macro.Text.DateTime";
        }

        public MacroType Type()
        {
            return MacroType.OutText;
        }
        
        public bool Init()
        {
            return true;
        }

        public string Name()
        {
            return "DateTime";
        }

        public string Summary()
        {
            return "現在の日付/時刻を出力します";
        }

        public string Description()
        {
            return new StringBuilder()
                .Append("引数：0～1個").Append(Environment.NewLine)
                .Append(Environment.NewLine)
                .Append("引数なし　　　　⇒　2010/01/01 01:23:45").Append(Environment.NewLine)
                .Append("yyyy年M月d日　　⇒　2010年1月1日").Append(Environment.NewLine)
                .Append("MM月dd日　　　　⇒　01月01日").Append(Environment.NewLine)
                .Append("HH時mm分ss秒　　⇒　01時23分45秒").Append(Environment.NewLine)
                .Append("ggyy年MM月dd日　⇒　平成22年01月01日").Append(Environment.NewLine)
                .Append("ggyy年⇔yyyy年　⇒　平成22年⇔2010年").Append(Environment.NewLine)
                .ToString();
        }

        public bool Test()
        {
            return true;
        }

        public void ExecuteAsync(string str, string[] args)
        {
            CultureInfo culture = new CultureInfo("ja-JP", true);
            culture.DateTimeFormat.Calendar = new JapaneseCalendar();
            DateTime dt = DateTime.Now;

            if (args == null || args.Length == 0)
            {
                if (macroCompletedEvent != null)
                    macroCompletedEvent(dt.ToString("yyyy/MM/dd HH:mm:ss"));
                return;
            }

            string arg = "";
            foreach (string s in args)
            {
                arg += s + " ";
            }
            arg = arg.Substring(0, arg.Length - 1);

            string ggyy = dt.ToString("ggyy", culture);
            arg = arg.Replace("ggyy", ggyy);

            if (macroCompletedEvent != null)
                macroCompletedEvent(dt.ToString(arg));
        }
    }
}
