﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Globalization;
using System.Net;
using System.IO;
using System.Web;

namespace Lugens.Passer.Macro.Google
{
    public class TranslationMacro : IMacro
    {
        string str;

        event MacroEventHandler macroCompletedEvent;

        event MacroEventHandler IMacro.OnMacroCompleted
        {
            add { macroCompletedEvent += value; }
            remove { macroCompletedEvent -= value; }
        }
         
        public string Id()
        {
            return "Lugens.Passer.Macro.Google.PopupTranslation";
        }

        public MacroType Type()
        {
            return MacroType.InOutPopup;
        }

        public bool Init()
        {
            return true;
        }

        public string Name()
        {
            return "GoogleTranslation";
        }

        public string Summary()
        {
            return "翻訳します";
        }

        public string Description()
        {
            return new StringBuilder()
                .Append("引数：2個").Append(Environment.NewLine)
                .ToString();
        }

        public string Execute(string str, string[] args)
        {
            return null;
        }


        public void ExecuteAsync(string str, string[] args)
        {
            this.str = str;
            WebRequest webReq = HttpWebRequest.Create("http://ajax.googleapis.com/ajax/services/language/translate");
            webReq.Proxy = WebProxy.GetDefaultProxy();
            webReq.Method = "POST";
            webReq.ContentType = "application/x-www-form-urlencoded";

            AsyncCallback writeCallBack = new AsyncCallback(WriteCallBack);
            IAsyncResult r = webReq.BeginGetRequestStream(writeCallBack, webReq);
            r.AsyncWaitHandle.WaitOne();

            AsyncCallback readCallBack = new AsyncCallback(ReadCallBack);
            IAsyncResult rAr = webReq.BeginGetResponse(readCallBack, webReq);
        }

        private void ReadCallBack(IAsyncResult ar)
        {
            HttpWebRequest req = (HttpWebRequest)ar.AsyncState;
            HttpWebResponse response = (HttpWebResponse)req.EndGetResponse(ar);
            StreamReader sr = new StreamReader(response.GetResponseStream());
            string str = sr.ReadToEnd();
            string result = "";
            sr.Close();

            int index = str.IndexOf("\"translatedText\"");
            if (index != -1)
            {
                index += "\"translatedText\"".Length;
                int sIndex = str.IndexOf('"', index);
                int eIndex = str.IndexOf('"', sIndex + 1);

                result = str.Substring(sIndex + 1, eIndex - sIndex - 1);
                result = result.Replace("\\u003d", "\u003d").Replace("\\u0026", "\u0026");
                result = HttpUtility.HtmlDecode(result);
            }

            if (macroCompletedEvent != null)
                macroCompletedEvent(result);
        }

        private void WriteCallBack(IAsyncResult ar)
        {
            HttpWebRequest req = (HttpWebRequest)ar.AsyncState;
            StreamWriter sw = new StreamWriter(req.EndGetRequestStream(ar));
            string parameters = "v=1.0&langpair=en%7Cja&q=" + HttpUtility.UrlEncode(this.str);
            sw.Write(parameters);
            sw.Close();
        }

        public bool Test()
        {
            return true;
        }

    }

}
