package jp.sf.pal.webparts.jetspeed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.portlet.ActionRequest;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.CommonPortletServices;
import org.apache.jetspeed.PortalReservedParameters;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.request.RequestContext;

public class WebPartsPortlet extends jp.sf.pal.webparts.WebPartsPortlet {
    public static final String USE_PAGE_PREFERENCES = "jp.sf.pal.webparts.UsePagePreferences";

    public static final String FRAGMENT_ID = "jp.sf.pal.webparts.Fragment";

    private boolean usePagePreferences = false;

    private PageManager pageManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);

        // use page preferences?
        String value = config.getInitParameter(USE_PAGE_PREFERENCES);
        if (value != null && value.equalsIgnoreCase("true")) {
            usePagePreferences = true;
        }

        // pageManager
        pageManager = (PageManager) getPortletContext().getAttribute(
                CommonPortletServices.CPS_PAGE_MANAGER_COMPONENT);
        if (null == pageManager) {
            throw new PortletException(
                    "Failed to find the Page Manager on portlet initialization");
        }
    }

    protected String getDefaultEditPage() {
        return "/WEB-INF/jsp/edit-for-jetspeed.jsp";
    }

    protected void setEditContent(RenderRequest request) {
        if (usePagePreferences) {
            Fragment fragment = getCurrentFragment(request);
            request.setAttribute(TITLE, getFragmentPreferenceValue(fragment,
                    TITLE, defaultTitle));
            request.setAttribute(URL, getFragmentPreferenceValue(fragment, URL,
                    defaultUrl));
            request.setAttribute(CODE, getFragmentPreferenceValue(fragment,
                    CODE, defaultCode));

            String fragmentId = fragment.getId();
            request.setAttribute(FRAGMENT_ID, fragmentId);
        } else {
            super.setEditContent(request);
        }
    }

    protected void setViewContent(RenderRequest request) {
        if (usePagePreferences) {
            Fragment fragment = getCurrentFragment(request);
            request.setAttribute(TITLE, getFragmentPreferenceValue(fragment,
                    TITLE, defaultTitle));
            request.setAttribute(CODE, getFragmentPreferenceValue(fragment,
                    CODE, defaultCode));

            String fragmentId = fragment.getId();
            request.setAttribute(FRAGMENT_ID, fragmentId);
        } else {
            super.setViewContent(request);
        }
    }

    protected void storeContent(ActionRequest request) throws Exception {
        if (usePagePreferences) {
            String fragmentId = request.getParameter(FRAGMENT_ID);
            if (fragmentId == null) {
                throw new IllegalStateException("The fragment id is null.");
            }

            String codeValue = request.getParameter(CODE);
            if (codeValue == null) {
                codeValue = "";
            }
            String titleValue = request.getParameter(TITLE);
            if (titleValue == null) {
                titleValue = "";
            }
            String urlValue = request.getParameter(URL);
            if (urlValue == null) {
                urlValue = "";
            }

            ContentPage page = getCurrentPage(request);
            Fragment fragment = page.getFragmentById(fragmentId);

            setFragmentPreferenceValue(fragment, CODE, codeValue);
            setFragmentPreferenceValue(fragment, TITLE, titleValue);
            setFragmentPreferenceValue(fragment, URL, urlValue);

            pageManager.updatePage(page);
        } else {
            super.storeContent(request);
        }
    }

    private ContentFragment getCurrentFragment(RenderRequest request) {
        return (ContentFragment) request
                .getAttribute(PortalReservedParameters.FRAGMENT_ATTRIBUTE);
    }

    private ContentPage getCurrentPage(PortletRequest request) {
        RequestContext requestContext = (RequestContext) request
                .getAttribute(PortalReservedParameters.REQUEST_CONTEXT_ATTRIBUTE);
        return requestContext.getPage();
    }

    private void setFragmentPreferenceValue(Fragment fragment, String name,
            String value) {
        FragmentPreference fp = getFragmentPreferenceByName(fragment, name);
        if (fp == null) {
            fp = pageManager.newFragmentPreference();
            fp.setName(name);
            fp.setReadOnly(false);
            List list = new ArrayList();
            list.add(StringEscapeUtils.escapeXml(value));
            fp.setValueList(list);
            fragment.getPreferences().add(fp);
        } else {
            fp.getValueList().set(0, StringEscapeUtils.escapeXml(value));
        }
    }

    private FragmentPreference getFragmentPreferenceByName(Fragment fragment,
            String name) {
        if (name == null) {
            return null;
        }
        List preferences = fragment.getPreferences();
        for (Iterator ite = preferences.iterator(); ite.hasNext();) {
            FragmentPreference fp = (FragmentPreference) ite.next();
            if (fp.getName() != null && fp.getName().equals(name)) {
                return fp;
            }
        }
        return null;
    }

    private String getFragmentPreferenceValue(Fragment fragment, String name,
            String defaultValue) {
        FragmentPreference fp = getFragmentPreferenceByName(fragment, name);
        if (fp != null) {
            if (fp.getValueList().size() > 0) {
                return StringEscapeUtils.unescapeXml((String) fp.getValueList()
                        .get(0));
            }
        }
        return defaultValue;
    }

}
