<?php

// {{{ P2Ime

/**
 * rep2 - URLQ[gEFCϊNX
 */
class P2Ime
{
    // {{{ properties

    /**
     * througth() ĂяoAۂURLϊ\bh
     *
     * @var string
     */
    protected $_method;

    /**
     * ]ȂOgq̃Xg
     *
     * @var array
     */
    protected $_exceptions;

    /**
     * ]ȂOgq̍ő̒
     *
     * @var int
     */
    protected $_maxExceptionLength;

    /**
     * httpvgR̃N̓Q[gʂȂ
     *
     * @var bool
     */
    protected $_ignoreHttp;

    /**
     * Q[gURL
     *
     * @var string
     */
    protected $_gateUrl;

    /**
     * ]̑҂ (b)
     * ̏ꍇ͎蓮]
     *
     * @var int
     */
    protected $_delay;

    // }}}
    // {{{ __construct()

    /**
     * RXgN^
     *
     * @param string $type
     * @param array $exceptions
     * @param bool $ignoreHttp
     */
    public function __construct($type = null, array $exceptions = null, $ignoreHttp = null)
    {
        global $_conf;

        // {{{ p[^̏

        // Q[gEFC^Cv
        if ($type === null) {
            $type = $_conf['through_ime'];
            // Cookie (URIɃZbVID܂) ̂Ƃ͋
            if (!$type && !$_conf['use_cookies']) {
                $type = 'ex';
            }
        }

        // p̂ݎ蓮]
        if ($type == 'p2pm') {
            $type = 'p2';
        } elseif ($type == 'expm') {
            $type = 'ex';
        }

        // ]Ȃgq
        if ($exceptions === null) {
            if ($_conf['ime_manual_ext']) {
                $this->_exceptions = explode(',', strtolower(trim($_conf['ime_manual_ext'])));
            } else {
                $this->_exceptions = array();
            }
        } else {
            $this->_exceptions = array_map('strtolower', $exceptions);
        }
        if ($this->_exceptions) {
            $this->_maxExceptionLength = max(array_map('strlen', $this->_exceptions));
        } else {
            $this->_maxExceptionLength = 0;
        }

        // http̃N͒ʂȂ
        if ($ignoreHttp === null) {
            // $_conf['through_ime_http_only']  1 ŁA
            // ZLAȐڑŁACookieL (URIɃZbVID܂܂Ȃ) ̂ƂA
            // httpvgR̃N̓Q[gʂȂB
            if ($_conf['through_ime_http_only'] && P2_HTTPS_CONNECTION && $_conf['use_cookies']) {
                $this->_ignoreHttp = true;
            } else {
                $this->_ignoreHttp = false;
            }
        } else {
            $this->_ignoreHttp = (bool)$ignoreHttp;
        }

        // ]̑҂Ԃ̊l
        $this->_delay = -1;

        // }}}
        // {{{ Q[gEFC

        switch ($type) {
        // {{{ p2ime
        case 'p2':   // ]
        case 'p2m':  // 蓮]
            $this->_method = '_throughP2Ime';
            if ($type == 'p2m') {
                $this->_delay = -1;
            } else {
                $this->_delay = 0;
            }
            $this->_gateUrl = $_conf['p2ime_url'];
            break;
        // }}}
        // {{{ gate.php
        case 'ex':   // ]1b
        case 'exq':  // ]0b
        case 'exm':  // 蓮]
            $this->_method = '_throughGatePhp';
            if ($type == 'exm') {
                $this->_delay = -1;
            } elseif ($type == 'exq') {
                $this->_delay = 0;
            } else {
                $this->_delay = 1;
            }
            $this->_gateUrl = $_conf['expack.gate_php'];
            break;
        // }}}
        // {{{ Google
        case 'google':
            $this->_method = '_throughGoogleGateway';
            if ($_conf['ktai'] && !$_conf['iphone']) {
                $this->_gateUrl = 'http://www.google.co.jp/gwt/x?u=';
            } else {
                $this->_gateUrl = 'http://www.google.co.jp/url?q=';
            }
            break;
        // }}}
        default:
            $this->_method = '_passThrough';
            $this->_gateUrl = null;
        }

        // }}}
    }

    // }}}
    // {{{ through()

    /**
     * URLϊ
     *
     * @param string $url
     * @param int $delay
     * @param bool $escape
     * @return string
     */
    public function through($url, $delay = null, $escape = true)
    {
        if ($delay === null) {
            if ($this->_isExceptionUrl($url)) {
                $delay = -1;
            } else {
                $delay = $this->_delay;
            }
        }

        if (!($this->_ignoreHttp && preg_match('!^http://!', $url))) {
            $url = $this->{$this->_method}($url, $delay);
        }
        if ($escape) {
            return htmlspecialchars($url, ENT_QUOTES, 'Shift_JIS', false);
        } else {
            return $url;
        }
    }

    // }}}
    // {{{ _throughP2Ime()

    /**
     * p2imeʂ悤URLϊ
     *
     * p2iméAenc, m, url ̈Œ肳Ă̂Œ
     *
     * @param string $url
     * @param int $delay
     * @return string
     */
    protected function _throughP2Ime($url, $delay)
    {
        if ($delay < 0) {
            return $this->_gateUrl . '?enc=1&m=1&url=' . rawurlencode($url);
        } else {
            return $this->_gateUrl . '?enc=1&url=' . rawurlencode($url);
        }
    }

    // }}}
    // {{{ _throughGatePhp()

    /**
     * gate.phpʂ悤URLϊ
     *
     * @param string $url
     * @param int $delay
     * @return string
     */
    protected function _throughGatePhp($url, $delay)
    {
        return sprintf('%s?u=%s&d=%d', $this->_gateUrl, rawurlencode($url), $delay);
    }

    // }}}
    // {{{ _throughGoogleGateway()

    /**
     * GoogleURLQ[gEFCʂ悤URLϊ
     *
     * @param string $url
     * @param int $delay (unused)
     * @return string
     */
    protected function _throughGoogleGateway($url, $delay)
    {
        return $this->_gateUrl . rawurlencode($url);
    }

    // }}}
    // {{{ _passThrough()

    /**
     * URL̂܂ܕԂ
     *
     * @param string $url
     * @param int $delay (unused)
     * @return string
     */
    protected function _passThrough($url, $delay)
    {
        return $url;
    }

    // }}}
    // {{{ _isExceptionUrl()

    /**
     * ]̗OURL
     *
     * @param string $url
     * @return bool
     */
    protected function _isExceptionUrl($url)
    {
        if ($this->_exceptions) {
            if (false !== ($pos = strrpos($url, '.'))) {
                $pos++;
                if (strlen($url) - $pos <= $this->_maxExceptionLength) {
                    $extension = strtolower(substr($url, $pos));
                    if (in_array($extension, $this->_exceptions)) {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
