<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=4 fdm=marker: */
/* mi: charset=Shift_JIS */

require_once 'PEAR.php';
require_once 'SOAP/Client.php';
require_once 'SOAP/WSDL.php';
require_once dirname(__FILE__) . '/search.class.php';

class GoogleSearch_PHP4 extends GoogleSearch_Common
{
    // {{{ properties

    // }}}
    // {{{ constructor

    /**
     * RXgN^
     *
     * @return void
     * @access public
     */
    function GoogleSearch_PHP4()
    {
    }

    // }}}
    // {{{ init()

    /**
     * SOAPNCAg̃CX^X𐶐
     *
     * @param string $wsdl  Google Search WSDLt@C̃pX
     * @param string $key   Google Web APIs ̃CZXL[
     * @return boolean
     * @access public
     */
    function init($wsdl, $key)
    {
        if (!file_exists($wsdl)) {
            //return PEAR::raiseError('GoogleSearch.wsdl not found.');

            /* SOAPT[oURIw肵SOAP_ClientNXg
               @link http://www.googleduel.com/apiexample.php */
            $soapClient = &new SOAP_Client('http://api.google.com/search/beta2');
        } else {
            /* SOAP_ClientNXWSDLw肷 */
            //$soapClient = &new SOAP_Client($wsdl, TRUE);

            /* SOAP_WSDLNXSOAP_ClientpNX𐶐 */
            $wsdl = &new SOAP_WSDL($wsdl);
            $soapClient = &$wsdl->getProxy();
        }

        $this->setConf($wsdl, $key);

        if (PEAR::isError($soapClient)) {
            return $soapClient;
        }

        $this->soapClient = $soapClient;

        return TRUE;
    }

    // }}}
    // {{{ doSearch()

    /**
     * s
     *
     * @param string  $q  L[[h
     * @param integer $start  ʂ擾ʒu
     * @param integer $maxResults  ʂ擾ő吔
     * @return object 
     * @access public
     */
    function &doSearch($q, $maxResults = 10, $start = 0)
    {
        $params = $this->prepareParams($q, $maxResults, $start);
        $result = &$this->soapClient->call('doGoogleSearch', $params, $this->options);
        return $result;
    }

    // }}}
}

?>
