<?php
require_once 'System.php';
require_once 'PHPUnit.php';
require_once 'File/Passwd/Cvs.php';

$GLOBALS['tmpfile'] = System::mktemp();
$GLOBALS['user']    = array(
    'mike' => array( 'passwd' => 'Tlu5Cq9nQ48Qc', 'system' => 'mike'),
    'pete' => array( 'passwd' => '6j8u02M0HVycY'),
    'mary' => array( 'passwd' => 'H7YIMXbnZ0Nyo', 'system' => 'marianne')
);

/**
 * TestCase for File_Passwd_CvsTest class
 * Generated by PHPEdit.XUnit Plugin
 * 
 */
class File_Passwd_CvsTest extends PHPUnit_TestCase{

    var $pwd;

    /**
     * Constructor
     * @param string $name The name of the test.
     * @access protected
     */
    function File_Passwd_CvsTest($name){
        $this->PHPUnit_TestCase($name);
    }
    
    /**
     * Called before the test functions will be executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function setUp(){
        $this->pwd = &new File_Passwd_Cvs();
    }
    
    /**
     * Called after the test functions are executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function tearDown(){
        $this->pwd = null;
    }
    
    /**
     * Regression test for File_Passwd_Cvs.File_Passwd_Cvs method
     * @access public
     */
    function testFile_Passwd_Cvs(){
        $this->assertTrue(is_a($this->pwd, 'File_Passwd_Cvs'));
    }
    
    /**
     * Regression test for File_Passwd_Cvs.save method
     * @access public
     */
    function testsave(){
        $this->pwd->_users = $GLOBALS['user'];
        $this->pwd->setFile($GLOBALS['tmpfile']);
        $this->assertTrue($this->pwd->save());
        $this->assertEquals(file('passwd.cvs.txt'), file($GLOBALS['tmpfile']));
    }
    
    /**
     * Regression test for File_Passwd_Cvs.parse method
     * @access public
     */
    function testparse(){
        $this->pwd->_users = array();
        $this->pwd->setFile('passwd.cvs.txt');
        $this->assertTrue($this->pwd->load());
        $this->assertEquals($GLOBALS['user'], $this->pwd->_users);
    }
    
    /**
     * Regression test for File_Passwd_Cvs.addUser method
     * @access public
     */
    function testaddUser(){
        $this->assertTrue($this->pwd->addUser('add', 123));
        $this->assertTrue($this->pwd->userExists('add'));
    }
    
    /**
     * Regression test for File_Passwd_Cvs.verifyPasswd method
     * @access public
     */
    function testverifyPasswd(){
        $this->pwd->addUser('verify', 12345);
        $this->assertTrue($this->pwd->verifyPasswd('verify', 12345));
        $this->assertFalse($this->pwd->verifyPasswd('verify', 0));
        $this->assertTrue(PEAR::isError($this->pwd->verifyPasswd('nobody', 0)));
    }
    
    /**
     * Regression test for File_Passwd_Cvs.changePasswd method
     * @access public
     */
    function testchangePasswd(){
        $this->pwd->addUser('change', 123);
        $this->assertTrue($this->pwd->changePasswd('change', 'abc'));
        $this->assertTrue($this->pwd->verifyPasswd('change', 'abc'));
    }
    
    /**
     * Regression test for File_Passwd_Cvs.changeSysUser method
     * @access public
     */
    function testchangeSysUser(){
        $this->pwd->addUser('chsys', 123, 'nobody');
        $this->assertTrue($this->pwd->changeSysUser('chsys', 'mike'));
        $this->assertEquals('mike', $this->pwd->_users['chsys']['system']);
    }
    
    /**
     * Regression test for File_Passwd_Cvs.generatePassword method
     * @access public
     */
    function testgeneratePassword(){
        $this->assertEquals('12IbR.gJ8wcpc', $this->pwd->generatePassword(123, '12IbR.gJ8wcpc'));
    }
    
    function teststaticAuth(){
        $this->assertTrue(true === File_Passwd::staticAuth('cvs', 'passwd.cvs.txt', 'mike', 123));
        $this->assertTrue(false === File_Passwd::staticAuth('cvs', 'passwd.cvs.txt', 'mike', 'abc'));
        $this->assertFalse((File_Passwd::staticAuth('cvs', 'passwd.cvs.txt', 'nonexist', 'asd')));
    }
}

?>