<?php

// {{{ P2KeyValueStore_Codec_JSONShiftJIS

/**
 * lJSONGR[hEfR[hCodec
 *
 * ͑ÓShift_JISV[PXłȂ΂Ȃ炸A
 * z̃L[͐lUS-ASCIIł邱Ƃ҂B
 */
class P2KeyValueStore_Codec_JSONShiftJIS extends P2KeyValueStore_Codec_JSON
{
    // {{{ encodeValue()

    /**
     * lUTF-8ɕϊAJSONGR[h
     *
     * @param mixed $value
     * @return string
     */
    public function encodeValue($value)
    {
        mb_convert_variables('UTF-8', 'Shift_JIS', $value);
        return parent::encodeValue($value);
    }

    // }}}
    // {{{ decodeValue()

    /**
     * lJSONfR[hAShift_JISɕϊ
     *
     * @param string $value
     * @return mixed
     */
    public function decodeValue($json)
    {
        $value = parent::decodeValue($json);
        mb_convert_variables('SJIS-win', 'UTF-8', $value);
        return $value;
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
