<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=0 fdm=marker: */
/* mi: charset=Shift_JIS */
/*
    p2 - StrCtl -- 񑀍NX
*/

//define('P2_MBREGEX_AVAILABLE_TEST', 0);

class StrCtl{

    /**
     * tH[瑗Ă[h}b`֐ɓK
     *
     * @return string $word_fm Kp^[BSJISŕԂB
     */
    function wordForMatch($word, $method = '')
    {
        $word_fm = $word;

        // û܂܁vłȂ΁ASp󔒂𔼊p󔒂ɋ
        if ($method != 'just') {
            $word_fm = mb_convert_kana($word_fm, 's');
        }

        // K\SJIS2oCĝ͉Ɩ肪̂ŁAUTF-8ɂď
        $word_fm = mb_convert_encoding($word_fm, 'UTF-8', 'SJIS-win');

        $word_fm = trim($word_fm);
        $word_fm = htmlspecialchars($word_fm, ENT_NOQUOTES);

        // uK\vłȂ΁AK\̓ꕶGXP[v
        if (in_array($method, array('and', 'or', 'just'))) {
            if (P2_MBREGEX_AVAILABLE == 1) {
                $word_fm = preg_quote($word_fm);
            } else {
                $word_fm = preg_quote($word_fm, '/');
            }

        // uK\vȂ
        } else {
            if (P2_MBREGEX_AVAILABLE == 0) {
                $word_fm = preg_replace('/\\//u', '\\/', $word_fm);
            }
        }

        $word_fm = mb_convert_encoding($word_fm, 'SJIS-win', 'UTF-8');

        return $word_fm;
    }

    /**
     * p^[}b`OpɍœKAX^eBbNϐɃLbV
     */
    function patternForMultiMatch($pattern)
    {
        static $patterns = array();

        $key = $pattern;
        if (isset($patterns[$key])) {
            return $patterns[$key];
        }

        if (P2_MBREGEX_AVAILABLE == 0) {
            $pattern = mb_convert_encoding($pattern, 'UTF-8', 'SJIS-win');
            $encoding = 'UTF-8';
        } else {
            $encoding = 'SJIS-win';
        }

        // 啶ׂďɂ
        // ő啶/̋ʂȂ}b`킯ł͂Ȃ...
        $pattern = mb_strtolower($pattern, $encoding);

        // Sp/pixjʂȂ}b`
        $_patterns = array();
        $_patterns[0] = $pattern;
        $_patterns[1] = mb_convert_kana($pattern, 'rnKV', $encoding); // ƃAt@xbg͔pAJ^Ji͑Sp
        $_patterns[2] = mb_convert_kana($pattern, 'rnk',  $encoding); // SĔp
        $_patterns[3] = mb_convert_kana($pattern, 'RNKV', $encoding); // SđSp
        //$_patterns[4] = mb_convert_kana($_patterns[2], 'rnKV', $encoding); // SpJ^Ji+_܂Ƃ߂(1)
        //$_patterns[5] = mb_convert_kana($_patterns[2], 'RNKV', $encoding); // SpJ^Ji+_܂Ƃ߂(2)
        $pattern = implode('|', array_unique($_patterns));

        // HTMLvfɃ}b`Ȃ߂̔ےǂ݃p^[t
        // ǂ݃p^[̓}b`ʂɊ܂܂Ȃ̂ŁA$0$1ɂ͓񂪃Lv`
        $pattern = '(' . $pattern . ')(?![^<]*>)';

        // OXbV(K\f~^)ň͂݁Ai(PCRE_CASELESS)Cqu(PCRE_UTF8)Cqt
        if (P2_MBREGEX_AVAILABLE == 0) {
            $pattern = '/' . $pattern . '/iu';
        }

        $patterns[$key] = $pattern;
        return $pattern;
    }

    /**
     * }`oCgΉŐK\}b`
     *
     * @param string $pattern }b`BP2_MBREGEX_AVAILABLE1ȂSJISA0ȂUTF-8œĂB
     * @param string $target ΏەBSJISœĂB
     *
     * @return boolean
     */
    function filterMatch($pattern, &$target)
    {
        $pattern = StrCtl::patternForMultiMatch($pattern);

        if (P2_MBREGEX_AVAILABLE ==1) {
            $result = @mb_eregi($pattern, $target);
        } else {
            $utf8txt = mb_convert_encoding($target, 'UTF-8', 'SJIS-win');
            $result = @preg_match($pattern, $utf8txt);
        }

        return (boolean)$result;
    }

    /**
     * }`oCgΉŃ}[LO
     *
     * @param string $pattern }b`BP2_MBREGEX_AVAILABLE1ȂSJISA0ȂUTF-8œĂB
     * @param string $target uΏەBSJISœĂB
     *
     * @retun string $result uςݕ
     */
    function filterMarking($pattern, &$target, $marker = '<b class="filtering">\\1</b>')
    {
        $pattern = StrCtl::patternForMultiMatch($pattern);

        if (P2_MBREGEX_AVAILABLE ==1) {
            $result = @mb_eregi_replace($pattern, $marker, $target);
        } else {
            $utf8txt = mb_convert_encoding($target, 'UTF-8', 'SJIS-win');
            $result = @preg_replace($pattern, $marker, $utf8txt);
            $result = mb_convert_encoding($result, 'SJIS-win', 'UTF-8');
        }

        if ($result === FALSE) {
            return $target;
        }
        return $result;
    }

}

?>
