<?php
/* vim: set fileencoding=cp932 autoindent noexpandtab ts=4 sw=4 sts=0 fdm=marker: */
/* mi: charset=Shift_JIS */

// p2@\gpbN - ANeBui[ENX

$GLOBALS['_ACTIVEMONA_INSTANCES'] = array();

class ActiveMona
{
	var $activemona;
	var $automona;

	var $aaita;
	var $noaaita;

	var $mona;

	var $thresholdA;
	var $thresholdB;
	var $thresholdC;

	var $regexA;
	var $regexB;
	var $regexC;

	var $noAAchars;
	var $noalnum;
	var $keisen;
	var $kigou;

	/**
	 * RXgN^
	 */
	function ActiveMona($config)
	{
		$this->activemona = $config['*'];
		$this->automona = $config['auto_monafont'];

		$this->aaita = preg_quote($config['aaita'], '/');
		$this->noaaita = preg_quote($config['auto_noaaita'], '/');

		// ɗpP\䗦臒l
		$this->thresholdA = $config['thresholdA']; // AA炵p^[Ƀ}b`Ƃ
		$this->thresholdB = $config['thresholdB']; // AAۂpfBOĂƂ
		$this->thresholdC = $config['thresholdC']; // Œ჉C

		// AA\iKj
		$this->noAAchars = ' 0-9A-Za-z/.,:;+\-\'=!?';
		$this->noAAchars .= '\xa1-\xdd'; // pJiE-
		$this->noAAchars .= '@O-X`-y--@-^EBAFG{[IH';

		// ASCII͈̔͂ŃAt@xbgEȊO
		$this->noalnum = '\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f';
		// r
		$this->keisen = '';
		// L
		$this->kigou = '@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_';
		$this->kigou .= '`abcdefghijklmnopqrstuvwxyz{|}~';
		$this->kigou .= '';
		$this->kigou .= 'ȁɁʁˁ́́΁ځہ܁݁ށ';
		$this->kigou .= '';

		// 1~3AA\̃p^[3A
		$this->regexA = '([^' . $this->noAAchars . ']{1,3})\\1\\1';
		// AÃpfBOɂ悭pp^[
		$this->regexB = '@@@|@ @| @ ';
		// {Ή̔P\iȂ肢j
		$this->regexC = '[' . $this->noalnum . $this->keisen . $this->kigou . ']';

		// i[tHg\XCb`
		// "%1\$s"sprintfŒu
		$this->mona = "<span class=\"aMonaSW\">i";
		$this->mona .= "<span onclick=\"activeMona('%1\$s','12px');\">L</span>";
		$this->mona .= "<span onclick=\"activeMona('%1\$s','14px');\"></span>";
		$this->mona .= "<span onclick=\"activeMona('%1\$s','16px');\">M</span>";
		$this->mona .= "j</span>";
	}

	/**
	 * VOgp^[g
	 *
	 * @return object
	 */
	function &singleton($config)
	{
		$key = md5(serialize($config));
		if (!isset($GLOBALS['_ACTIVEMONA_INSTANCES'][$key]) ||
			!is_object($GLOBALS['_ACTIVEMONA_INSTANCES'][$key]) ||
			!is_a($GLOBALS['_ACTIVEMONA_INSTANCES'][$key], 'ActiveMmona')
		) {
			$GLOBALS['_ACTIVEMONA_INSTANCES'][$key] = &new ActiveMona($config);
		}
		return $GLOBALS['_ACTIVEMONA_INSTANCES'][$key];
	}

	/**
	 * ݒɉAAƃi[tHg\XCb`s
	 *
	 * @return string
	 */
	function transAM(&$msg, $id, $bbs)
	{
		// 
		$bbsregexp = '/(^|,)' . preg_quote($bbs, '/') . '(,|$)/';
		$returnMona = FALSE;
		$autoMona = FALSE;
		//ꕔAA̕␳
		$msg = str_replace('AA', '@', $msg);
		// ss̋󔒕
		$msg = preg_replace('/(^|\s+)(<div id="\w+">|<br ?\/?>)\s+/i', '$2', $msg);

		// (ĹM)\
		if ($this->activemona == 1) {
			$returnMona = TRUE;
			// AAn̔H
			if ($this->automona && preg_match($bbsregexp, $this->aaita)) {
				$autoMona = TRUE;
			}
		// AAƔ肳ꂽƂ(ĹM)\
		} elseif ($this->activemona >= 2 && preg_match('/<br( \/)?>/i', $msg)) {
			$returnMona = $this->detectAA($msg);
			// i[tHg\H
			if ($returnMona && $this->automona == 2 && !preg_match($bbsregexp, $this->noaaita)) {
				$autoMona = TRUE;
			}
		}

		if ($autoMona) {
			$this->autoMona($msg);
		}

		if ($returnMona) {
			return $this->getMona($id);
		} else {
			return "";
		}
	}

	/**
	 * i[tHg\XCb`𐶐
	 *
	 * @return string
	 */
	function getMona($id)
	{
		return sprintf($this->mona, $id);
	}

	/**
	 * i[tHg\
	 *
	 * @return void
	 */
	function autoMona(&$msg)
	{
		$msg = preg_replace('/^\s*<div/', '<div class="AutoMona"', $msg);
	}

	/**
	 * AA
	 *
	 * @return boolean
	 */
	function detectAA(&$msg)
	{
		if ($this->activemona == 3) {
			return $this->detectAAbyThreshold($msg);
		} else {
			return $this->detectAAbyPattern($msg);
		}
	}

	/**
	 * p^[}b`ɂAA
	 *
	 * @return boolean
	 */
	function detectAAbyPattern(&$msg)
	{
		if (mb_ereg($this->regexA, $msg) || mb_ereg($this->regexB, $msg)) {
			return TRUE;
		}
		return FALSE;
	}

	/**
	 * p^[}b`ɉAP\䗦lAA
	 *
	 * @return boolean
	 */
	function detectAAbyThreshold(&$msg)
	{
		// $msg^OƎ̎QƁElQƂ
		$rawmsg = mb_ereg_replace('&#?[0-9A-Za-z]+;', '', strip_tags($msg));
		// $rawmsgP\
		$wcm = mb_ereg_replace($this->regexC, '', $rawmsg);
		// P\
		$wcc = mb_strlen($wcm);
		// 
		$len = mb_strlen($rawmsg);
		// P\䗦
		$ratio = ($len > 0) ? round($wcc / $len * 100) : 100;

		if ($ratio < $this->thresholdC ||
			($ratio < $this->thresholdA && mb_ereg($this->regexA, $msg)) ||
			($ratio < $this->thresholdB && mb_ereg($this->regexB, $msg))
		) {
			return TRUE;
		}
		return FALSE;
	}

}

?>
