#!/usr/bin/env python

import sys
import getpass
import datetime

# see http://code.google.com/intl/ja/apis/analytics/docs/gdata/gdataDeveloperGuide.html
import gdata.analytics.client
import gdata.sample_util

from data2db import GACacheDB

APP_NAME = "ganal_test"
#url = "http://sourceforge.jp/magazine/10/04/20/1033216"

def get_data_by_day(cli, year, month, day):
    baseurl = "/magazine/%02d/%02d/%02d/"
    url = baseurl % (year-2000, month, day)

    day_start = datetime.date(year, month, day)
    day_end = day_start + datetime.timedelta(31)
    return get_data_feed(cli, url, day_start.isoformat(), day_end.isoformat())

def get_data_feed(cli, url, start_date, end_date):

    print url + " : " + start_date + " to " + end_date

    table_id = "ga:1443341" # sourceforge.jp
    max_results = 1000
    # url = "http://sourceforge.jp/magazine/10/04/20/1033216"
    data_query = gdata.analytics.client.DataFeedQuery({
            'ids': table_id,
            'start-date': start_date,
            'end-date': end_date,
            'dimensions': 'ga:pagePath,ga:date',
            'metrics': 'ga:pageviews,ga:visits',
            'sort': 'ga:pagePath',
            'filters': "ga:pagePath=@" + url,
            'max-results': max_results})

    feed = cli.GetDataFeed(data_query)

    result = []
    for ent in feed.entry:
        path = ent.get_object("ga:pagePath").value
        date = ent.get_object("ga:date").value
        pv = ent.get_object("ga:pageviews").value
        visits = ent.get_object("ga:visits").value
        result.append((path, date, pv, visits))
    return result


def main():
    try:
        email = sys.argv[1]
    except IndexError:
        sys.exit("%s username" % sys.argv[0])

    passwd = getpass.getpass()
    cli = gdata.analytics.client.AnalyticsClient(source=APP_NAME)

    # login
    try:
        cli.client_login(email, passwd, APP_NAME)
    except gdata.client.BadAuthentication:
        exit('Invalid user credentials given.')
    except gdata.client.Error:
        exit('Login Error')

    start_date = datetime.date(2010, 3, 31)
#    start_date = datetime.date(2010, 3, 1)
    term = 60
#    term = 10
#    f = open("result.txt", "w")

    db = GACacheDB()
    with db:
        for d in range(term):
            td = datetime.timedelta(d)
            target = start_date + td
            l = get_data_by_day(cli, target.year, target.month, target.day)
            for item in l:
#                try:
                db.add(url=item[0],
                       date=item[1],
                       pageviews=item[2],
                       visits=item[3])
#                    f.write(st)
#                except UnicodeEncodeError:
#                    f.write(st.encode("utf-8"))

#    f.close()

if __name__ == "__main__":
    main()
