/******************************************************************************
    ե̾   : mod_auth_rbac.h
    ס       : ϣӣӣ϶̤η

                                  Copyright(c)ʬʳ2007
******************************************************************************/
#include "util_ldap.h"

typedef struct {
    char *host;                         /* LDAP                        */
    int port;                           /* LDAPХݡ                  */
    char *bindDn;                       /*  Base DN                      */
    char *usrBaseDn;                    /* 桼Base DN               */
    char *rscBaseDn;                    /* ꥽Base DN             */
    char *userAttr;                     /* 桼°̾                */
    char *urlAttr;                      /* URL°̾                   */
    char *aciAttr;                      /* ACIǼ°̾                   */
    char **roleAttrs;                   /* Ǽ°̾                */
    char *bindPw;                       /* LDAPѥ                    */
    apr_array_header_t *caseIgnPath;    /* CaseIgnoreоݤURI               */
    deref_options deref;                /*                                   */
    int secure;                         /* LDAPץȥȽ                */
    char *ticketName;                   /* å̾                */
    char *passPhrase;                   /* Ź沽ѥѥե졼              */
    char *ticketAttr;                   /* ѤåǼ°̾          */
    char *authServer;                   /* ǧڥУգң                  */
    char *myUrl;                        /* Уգң                    */
    char *timeoutDoc;                   /* ॢѥե            */
    char *proxy;                        /* ǧھѤ                */
    char *proxyenv;                     /* ĶѿѤ                */

    int (*get_resource_info)();
    int (*get_user_role)();
    int (*get_user_ticket)();
} rbac_config_rec;
                 
typedef struct {                        
    int rbac_flag;                      /* RequireȽե饰               */
    int public_flag;                    /* 桼Ƚե饰            */
    char *url;                          /* ݸоURL                       */
    char **allowed;                     /* 롼                    */
} rbac_request_t;

extern module AP_MODULE_DECLARE_DATA auth_rbac_module;

AP_DECLARE(int) check_resource_info(request_rec *r);
AP_DECLARE(int) auth_ticket_checker(request_rec *r);
AP_DECLARE(int) rbac_check_auth(request_rec *r);
AP_DECLARE(int) user_info_proxy(request_rec *r);
                                        /* Ͽhooks                     */

AP_DECLARE(int) get_ldap_resource_info(request_rec *r, 
				       rbac_config_rec *conf, 
				       rbac_request_t *req, 
				       int caseign);
AP_DECLARE(int) get_ldap_user_role(request_rec *r, 
				   rbac_config_rec *conf, 
				   apr_array_header_t *role);
AP_DECLARE(int) get_ldap_user_ticket_rbac(request_rec *r, 
					  rbac_config_rec *conf, 
					  apr_array_header_t *ticket);
                                     
#define SSO_LOG_ERR     APLOG_ERR       /* 顼٥                  */
#define SSO_LOG_WARNING APLOG_WARNING
#define SSO_LOG_NOTICE  APLOG_NOTICE
#define SSO_LOG_INFO    APLOG_INFO
#define SSO_LOG_DEBUG   APLOG_DEBUG


#define PUBLIC_ROLE "cn=Public"         /* 桼                */
#define VALIDUSER_ROLE "cn=ValidUser"   /* ǧںѤߥ桼          */
