/******************************************************************************
  <⥸塼̾  > ϣӣӣ
  <⥸塼복> 󥰥륵󥪥¸뤿
                   桼ǧڵڤӥȥԤʤ

                                  Copyright(c)ʬʳ2007
******************************************************************************/
#include "httpd.h"                      /* ɸ                          */
#include "http_config.h"                /*                                 */
#include "http_protocol.h"              /*                                 */
#include "ap_config.h"                  /*                                 */
#include "mod_auth_rbac.h"              /* ɲ                          */
#include "http_log.h"                   /*                                 */
#include "apr_strings.h"                /*                                 */

#define CASEIGNPATH_MAX_ELTS 128        /* RBACCaseIgnPathκĹ           */

/*****************************************************************************/
/*<ؿ̾    >  create_auth_rbac_dir                                         */
/*<ǽ      >  ̵ǽʥǥ쥯ƥɤ߹߽                       */
/*              ǥ쥯ƥɤ߹ߥꥢγݵڤӽԤʤ         */
/*                                                                           */
/*****************************************************************************/
static void *create_auth_rbac_dir(apr_pool_t *p, char *d)
{
    rbac_config_rec *conf;
    conf = (rbac_config_rec *)apr_pcalloc(p, sizeof(rbac_config_rec));
                                                /* ꥢγ              */

    conf->host = NULL;                          /* LDAP                */
    conf->port = 389;                           /* LDAPХݡ          */
    conf->bindDn = NULL;                        /*  Base DN              */
    conf->usrBaseDn = NULL;                     /* 桼Base DN       */
    conf->rscBaseDn = NULL;                     /* ꥽Base DN     */
    conf->userAttr = "uid";                     /* 桼°̾        */
    conf->urlAttr = "rbacScope";                /* URL°̾           */
    conf->aciAttr = "cecssoAccessRule";         /* ACIǼ°̾           */
    conf->roleAttrs = (char **)apr_pcalloc(p, sizeof(char *)*3);
    conf->roleAttrs[0] = "rbacHasRole";         /* ܥǼ°̾    */
    conf->roleAttrs[1] = "OpenSSOhasRole";      /* ̥Ǽ°̾    */
    conf->roleAttrs[2] = NULL;
    conf->bindPw = NULL;                        /* LDAPѥ            */
    conf->caseIgnPath = apr_array_make(p, 1, sizeof(char *));	
                                                /* CaseIgnoreоݤURI       */
    conf->deref = always;                       /*                           */
    conf->secure = 0;                           /* LDAPץȥȽ        */
    conf->ticketName = "Open_SSO_Ticket";       /* å̾        */
    conf->passPhrase = "Open_SSO_Key";          /* Ź沽ѥѥե졼      */
    conf->authServer = NULL;                    /* ǧڥУգң          */
    conf->myUrl = NULL;                         /* Уգң            */
    conf->timeoutDoc = NULL;                    /* ॢѥե    */
    conf->proxy = 0;                            /* ǧղþѤ    */
    conf->ticketAttr = "OpenSSOsuccessionInfo"; /* ǧղþ°̾        */    
    conf->proxyenv = 0;                         /* ĶѿѤ        */

    conf->get_resource_info = get_ldap_resource_info;
    conf->get_user_role = get_ldap_user_role;
    conf->get_user_ticket = get_ldap_user_ticket_rbac;

    return (void *)conf;
}

/*****************************************************************************/
/*<ؿ̾    >  parse_ldap_server                                            */
/*<ǽ      >  𥵡о                                       */
/*               ʥǥ쥯ƥɹߡ                                    */
/*                                                                           */
/*<꥿> null       ->                                             */
/*             顼 -> ۾                                            */
/*                                                                           */
/*****************************************************************************/
static const char *parse_ldap_server(cmd_parms *cmd, 
                                     void *config,
                                     const char *server)
{
    const char *strp = server;                  /* ǥ쥯ƥͤ    */
    rbac_config_rec *conf = (rbac_config_rec *)config;

    if (apr_ldap_is_ldaps_url(server)) {        /* ץȥ뤬ldapsξ   */
        conf->secure = 1;
        strp += strlen("ldaps://");
        conf->port = 636;
    } else if (apr_ldap_is_ldap_url(server)) {  /* ץȥ뤬ldapξ    */
        strp += strlen("ldap://");
    } else {                                /* ץȥ뤬ldap(s)ʳξ */
        return apr_psprintf( cmd->pool,
              "Bad LDAP server name RBACLdapServer [%s]", server);
    }

    if (strchr(strp, ':') == NULL) {         /* ݡȤꤵƤʤ */ 
        conf->host = apr_pstrdup(cmd->pool, strp);
    } else {                                 /* ݡȤꤵƤ   */ 
        conf->host = ap_getword(cmd->pool, &strp, ':');
        conf->port = atoi(strp);
    }

    return NULL;
}

/*****************************************************************************/
/*<ؿ̾    >  set_role_attributes                                          */
/*<ǽ      >  桼°(ܡ)                           */
/*               ʥǥ쥯ƥɹߡ                                    */
/*                                                                           */
/*<꥿>  null ->                                                  */
/*                                                                           */
/*****************************************************************************/
static const char *set_role_attributes(cmd_parms *cmd,
                                       void *config,
                                       const char *arg)
{
    const char *strp = arg;
    char *attrs[256];
    int i = 0;

    rbac_config_rec *conf = (rbac_config_rec *)config;

    while (*strp && (attrs[i] = ap_getword_white(cmd->pool, &strp))) {
        i++;
    }
    attrs[i] = NULL;

    conf->roleAttrs = apr_pmemdup(cmd->pool, attrs, sizeof(char *)*(i + 1));

    return NULL;
}

/*****************************************************************************/
/*<ؿ̾    >  set_caseignore_path                                          */
/*<ǽ      >  RBACCaseIgnoreǥ쥯ƥ֤                           */
/*               ʥǥ쥯ƥɹߡ                                    */
/*                                                                           */
/*<꥿>  null ->                                                  */
/*                                                                           */
/*****************************************************************************/
static const char *set_caseignore_path(cmd_parms *cmd,
                                       void *config,
                                       const char *arg)
{
    char **new;
    rbac_config_rec *conf = (rbac_config_rec *)config;

    if (conf->caseIgnPath->nelts > CASEIGNPATH_MAX_ELTS) {
        return "Too many RBACCaseIgnPath directives";
    }
    new = apr_array_push(conf->caseIgnPath);
    *new = apr_pstrdup(cmd->pool, arg);

    return NULL;
}

/*****************************************************************************/
/*<ؿ̾    >  rbac_start                                                   */
/*<ǽ      >  Apache顼˥⥸塼γϤϤ                 */
/*                                                                           */
/*<꥿>  0 ->                                                     */
/*                                                                           */
/*****************************************************************************/
static int rbac_start(apr_pool_t *p,
		      apr_pool_t *plog,
		      apr_pool_t *ptemp,
		      server_rec *s)
{
  ap_log_error(APLOG_MARK, APLOG_NOTICE, 0, s,
	       "[%s:%d][RBAC_NML_001]mod_auth_rbac start",
	       __FILE__, __LINE__);
  return 0;
}

static const command_rec auth_rbac_cmds[] =
{
    AP_INIT_TAKE1("RBACLdapServer", parse_ldap_server,
                 NULL, OR_ALL, "URL of LDAP server"),
    AP_INIT_TAKE1("RBACBindDn", ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, bindDn),
                 OR_ALL, "Binddn to bind to the LDAP server"),
    AP_INIT_TAKE1("RBACUserBaseDn", ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, usrBaseDn),
                 OR_ALL, "Basedn to search user"),
    AP_INIT_TAKE1("RBACResourceBaseDn", ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, rscBaseDn),
                 OR_ALL, "Basedn to search resource"),
    AP_INIT_TAKE1("RBACUserAttr", ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, userAttr),
                 OR_ALL,"Attribute for user"),
    AP_INIT_TAKE1("RBACUrlAttr", ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, urlAttr),
                 OR_ALL,"Attribute for url of resource"),
    AP_INIT_TAKE1("RBACAciAttr", ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, aciAttr),
                 OR_ALL,"Attribute for access control information"),
    AP_INIT_RAW_ARGS("RBACRoleAttrs", set_role_attributes,
                 NULL, OR_ALL, "attributes for role of user"),
    AP_INIT_TAKE1("RBACLdapPassword", ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, bindPw),OR_ALL,
                 "Password to bind to the LDAP server"),
    AP_INIT_ITERATE("RBACCaseIgnPath", set_caseignore_path,
		 NULL, OR_ALL, 
		 "A list of path  ignoring the case of the characters"),
    AP_INIT_TAKE1("RBACTicketName",ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, ticketName),
                 OR_ALL,"Name of access ticket"),
    AP_INIT_TAKE1("RBACPassPhrase",ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec,passPhrase),
                 OR_ALL,"Pass phrase to decrypt access ticket"),
    AP_INIT_TAKE1("RBACProxyCookieAttr",ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, ticketAttr),
                 OR_ALL,"Attribute for proxy ticket passed to the web server"),
    AP_INIT_TAKE1("RBACAuthServer",ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec,authServer),
                 OR_ALL,"URL of authentication server"),
    AP_INIT_TAKE1("RBACMyUrl",ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec,myUrl),
                 OR_ALL,"URL of the own server(option)"),
    AP_INIT_TAKE1("RBACTicketTimeoutDocument",ap_set_string_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec,timeoutDoc),
                 OR_ALL,"File displayed if access ticket expire"),
    AP_INIT_FLAG("RBACProxyCookie",ap_set_flag_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, proxy),
                 OR_ALL,"Set to 'on' to pass proxy ticket to the web server."
		 "By default, this is set to 'off'"),
    AP_INIT_FLAG("RBACProxyEnv",ap_set_flag_slot,
                 (void *)APR_OFFSETOF(rbac_config_rec, proxyenv),
                 OR_ALL,
		 "Set to 'on' to pass proxy environment_var  to the web server."
		 "By default, this is set to 'off'"),
    {NULL}                              
};

static void auth_rbac_register_hooks(apr_pool_t *p)
{                                       /* ϥɥϿ                    */
    ap_hook_post_config(rbac_start,            NULL, NULL, APR_HOOK_FIRST);
    ap_hook_check_user_id(check_resource_info, NULL, NULL, APR_HOOK_FIRST);
    ap_hook_check_user_id(auth_ticket_checker, NULL, NULL, APR_HOOK_MIDDLE);
    ap_hook_auth_checker(rbac_check_auth,      NULL, NULL, APR_HOOK_FIRST);
    ap_hook_fixups(user_info_proxy,            NULL, NULL, APR_HOOK_FIRST);
}

                                        /* Dispatch list for API hooks       */
module AP_MODULE_DECLARE_DATA auth_rbac_module = {
    STANDARD20_MODULE_STUFF, 
    create_auth_rbac_dir,                /* create per-dir                   */
    NULL,                                /* merge  per-dir                   */
    NULL,                                /* create per-server                */
    NULL,                                /* merge  per-server                */
    auth_rbac_cmds,                      /* table of config file commands    */
    auth_rbac_register_hooks             /* register hooks                   */
};
