/******************************************************************************
   <⥸塼̾  > LDAP access

                                  Copyright(c)ʬʳ2007
******************************************************************************/

#include "httpd.h"                      /*  ɸ                          */
#include "http_config.h"                /*                                  */
#include "http_protocol.h"              /*                                  */
#include "ap_config.h"                  /*                                  */

#include <apr_ldap.h>                   /*  ɲ                          */
#include "apr_strings.h"                /*                                  */
#include "apr_tables.h"                 /*                                  */

#include "http_core.h"                  /*                                  */
#include "http_log.h"                   /*                                  */
#include "util_ldap.h"                  /*                                  */
#include "mod_auth_rbac.h"              /*                                  */

/******************************************************************************/
/* <ؿ̾    > strlencmp                                                     */
/* <ǽ      > ʸĹӤ                                        */
/*                                                                            */
/* <꥿>  1 -> s1 < s2                                                 */
/*               0 -> s1 == s2                                                */
/*              -1 -> s1 > s2                                                 */
/*                                                                            */
/******************************************************************************/
int strlencmp(const void *s1, 
	      const void *s2)
{
    int len1, len2;

    len1 = strlen(*(char *const *)s1);
    len2 = strlen(*(char *const *)s2);

    if (len1 == len2)
        return 0;
    else if (len1 > len2 )
        return -1;
    else
        return 1;
}

/******************************************************************************/
/* <ؿ̾    > build_resource_filter                                         */
/* <ǽ      > LDAPθѥե륿                              */
/*                                                                            */
/* <꥿> ѥե륿                                                */
/*                                                                            */
/******************************************************************************/
char *build_resource_filter(const char *url, 
			    request_rec *r, 
			    rbac_config_rec *conf)
{
    char *topurl;
    char *filter;
    char *searchurl;
    char *strp;

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "=>build_resource_filter");

    topurl = ap_construct_url(r->pool, "/", r);
                                     /* URL"/"κ¦(topurl) */
                                     /* 80,443ʤɤΥǥեȥݡȤϼư */
    if (!strcmp(url, topurl)) {
                                     /* topurlURLȰפ    */
	filter = apr_psprintf(r->pool, "(%s=%s)", conf->urlAttr, url);
    } else {
        strp = (char *)url;
	strp += strlen(topurl);
	strp++;

        if ((strp = strchr(strp, '/')) == NULL) {
                                       /* URLγؤĤξ      */
            searchurl = apr_pstrdup(r->pool, url);
	}
        else {                         /* URLγؤ2İʾξ   */
	    searchurl = apr_pstrndup(r->pool, url, (strp - url));
	}                              /* ܤγؤޤǤʣ               */

	filter = apr_psprintf(r->pool, "(|(%s=%s)(%s=%s*))", 
			      conf->urlAttr, topurl, conf->urlAttr, searchurl);
    }                                  /* ե륿κ                       */
    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
		  "build_resource_filter: filter=%s", filter);

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "<=build_resource_filter");

    return filter;
}

/******************************************************************************/
/* <ؿ̾    > url_match                                                     */
/* <ǽ      > ꥽ȥݸоURL˥ꥯURL              */
/*              ޤޤƤ뤫Ƚꤹ                                        */
/*                                                                            */
/* <꥿>  1 -> ޤޤƤ                                            */
/*               0 -> ޤޤƤʤ                                          */
/*              -1 -> ۾                                                    */
/*                                                                            */
/******************************************************************************/
int url_match(const char *url, 
	      const char *rscurl, 
	      int caseign)
{
    if ( url == NULL || rscurl == NULL )
        return -1;

    if (caseign) {                     /* ʸʸ̤ʤ        */
        return strncasecmp(url, rscurl, strlen(rscurl))? 0 : 1;
    }
    else {                             /* ʸʸ̤          */
        return strncmp(url, rscurl, strlen(rscurl))? 0 : 1;
    }
}

/******************************************************************************/
/* <ؿ̾    > str2array                                                     */
/* <ǽ      > ʸǥߥʬ䤷˳Ǽ                        */
/*                                                                            */
/******************************************************************************/
void str2array(apr_pool_t *p, 
	       const char *str, 
	       apr_array_header_t *arr, 
	       char delim)
{
    char **elt;
    char *strp;
    char *token;

    if (!str) {
	return;
    }

    while (*str && (token = ap_getword(p, &str, delim))) {
        strp = token;                  /* ʸΥǥߥޤǤڤФ       */
	if (isspace(*strp))            /* ʸξϥݥ󥿤򥷥ե     */
	  strp++;
        elt = apr_array_push(arr);
	*elt = strp;
    }

    return;
}

/******************************************************************************/
/* <ؿ̾    > get_ldap_resource_info                                        */
/* <ǽ      > LDAPФ꥽ȥݸоURL                 */
/*              롼                                      */
/*              (ݸоURLȥURLʬפĹURLȤ)     */
/*                                                                            */
/*              Ϣǥ쥯ƥ֡RBACUserBaseDN                            */
/*                                  RBACBindDN                                */
/*                                  RBACLdapPassword                          */
/*                                  RBACResourceBaseDN                        */
/*                                                                            */
/* <꥿> LDAP error code ->                                        */
/*              -1              -> ۾                                       */
/*                                                                            */
/******************************************************************************/
int get_ldap_resource_info(request_rec *r,
			   rbac_config_rec *conf,
			   rbac_request_t *req,
			   int caseign)
{
    char *url;
    char *filter;
    char *errstr;
    char **vals = NULL;
    char *attrs[3] = {conf->urlAttr, conf->aciAttr, NULL};
    char **values;
    int i;
    int result = LDAP_SUCCESS;
    int url_matched = 0;
    int url_len = 0;
    int failures = 0;
    LDAPMessage *entry;
    LDAPMessage *msg = NULL;
    util_ldap_connection_t *ldc = NULL;

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "=>get_ldap_resource_info");

    if (!conf->rscBaseDn) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r, 
		      "[RBAC_ERR_012] [%s %d] there aren't necessary directives",
		      __FILE__, __LINE__);
        return -1;                      /* ꥽ȥBaseDN         */
    }                                   /* ǥ쥯ƥ֤ꤵƤʤ */

    url = ap_construct_url(r->pool, r->unparsed_uri, r);
                                        /* URLμ                */
    filter = build_resource_filter(url, r, conf);
                                        /* ѥե륿κ               */

    ldc = util_ldap_connection_find(r, conf->host, conf->port, conf->bindDn, 
				    conf->bindPw, conf->deref, conf->secure);
                                        /* LDAPͥμ             */

 start_over:                          /* start_over٥                     */
    if (failures++ > 10)              /* LDAP_SERVER_DOWN10󷫤֤ */
        goto done;

    result = util_ldap_connection_open(r, ldc);
                                        /* LDAPȤ³                       */
    if (result != LDAP_SUCCESS) {       
        errstr = ldap_err2string(result);
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
		      "[RBAC_FAL_002] [%s %d] connection failed: %s",
		      __FILE__, __LINE__, errstr);
	goto done;                       /* ³˼Ԥ                */
    }                                    /* done٥˽ư            */

    result = ldap_search_s(ldc->ldap, conf->rscBaseDn, LDAP_SCOPE_SUBTREE, 
			   filter, attrs, 0, &msg);
                                  /* ꥽ȥ꤫ݸоURL        */
                                  /* 롼򸡺ȥ */
    if (result == LDAP_SERVER_DOWN) {   
        util_ldap_connection_unbind(ldc);
                                       /* LDAPФ󤷤Ƥ      */
	goto start_over;               /* start_over٥˽ư        */
    } else if (result != LDAP_SUCCESS) {
        errstr = ldap_err2string(result);
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
		      "[RBAC_ERR_011] [%s %d] search failed: %s",
		      __FILE__, __LINE__, errstr);
	goto done;                    /* ˼Ԥ                   */
    }                                 /* done٥˽ư               */

    for (entry = ldap_first_entry(ldc->ldap, msg); entry != NULL; 
	 entry = ldap_next_entry(ldc->ldap, entry)) 
      {                                 /* ȥ򣱤Ĥļ         */
	values = ldap_get_values(ldc->ldap, entry, conf->urlAttr);
                                        /* ȥ꤫ݸоURL  */
        if (values == NULL)
            continue;                   /* ݸоURLǤʤä  */

	if (ldap_sort_values(ldc->ldap, values, strlencmp)) {
                             /* ݸоURLĹ(߽)¤Ѥ */
	    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r,
			  "ldap_sort_values error");
	}

	for (i = 0; values[i] != NULL; i++) {
	    if (url_match(url, values[i], caseign)) /* URL    */
	        break;
	}

	if (!values[i] || (strlen(values[i]) < url_len)) {
	    ldap_value_free(values);
	    continue;
	}

	url_matched = 1;             /* ݸоݥޥå󥰥ե饰"1"˥å */
	url_len = strlen(values[i]); 
	ldap_value_free(values);

	values = ldap_get_values(ldc->ldap, entry, conf->aciAttr);
                                     /* ȥ꤫饢롼  */
        if (values == NULL) {
	    vals = NULL;
            continue;
	}

	for (i = 0; values[i] != NULL; i++);
	vals = apr_palloc(r->pool, sizeof(char *)*(i+1));
	for (i = 0; values[i] != NULL; i++)
	    vals[i] = apr_pstrdup(r->pool, values[i]);
	vals[i] = NULL;                /* 롼  */
	ldap_value_free(values);
    }

 done:                                 /* done٥                          */
    if (msg)
        ldap_msgfree(msg);

    util_ldap_connection_close(ldc);

    if (url_matched) {                /* ݸоURLե饰"1"ξ         */
        req->url = url;
	req->allowed = vals;
    } else {                          /* ݸоURLե饰"0"ξ         */
        req->url = NULL;
	req->allowed = NULL;
    }

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "<=get_ldap_resources_info");

    return result;                    /* LDAP_SUCCESS                         */
}

/******************************************************************************/
/* <ؿ̾    > get_ldap_user_role                                            */
/* <ǽ      > LDAPФ饢åȤΥ桼̾ǥ桼ȥ    */
/*              桼                            */
/*                                                                            */
/*              Ϣǥ쥯ƥ֡RBACUserBaseDN                            */
/*                                  RBACBindDN                                */
/*                                  RBACLdapPassword                          */
/*                                  RBACRoleAttris                            */
/*                                                                            */
/* <꥿> LDAP error code ->                                        */
/*              -1              -> ۾                                       */
/*                                                                            */
/******************************************************************************/
int get_ldap_user_role(request_rec *r, 
		       rbac_config_rec *conf, 
		       apr_array_header_t *role)
{
    char *filter;
    char *errstr;
    char **values;
    char **elt;
    int result = LDAP_SUCCESS;
    int count;
    int failures = 0;
    int i;
    int j;
    LDAPMessage *entry;
    LDAPMessage *msg = NULL;
    util_ldap_connection_t *ldc = NULL;

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "=>get_ldap_user_role");

    if (!conf->usrBaseDn) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
		      "[RBAC_ERR_012] [%s %d] there aren't necessary directives",
		      __FILE__, __LINE__);
        return -1;                     /* 桼ȥBaseDN           */
    }                                  /* ǥ쥯ƥ֤ꤵƤʤ */

    filter = apr_psprintf(r->pool, "(%s=%s)", conf->userAttr, r->user);
                                       /* ѥե륿κ               */

    ldc = util_ldap_connection_find(r, conf->host, conf->port, conf->bindDn, 
				    conf->bindPw, conf->deref, conf->secure);
                                     /* LDAPͥμ               */

 start_over:                         /* start_over٥                     */
    if (failures++ > 10) 
        goto done;                   /* LDAP_SERVER_DOWN10󷫤֤ */

    result = util_ldap_connection_open(r, ldc);
                                    /* LDAPȤ³                          */
    if (result != LDAP_SUCCESS) {
        errstr = ldap_err2string(result);
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
		      "[RBAC_FAL_002] [%s %d] connection failed: %s",
		      __FILE__, __LINE__, errstr);
	goto done;                     /* ³˼Ԥ                 */
    }                                  /* done٥˽ư             */

    result = ldap_search_s(ldc->ldap, conf->usrBaseDn, LDAP_SCOPE_SUBTREE, 
			   filter, conf->roleAttrs, 0, &msg);
                                        /* 桼ȥ꤫桼  */
                                        /* ȥ          */
    if (result == LDAP_SERVER_DOWN) {
        util_ldap_connection_unbind(ldc);
                                        /* LDAPФ󤷤Ƥ    */
	goto start_over;                /* start_over٥˽ư      */
    } else if (result != LDAP_SUCCESS) {
        errstr = ldap_err2string(result);
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
		      "[RBAC_ERR_011] [%s %d] search failed: %s",
		      __FILE__, __LINE__, errstr);
	goto done;                     /* ˼Ԥ                 */
    }                                  /* done٥˽ư             */

    count = ldap_count_entries(ldc->ldap, msg);
    
    if (count != 1) {
        if (count == 0)                /* ȥ꤬Ĥ̵       */
	    ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
			  "[RBAC_ERR_009] [%s %d] User not found",
			  __FILE__, __LINE__);
	else                           /* ȥ꤬ʣξ           */
	    ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
			  "[RBAC_ERR_010] [%s %d] User is not unique", 
			  __FILE__, __LINE__);
	result = -1;

	goto done;
    }

    entry = ldap_first_entry(ldc->ldap, msg);
    for (i = 0; conf->roleAttrs[i] != NULL; i++) {
        values = ldap_get_values(ldc->ldap, entry, conf->roleAttrs[i]);
                                       /* ȥ꤫桼 */
        if (values == NULL)
            continue;

	for (j = 0; values[j] != NULL; j++) {
	    elt = apr_array_push(role);
	    *elt = apr_pstrdup(r->pool, values[j]);
	}
	ldap_value_free(values);
    }

 done:                                  /* done٥                        */
    if (msg)
        ldap_msgfree(msg);

    util_ldap_connection_close(ldc);

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "<=get_ldap_user_role");

    return result;                      /* LDAP_SUCCESS                         */
}

/******************************************************************************/
/* <ؿ̾    > get_ldap_user_ticket_rbac                                     */
/* <ǽ      > LDAPФǧղþ                          */
/*                                                                            */
/*              Ϣǥ쥯ƥ֡RBACUserBaseDN                            */
/*                                  RBACBindDN                                */
/*                                  RBACLdapPassword                          */
/*                                                                            */
/* <꥿> LDAP error code ->                                        */
/*              -1              -> ۾                                       */
/*                                                                            */
/******************************************************************************/
int get_ldap_user_ticket_rbac(request_rec *r, 
			      rbac_config_rec *conf, 
			      apr_array_header_t *ticket)
{
    char *url;
    char *filter;
    char *attrs[2] = {conf->ticketAttr, NULL};   /* ǧղþ°     */
    const char **vals = NULL;
    const char *dn = NULL;
    int result = LDAP_SUCCESS;
    int failures = 0;
    int i;
    util_ldap_connection_t *ldc = NULL;

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "=>get_ldap_user_ticket");

    if (!conf->usrBaseDn) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
		      "[RBAC_ERR_012] [%s %d] there aren't necessary directives",
		      __FILE__, __LINE__);
        return -1;                     /* 桼ȥBaseDN           */
    }                                  /* ǥ쥯ƥ֤ꤵƤʤ */

    url = apr_psprintf(r->pool,"%s://%s/%s?%s", 
		       conf->secure ? "ldaps" : "ldap", 
		       conf->host, 
		       conf->usrBaseDn, 
		       conf->ticketAttr);
    filter = apr_psprintf(r->pool, "(%s=%s)", conf->userAttr, r->user);
                                       /* ѥե륿κ               */

 start_over:                           /* start_over٥                   */

    ldc = util_ldap_connection_find(r, conf->host, conf->port, conf->bindDn, 
				    conf->bindPw, conf->deref, conf->secure);
                                       /* LDAPͥμ             */
    result = util_ldap_cache_getuserdn(r, ldc, url, 
				       conf->usrBaseDn, LDAP_SCOPE_SUBTREE,
				       attrs, filter, &dn, &vals);
                                        /* 桼ȥ꤫ǧղþ  */
                                        /*               */

    if (result == LDAP_SERVER_DOWN) {
        if (failures++ <= 10) {      /* LDAP_SERVER_DOWNξ10ޤǷ֤ */
	  util_ldap_connection_unbind(ldc);
                                     /* httpd-2.0.54ʾ˥С󥢥å   */
                                     /* ݡutil_ldap.cΥХ    */
	  util_ldap_connection_close(ldc);
	    goto start_over;
	}
    }

    if (result != LDAP_SUCCESS) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
		      "[RBAC_ERR_007] [%s %d] searching user failed: %s",
		      __FILE__, __LINE__, ldc->reason);
	util_ldap_connection_close(ldc);
	return result;                  /* ˼Ԥ                */
    }                                   /* LDAP顼                  */

    str2array(r->pool, vals[0], ticket, ';');
                                        /* ǧղþ';'ʬ䤷 */
                                        /* ˳Ǽ                    */
    util_ldap_connection_close(ldc);

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "<=get_ldap_user_ticket");

    return result;                      /* LDAP_SUCCESS                      */
}
