/******************************************************************************
  <⥸塼̾  > ȥ뵡ǽ

                                  Copyright(c)ʬʳ2007
******************************************************************************/
#include "httpd.h"                      /* ɸ                          */
#include "http_config.h"                /*                                 */
#include "http_protocol.h"              /*                                 */
#include "ap_config.h"                  /*                                 */
#include "mod_auth_rbac.h"              /* ɲ                          */

#include <apr_ldap.h>
#include "apr_strings.h"
#include "apr_tables.h"

#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"
#include "http_core.h"
#include "http_log.h"
#include "util_ldap.h"
#include "openssl/evp.h"                /*                                 */
#include "openssl/rand.h"               /*                                 */
#include "openssl/rand.h"               /*                                 */

#define AUTH_OK_URL    0                /* ǧڣϣ                          */
#define NOT_AUTH_URL   1                /* å̵              */
#define TIMEOUT_URL    3                /* ͭڤ                      */
#define RESTRICTED_URL 4                /* ̵                    */
#define AUTH_ERR_URL   5                /* ǧڣΣ                          */
                                        /* 顼                  */
#define CASEIGNPATH_MAX_ELTS 128        /* CaseIgnPathǤMAX            */

/*****************************************************************************/
/*<ؿ̾    >  decrypt_message                                              */
/*<ǽ      >  åȤ(Triple DES)                       */
/*              (OpenSSLΰŹ饤֥)                              */
/*                                                                           */
/*<꥿>  ǡ                                                   */
/*                                                                           */
/*****************************************************************************/
unsigned char *decrypt_message(request_rec *r,
			       const unsigned char *src, 
			       int src_len,
			       const unsigned char *passwd)
{
    EVP_CIPHER_CTX ctx;
    const EVP_CIPHER *type = EVP_des_ede3_cbc(); /* Triple DES (cbd mode)    */
    unsigned char key[EVP_MAX_KEY_LENGTH];
    unsigned char iv[EVP_MAX_IV_LENGTH];
    unsigned char salt[PKCS5_SALT_LEN];
    unsigned char *dist;
    int dec_len;
    int pad_len;
    int rc;

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "decrypt_message start");

    if(src_len < sizeof(salt)) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
	      "[RBAC_ERR_002] [%s %d] bad decrypt: message is short %d < %d",
		      __FILE__, __LINE__, src_len, sizeof(salt));
        return NULL;                          /* оݥǡĹû */
    }
    memmove(salt, src, sizeof(salt));
    src += sizeof(salt);
    src_len -= sizeof(salt);

    EVP_BytesToKey(type, EVP_md5(), salt,
                    (unsigned char *)passwd, strlen(passwd), 1, key, iv);
                                              /* 業Υϥå岽(MD5)  */
    EVP_CIPHER_CTX_init(&ctx);                /* 楢르ꥺ   */
    EVP_CipherInit(&ctx, type, key, iv, 0);   /* ⡼("0")λ      */
    dist = apr_palloc(r->pool, src_len);
    EVP_CipherUpdate(&ctx, dist, &dec_len, (unsigned char *)src, src_len);
                                              /* src              */
    rc = EVP_CipherFinal(&ctx, dist + dec_len, &pad_len);
                                              /* ʸΥѥǥ󥰽 */
    EVP_CIPHER_CTX_cleanup(&ctx);
    if(rc == 0) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, rc, r,
		      "[RBAC_ERR_003] [%s %d] bad decrypt: invalid key: %s",
		      __FILE__, __LINE__, passwd);
        return NULL;                         /* 業ξ        */
    }
    dist[dec_len + pad_len] = '\0';

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "decrypt_message end");
    return dist;
}

/*****************************************************************************/
/*<ؿ̾    >  check_url_caseign()                                          */
/*<ǽ      >  ꥯURIʸʸ̤ʤȽꤹ        */
/*                                                                           */
/*<꥿>  1 -> פ(̤ʤ)                                    */
/*              0 -> פʤ(̤)                                    */
/*                                                                           */
/*****************************************************************************/
int check_url_caseign(request_rec *r, 
		      rbac_config_rec *conf)
{

    char **cipath;
    int num, i;

    num = conf->caseIgnPath->nelts;
    cipath = (char **)conf->caseIgnPath->elts;

    for(i=0; i < num; i++){
        if(cipath[i] != NULL && !strncmp(cipath[i], r->uri, strlen(cipath[i])))
            return 1;                     /* CaseIgnorePathȥURI */
    }                                     /* פ                    */

    return 0;
}

/*****************************************************************************/
/*<ؿ̾    >  check_cookie                                                 */
/*<ǽ      >  å沽ॢȽԤ                   */
/*                                                                           */
/*              Ϣǥ쥯ƥ֡RBACPassPhrase                           */
/*                                                                           */
/*<꥿>  TIMEOUT_URL  -> ͭڤ                                 */
/*              AUTH_ERR_URL -> ǧڣΣ                                     */
/*              AUTH_OK_URL  -> ǧڣϣ(r->user = userid)                   */
/*                                                                           */
/*****************************************************************************/
static int check_cookie(request_rec *r,
			rbac_config_rec *conf,
			const char *value)
{
    char *decoded;
    const char *cookie_contents;
    unsigned char *timestr;
    int l;

    const char *key = apr_psprintf(r->pool, "%s",
          conf->passPhrase);            /* 沽                    */
                            
    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "check_cookie start");
    decoded = (char *)apr_palloc(r->pool,
                                1 + apr_base64_decode_len(value));
    l = apr_base64_decode(decoded, value);
                                        /* £壶ǥ              */
   decoded[l] = '\0';
   if (!(cookie_contents = decrypt_message(r, decoded, l, key))){
                                       /* 沽»                         */
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
           "[RBAC_ERR_004] [%s:%d] cookie decrypt err: Cookie=%s",
                                           __FILE__, __LINE__, value);
        return AUTH_ERR_URL;           /* ۾ʥåȡǧNG   */
    }

    timestr = ap_getword(r->pool, &cookie_contents, '|');
                                       /* ͭ¾μФ               */

    r->user = (char *)cookie_contents; /* 桼ΣɣļФ                 */

    if((time_t)atoi(timestr) <= time(NULL)){
                                       /* ͭ⤫Ƚ                   */
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
           "[RBAC_ERR_005] [%s:%d] cookie timeout: %s:%s", 
                                        __FILE__, __LINE__, r->user, timestr);
        return TIMEOUT_URL;            /* ͭڤ쥨顼                 */
    }

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "check_cookie end");
    return AUTH_OK_URL;                /* ʥåȡǧOK   */
}

/*****************************************************************************/
/*<ؿ̾    >  get_cookie                                                   */
/*<ǽ      >  ǥ쥯ƥ֤ǻꤵ줿å                 */
/*                                                                           */
/*              Ϣǥ쥯ƥ֡RBACTicketName                           */
/*                                                                           */
/*<꥿>  å(å) ->                        */
/*              null                           -> ۾                       */
/*                                                                           */
/*****************************************************************************/
static unsigned char *get_cookie(request_rec *r, 
				 rbac_config_rec *conf)
{
    const char *token;
    const char *key;
    const char *value;
    const char *cookie_header;

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "rbac_get_cookie start");

    if(cookie_header = apr_table_get(r->headers_in, "Cookie")) {
                                        /* إåꥯåФ        */
        while(*cookie_header &&
	      (token=ap_getword(r->pool, &cookie_header, ' '))) {
                                        /* åͭʬ֤            */
            key   = ap_getword(r->pool, &token, '=');  
            value = ap_getword(r->pool, &token, ';');
                                        /* ڤͼФ                */
            if(!strcmp(key , conf->ticketName)) 
	      {                                
                ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
			      "rbac_get_cookie ok end");
                return (unsigned char *)value;
            }                           /* å̾Ȱפξ    */
	}                               /* ֵͤ                          */
    }        

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "rbac_get_cookie null end");

    return NULL;                        /* åȤ¸ߤʤ      */
}

/*****************************************************************************/
/*<ؿ̾    >  check_ticket                                                 */
/*<ǽ      >  åȤγǧԤ                               */
/*                                                                           */
/*<꥿> NOT_AUTH_URL -> å̵                          */
/*             TIMEOUT_URL  -> ͭڤ(check_cookieؿΥ꥿)    */
/*             AUTH_ERR_URL -> ǧڣΣ(check_cookieؿΥ꥿)        */
/*             AUTH_OK_URL  -> ǧڣϣ(check_cookieؿΥ꥿)        */
/*                                                                           */
/*****************************************************************************/
int check_ticket(request_rec *r, 
		 rbac_config_rec *conf)
{
    const char *cookie_value;
    unsigned char *value;

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "check_ticket start");

    if(value = get_cookie(r, conf)) {   /* åȼ              */
    	ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "check_ticket ok end");
        return check_cookie(r, conf, value);
    }                                   /* åȤǤ  */
                                        /* Ƥǧ̤֤            */

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "check_ticket ng end");

    return NOT_AUTH_URL;                /* å̵              */
}

/*****************************************************************************/
/*<ؿ̾    >  set_redirect_url                                             */
/*<ǽ      >  쥯ȣգң̤ԽԤʤ                             */
/*              󥢥գң̤ɣңţգң̡ɣǣţԥѥ᡼Ȥ     */
/*                                                                           */
/*              Ϣǥ쥯ƥ֡RBACAuthServer                           */
/*                                  RBACTicketTimeoutDocument                */
/*                                  RBACAuthLoc                              */
/*                                  RBACMyUrl                                */
/*                                                                           */
/*****************************************************************************/
void set_redirect_url(request_rec *r, 
		      rbac_config_rec *conf, 
		      int status)
{
    char *redirect_url;
    char *access_url;
    const char *base64_url;
    const char *percent_url;

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "set_redirect_url start");

    if(status == TIMEOUT_URL){          
        redirect_url = apr_pstrdup(r->pool, conf->timeoutDoc);
    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "timeoutDoc: %s", redirect_url);
                                     /* åȤͭڤξ */
                                     /* ͭڤ쥨顼                   */
    }else{ 
        if(conf->myUrl != NULL){        /* գң̻ξ                */
            access_url   = apr_pstrcat(r->pool, conf->myUrl, r->uri, NULL);
            if (r->args != NULL){       /* GETѥ᡼           */
                access_url = apr_pstrcat(r->pool, access_url, "?",
                                       r->args, NULL);
            }
        }else{                          /* գң̤ξ              */
            access_url = ap_construct_url(r->pool, r->unparsed_uri, r);
        }

	base64_url = ap_pbase64encode(r->pool, access_url);
                                        /* BASE64󥳡                  */
	percent_url = ap_escape_uri(r->pool, base64_url);
                                        /* ѡȥ󥳡              */
	redirect_url = apr_pstrcat(r->pool, conf->authServer,
                          "/?REURL=", percent_url, NULL);
    }                                   /* 쥯ȣգң̤Խ          */
    apr_table_set(r->headers_out, "Location", redirect_url );
                                        /* إåإ쥯ȣգң    */

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
		  "set_redirect_url end [%s]", redirect_url);
}

/*****************************************************************************/
/*<ؿ̾    >  check_resource_info                                          */
/*<ǽ      >  ݸоȽ                                             */
/*              RequireͤȽ                                              */
/*              桼Ƚ                                     */
/*              URLΥ꥽ꥹȹ¤Τ˥åȤ        */
/*                                                                           */
/*<꥿>  DECLINED                   -> ³                     */
/*              OK                         -> 桼ʵġ           */
/*              HTTP_INTERNAL_SERVER_ERROR -> ǧڥ顼                     */
/*              HTTP_FORBIDDEN             -> ¤ʤ顼                 */
/*                                                                           */
/*****************************************************************************/
int check_resource_info(request_rec *r)
{
    int result;                         
    int caseign;                        
    int m = r->method_number;           /* ꥯȥ᥽åֹμ      */
    register int x;
    const char *t, *w, *at;
    const apr_array_header_t *reqs_arr; 
    char **elt;
    apr_array_header_t *role;           
    require_line *reqs;                 

    rbac_config_rec *conf = 
        ap_get_module_config(r->per_dir_config, &auth_rbac_module);
                                        /* ǥ쥯ƥ־μ          */
    rbac_request_t *req = 
        (rbac_request_t *)apr_pcalloc(r->pool, sizeof(rbac_request_t));
    ap_set_module_config(r->request_config, &auth_rbac_module, req);
                                        /* ꥽󥨥ꥢν        */
                               
    req->rbac_flag = 0;                 /* RBACȽե饰ν            */
    req->public_flag = 0;               /* 桼Ƚե饰ν    */
    req->url = NULL;                    /* URLݥ󥿤ν     */
    req->allowed = NULL;                /* 롼ݥ󥿤ν    */
    
    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "check_resources_info in");

    if (!(at = (const char *)ap_auth_type(r)) || strcasecmp(at, "SSO"))
    {                                   /* AuthTypeͤμ                  */
    	ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
		      "auth_ticket_checker return end");
        return DECLINED;                /* authType = SSO Ǥʤ         */
    }                                   /* ϿƤϥɥ      */

    reqs_arr = ap_requires(r);          /* Requireͤμ                   */
    if (!reqs_arr) {                    /* RequireꤵƤʤ     */
        return DECLINED;                /* ϿƤϥɥ      */
    }
    reqs =(require_line *)reqs_arr->elts; 
                                       /* ơ֥빽¤ǤΥݥ󥿤 */
    for (x = 0; x < reqs_arr->nelts; x++) {
        if (!(reqs[x].method_mask & (AP_METHOD_BIT << m))) {
            continue;                   /* طʤꥯȥ᥽åɤؤ  */
        }                               /* ̵                        */

        t = reqs[x].requirement;
        w = ap_getword_white(r->pool, &t);
                                    /* Requireꤵ줿ɤФ */
        if (strcmp(w, "rbac")) {    /* Requireͤ"rbac"Ǥʤ           */
	  continue;             
        }

        req->rbac_flag = 1;            /* RBACȽե饰""         */

        caseign = check_url_caseign(r, conf);
                                       /* URLʸʸ̵뤹뤫Ƚ  */
        result = conf->get_resource_info(r, conf, req, caseign);
                                      /* ꥯURLΥ꥽ */
        if (result != LDAP_SUCCESS) {  
            ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
			  "[RBAC_ERR_001] [%s %d] getting ACL failed(%d)",
			  __FILE__, __LINE__, result);
	    return HTTP_INTERNAL_SERVER_ERROR;
        }                              /* ꥽θ˼Ԥ   */
                                       /* ǧڥ顼                         */
	if (req->url == NULL) {   
	    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
			  "url is out of access control");
	    return HTTP_FORBIDDEN;     /* ݸоURLǤʤä          */
	}                              /* ̵顼                     */

	role = apr_array_make(r->pool, 1, sizeof(char *));
	elt = apr_array_push(role);
	*elt = PUBLIC_ROLE;            /* 桼CN̾     */

        if (access_allowed(r, role, req->allowed) > 0) {
	    req->public_flag = 1;      /* 桼ե饰""     */
            ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "public resource");
	    return OK;             /* 桼ξʹߤν򥹥å */
        }                               
    }

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "check_resources_info out");
    return DECLINED;                   /* ϿƤϥɥ       */
}

/*****************************************************************************/
/*<ؿ̾    >  auth_ticket_checker                                          */
/*<ǽ      >  ʥåȳǧ                                     */
/*              åȤͭȽԤʤ                           */
/*              ͭǤʤˤϡǧڥФإ쥯ȤԤʤ         */
/*                                                                           */
/*<꥿>  OK                         -> åOK                     */
/*              DECLINED                   -> Υϥɥ                 */
/*                                            (åȳǧϤʤ)         */
/*              HTTP_INTERNAL_SERVER_ERROR -> ǧڥ顼                     */
/*              HTTP_FORBIDDEN             -> ¤ʤ顼                 */
/*              HTTP_MOVED_TEMPORARILY     -> ǧڥФإ쥯       */
/*                                                                           */
/*****************************************************************************/
int auth_ticket_checker(request_rec *r)
{
    int rc;
    rbac_config_rec *conf = ap_get_module_config(r->per_dir_config,
                                                    &auth_rbac_module);
                                        /* ǥ쥯ƥ־μ          */
    rbac_request_t *req = 
        (rbac_request_t *)ap_get_module_config(r->request_config, 
					       &auth_rbac_module);
                                        /* ꥽μ                */

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "auth_ticket_checker start");

    if (req->rbac_flag == 0)            /* RBACե饰"" ξ           */
        return DECLINED;                /* ϿƤϥɥ      */

    rc = check_ticket(r, conf);         /* åȤγǧ            */

    switch(rc)
    {
    case AUTH_OK_URL:
        ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
		      "auth_ticket_checker ok end ");
        return OK;                      /* ξϼνե    */
    case AUTH_ERR_URL:
        ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
		      "auth_ticket_checker err end ");
        return HTTP_FORBIDDEN;          /* ۾異åȥ顼        */
                                        /* ̵顼                    */
     default:
       set_redirect_url(r, conf, rc);   /* 쥯ȣգңԽ            */
       ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
		     "auth_ticket_checker redirect end");
       return HTTP_MOVED_TEMPORARILY;   /* åȤ̵        */
    }                                   /* ǧڥФإ쥯          */
                                        /* ERR-302 ȯ                      */
}

/*****************************************************************************/
/*<ؿ̾    > rbac_check_auth                                               */
/*<ǽ      > ʥ                                              */
/*             ǧںѤߥ桼Ƚ                                */
/*             ʥȽȽ                                */
/*                                                                           */
/*<꥿> OK                         -> ¤()                  */
/*             HTTP_INTERNAL_SERVER_ERROR -> 롼빽ʸ顼        */
/*             HTTP_FORBIDDEN             -> ¤ʤ顼                  */
/*                                                                           */
/*****************************************************************************/
int rbac_check_auth(request_rec *r)
{
    int result, rc;
    char **elt;
    apr_array_header_t *role;

    rbac_config_rec *conf = 
        ap_get_module_config(r->per_dir_config, &auth_rbac_module);
                                        /* ǥ쥯ƥ־μ          */
    rbac_request_t *req = 
        (rbac_request_t *)ap_get_module_config(r->request_config, 
					       &auth_rbac_module);
                                        /* ꥽μ                */

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "rbac_check_auth in");

    if (req->rbac_flag == 0)            /* Require  rbac ξ        */
        return DECLINED;                /* ϿƤϥɥ      */

    if (req->public_flag == 1)          /* 桼ξ                */
        return OK;                      /* νե                */

    if (req->allowed == NULL)
    {
        ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
		      "rbac_check_auth req->allowed==NULL NG  out");
        return HTTP_FORBIDDEN;          /* 롼cecssoAccessRule */
    }                                   /* ̵硢̵顼        */

    if (r->user == NULL)
    {
        ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r,
		      "rbac_check_auth r->user==NULL NG  out");
        return HTTP_FORBIDDEN;          /* åȤ˥桼IDϿ  */
    }                                   /* ʤä硢̵顼  */

    role = apr_array_make(r->pool, 1, sizeof(char *));
    elt = apr_array_push(role);
    *elt = VALIDUSER_ROLE;           /* ǧںѤߥ桼CN̾ */

    result = conf->get_user_role(r, conf, role);
                                        /* 桼ʴܡ̡ˤμ  */
    if (result != LDAP_SUCCESS) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r, 
		      "[RBAC_ERR_008] [%s %d] getting user role failed(%d)",
		      __FILE__, __LINE__, result);
        return HTTP_INTERNAL_SERVER_ERROR;
    }                                   /* 桼θ˼Ԥ  */
                                        /* ǧڥ顼                        */

    rc = access_allowed(r, role, req->allowed);
                                        /* ǧںѤߥ桼Ƚ            */
                                        /* ʥȽ        */
    if (rc > 0) {
        ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r,
		      "rbac_check_auth access_allowed=OK out");
        return OK;                      /* ¤ʼνեء    */
    } else if (rc < 0) {
        ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r,
		      "rbac_check_auth access_allowed=ERROR out");
        return HTTP_INTERNAL_SERVER_ERROR;
                                        /* 롼빽ʸ顼          */
    } else {
        ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r,
		      "rbac_check_auth access_allowed=NG out");
        return HTTP_FORBIDDEN;          /* ¤ʤ顼                    */
    }
}

/*****************************************************************************/
/*<ؿ̾    >  user_info_proxy                                              */
/*<ǽ      >  ǧղþꡢĶѿѤ                       */
/*              ̳ФإåˤǧղþԤ             */
/*              ̳ФشĶѿΰѤԤ                         */
/*                                                                           */
/*              Ϣǥ쥯ƥ֡RBACProxyCookie on/off                   */
/*                                  RBACProxyEnv on/off                      */
/*                                                                           */
/*<꥿>  OK                         -> ｪλ                       */
/*              HTTP_INTERNAL_SERVER_ERROR -> ǧڥ顼                     */
/*              HTTP_SERVICE_UNAVAIRABLE   -> Х顼                   */
/*                                                                           */
/*****************************************************************************/
int user_info_proxy(request_rec *r)
{
    const char *token;
    const char *key;
    const char *value;
    const char *t;
    const char *cookie_data;
    const char *cookie_save;
    char **ticket_list;
    int res;
    int i;
    apr_table_t *arg_cookies;

    apr_array_header_t *proxy_ticket = 
                     apr_array_make(r->pool, 1, sizeof(char *));
                                        /* ǧղþǼκ        */

    rbac_config_rec *conf = ap_get_module_config(r->per_dir_config,
                                                    &auth_rbac_module);
                                        /* ǥ쥯ƥ־μ          */

    rbac_request_t *req = (rbac_request_t *)
      ap_get_module_config(r->request_config, &auth_rbac_module);
                                        /* ꥽μ                */

    if (req->rbac_flag == 0)            /* Require  rbac ξ        */
      return OK;                        /* νե                */

    if (req->public_flag == 1)          /* 桼ξ                */
      return OK;                        /* νե                */

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "rbac_proxy_userinfo start");

    if(conf->proxyenv)                   /* ĶѿΰѤ           */        
      {
	apr_table_set(r->headers_in, "X_FORWARDED_REMOTE_USER", r->user);
                                        /* Ķѿǥ쥯ƥͤonʤ  */
                                        /* Ķѿ˥桼ID򥻥åȤ    */
	ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r,
		      "HTTP_X_FORWARDED_REMOTE_USER: %s",r->user);
      }

    if(!conf->proxy)                    /* ǧղþ            */          
    {
    	ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, 
		      "rbac_proxy_userinfo return end");
        return OK;                      /* OFFξ                     */
    }                                   /* νե                */

    res = conf->get_user_ticket(r, conf, proxy_ticket);
                                        /* ǧղþμ                */
    if (res != LDAP_SUCCESS) {
      if (res == LDAP_SERVER_DOWN)
        {
	  ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
			"[RBAC_FAL_001] [%s %d] ldap server down",
			__FILE__, __LINE__);
	  return HTTP_SERVICE_UNAVAILABLE; /* LDAP³顼                */ 
	}
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r, 
                   "[RBAC_ERR_006] [%s:%d] getting user failed(%d) %s",
                                      __FILE__, __LINE__, res, r->user);
        return HTTP_INTERNAL_SERVER_ERROR; /* ǧڥ顼                     */
    }
                  
    if (proxy_ticket->nelts == 0) {
        ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
			"[RBAC_ERR_013] [%s %d] no arg cookie!!",
			__FILE__, __LINE__);
        return OK;                      /* ǧղþ̵ξ            */
    }                                   /* νե                */

    arg_cookies = apr_table_make(r->pool, 10);
    cookie_save = apr_table_get(r->headers_in, "Cookie");
                                        /* ꥯȥå            */
    cookie_data = NULL;
    ticket_list = (char **)proxy_ticket->elts;
    for(i = 0; i < proxy_ticket->nelts; i++){
        token = ticket_list[i];
        key   = ap_getword(r->pool, &token, '=');
        value = ap_getword(r->pool, &token, '\0');
        apr_table_set(arg_cookies, key, value);
        if(cookie_data == NULL){
            cookie_data = apr_pstrdup(r->pool, ticket_list[i]);
        }else{
            cookie_data = apr_psprintf(r->pool, 
                                    "%s; %s",cookie_data, ticket_list[i]);
        }
    }

    while(*cookie_save && (token = ap_getword(r->pool, &cookie_save, ' '))){
                                         /* ꥯȥåǧղþ */
                                         /* Υޡ                     */
        key   = ap_getword(r->pool, &token, '=');
        value = ap_getword(r->pool, &token, '\0');

        if(! apr_table_get(arg_cookies, key)){
                                         /* ǧղþȼå     */
                                         /* å̾פʤ       */
            if(cookie_data == NULL){
                cookie_data = apr_psprintf(r->pool,"%s=%s", key, value);
            }else{
                cookie_data = apr_psprintf(r->pool, 
                                    "%s; %s=%s",cookie_data, key, value);
            }
        }else{
            ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r, "delete_key=%s", key);
        }
    }
                                        /* ǧղþ                */
    apr_table_set(r->headers_in, "Cookie", cookie_data);

    ap_log_rerror(APLOG_MARK, APLOG_DEBUG, 0, r,
		  "rbac_proxy_userinfo end [cookie: %s]", cookie_data);
    return OK;                          /* νե                */
}

#ifdef RBAC_ACCESS_RULE
/*****************************************************************************/
/*<ؿ̾    >  role_match                                                   */
/*<ǽ      >  ʸޥå󥰽                                         */
/*                                                                           */
/*<꥿>  1 -> ޥåOK                                            */
/*              0 -> ޥåNG                                            */
/*                                                                           */
/*****************************************************************************/
int role_match(char *str, 
	       int len, 
	       const apr_array_header_t *role)
{
  int i;
  int rc;
  char *strp = str;
  const char **role_list;


  while (isspace(*strp)) {              /* ʸκ                    */
    strp++;
    len--;
  }
  while (isspace(*(strp + len - 1)))    /* ʸκ                */
    len--;

  role_list = (const char **)role->elts;

  for (i = 0; i < role->nelts; i++){
    if (len == strlen(role_list[i]) && !strncasecmp(role_list[i], strp, len)) {
      return 1;
    }
  }

  return 0;
}

/*****************************************************************************/
/*<ؿ̾    >  parse_term                                                   */
/*<ǽ      >  롼ιʸ                             */
/*              롼ȥ桼ʸޥå               */
/*                                                                           */
/*<꥿>   1 -> ޥåOK                                           */
/*               0 -> ޥåNG                                           */
/*              -1 -> ʸ顼                                             */
/*                                                                           */
/*****************************************************************************/
int parse_term(request_rec *r, 
	       char **strpp, 
	       const apr_array_header_t *role)
{
  int rc;
  int skip_flag = 0;
  int i;
  char *strp;
  char *p;

  strp = *strpp;

  if (!*strp || role == NULL)
    return -1;

  while (isspace(*strp))                      /* ʸκ              */
    strp++;

  p = strp;

  for (; *p; p++) {
    if (*p == '(') {                          /* Ƭݥ󥿤'('ξ     */
      p++;
      rc = parse_term(r, &p, role);
    } else if (*p == ')') {                   /* Ƭݥ󥿤')'ξ     */
      if (*strp != '(') {
        rc = role_match(strp, p - strp, role);
      }
      break;
    } else if (*p == '&') {                   /* Ƭݥ󥿤'&'ξ     */
      if (*strp != '(') {
        rc = role_match(strp, p - strp, role);
      }
      if (!*(p + 1))
        return -1;                            /* ʸ顼                  */

      strp = p + 1;
      while(isspace(*strp)) {                 /* κ                */
        strp++;
        p++;
      }

      if (rc > 0) {
        continue;
      } else {
        for (; *p; p++) {
          if (*p == '(') {
            if (skip_term(&p) < 0) {
              rc = -1;                  
              break;
            }
          } else if (*p == '|')
	    break;
	  else if (*p == ')') {
	    p--;
            break;
	  }
        }
        skip_flag = 0;

        strp = p;
        if (*p != '\0')
          strp++;
        continue;
      }
    } else if (*p == '|') {                   /* Ƭݥ󥿤'|'ξ     */
      if (*strp != '(') {
        rc = role_match(strp, p - strp, role);
      }
      if (!*(p + 1))
        return -1;                            /* ʸ顼                  */

      strp = p + 1;
      while(isspace(*strp)) {                 /* κ                */
        strp++;
        p++;
      }

      if (rc > 0) {
        for (; *p; p++) {
          if (*p == '(') {
            if (skip_term(&p) < 0) {
              rc = -1;                        /* ʸ顼                  */
              break;
            }
          } else if ( *p == ')')
            break;
        }
        skip_flag = 1;
        break;
      } else {
        continue;
      }
    }
  }

  if (*strp != '(' && !skip_flag) {
    rc = role_match(strp, p - strp, role);
  }

  *strpp = p;

  return rc;
}

/*****************************************************************************/
/*<ؿ̾    >  skip_term                                                    */
/*<ǽ      >  򥹥åפ                               */
/*                                                                           */
/*<꥿> -1      -> ʸ顼                                         */
/*             rc(= 0) ->                                  */
/*                                                                           */
/*****************************************************************************/
int skip_term(char **strpp)
{
  int rc = -1;
  char *p;

  p = *strpp;
  p++;

  if (!*p)
    return -1;

  for (; *p; p++) {                     /* ')'Ȱפޤǥݥ󥿤򥷥ե */
    if (*p == '(') {
      if((rc = skip_term(&p)) < 0)
        break;
    } else if (*p == ')') {
      rc = 0;
      break;
    }
  }

  *strpp = p;

  return rc;
}
#endif

/*****************************************************************************/
/*<ؿ̾    >  access_allowed                                               */
/*<ǽ      >  롼ȥ桼                           */
/*                                                                           */
/*<꥿>  1 -> ¤                                                */
/*              0 -> ̵                                                */
/*             -1 -> ʸ顼                                              */
/*                                                                           */
/*****************************************************************************/
int access_allowed(request_rec *r, 
		   const apr_array_header_t *role, 
		   char **aci_list)
{
    int rc, i, j;
    const char **role_list;

    if (role == NULL)
      return 0;
    
    if (aci_list == NULL)
      return 0;
    
    for (i = 0; aci_list[i] != NULL; i++) {
                                     /* 롼뤬ʣ緫֤ */
#ifdef RBAC_ACCESS_RULE
      char *aci = aci_list[i];
      rc = parse_term(r, &aci, role);
      if (rc == 1) return 1;         /* 롼뤬ʣ         */
                                     /* ̤ˤʤäǸ¤֤   */
#else
      role_list = (const char **)role->elts;
      for (j = 0; j < role->nelts; j++){
                                     /* 桼롼뤬ʣ緫֤   */
	rc = !strcasecmp(aci_list[i], role_list[j]);
	if (rc == 1) return 1;       /* 롼뤬ʣ         */
      }                              /* ̤ˤʤäǸ¤֤ */
#endif
    }
    return 0;                        /* ¤ʤ                             */
}
