<?php
namespace sfjp\Wiki\Processor;
use sfjp\Wiki\Exception;
abstract class Base {
	private $context;
	public $is_vary;
	public $text;
	public $formatted_text;
	public $preproc;
	public $postproc;
	public $formatter;
	public $args = array();

	protected static $reserved = array('__halt_compiler', 'abstract', 'and', 'array', 'as', 'break', 'callable', 'case', 'catch', 'class', 'clone', 'const', 'continue', 'declare', 'default', 'die', 'do', 'echo', 'else', 'elseif', 'empty', 'enddeclare', 'endfor', 'endforeach', 'endif', 'endswitch', 'endwhile', 'eval', 'exit', 'extends', 'final', 'for', 'foreach', 'function', 'global', 'goto', 'if', 'implements', 'include', 'include_once', 'instanceof', 'insteadof', 'interface', 'isset', 'list', 'namespace', 'new', 'or', 'print', 'private', 'protected', 'public', 'require', 'require_once', 'return', 'static', 'switch', 'throw', 'trait', 'try', 'unset', 'use', 'var', 'while', 'xor');

	protected static $context_key_rename_rules = array(
		'plugin_include_path' => 'extension.additional_include_path',
		'plugin.order' => 'extension.acl_order',
		'plugin.allow' => 'extension.allow',
		'plugin.deny' => 'extension.deny',
		'supress_plugin_error' => 'extension.hide_error',
	);

	function __construct($args = null) {
		$default_ctx = array("wiki_baseurl"  => ".",
				     "site_root_url" => (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://" . (empty($_SERVER['HTTP_HOST']) ? 'localhost.localdomain' : $_SERVER['HTTP_HOST']),
				     "svn_base_url"  => "http://svn.sourceforge.jp/view",
				     "cvs_base_url"  => "http://cvs.sourceforge.jp/view",
				     "sfjp.group_name"    => null,
				     "sfjp.group_id"      => null,
				     "extension.additional_include_path" => null,
				     "extension.acl_order" => "deny,allow",
				     "extension.allow"  => array(),
				     "extension.deny"   => array(),
				     "extension.hide_error" => false,
				     "self_url"      => array_key_exists('REQUEST_URI', $_SERVER) ? $_SERVER['REQUEST_URI'] : '',
				     "cache_manager" => null,
				     "cache_depends" => array(),
				     "whole_page_cachable" => true,
				     "head_excess"   => 0,
				     "gen_head_id"   => true,
				     "internal_url_regex" => null,
				     "nofollow_on_external_links" => true,
				     );
		$this->context = $default_ctx;
		$this->clearPreProc();
		$this->clearPostProc();
	}

	function __destruct() {
		unset($this->formatter);
	}

	public function setArgs($args) {
		if (!is_array($args))
			$args = array($args);
		$this->args = $args;
	}

	public function getArgs($pos = null) {
		if (is_null($pos))
			return $this->args;
		return $this->args[$pos];
	}

	public function getContext($key = null) {
		if (isset($key)) {
			$key = static::renameContextKey($key);
			return array_key_exists($key, $this->context) ? $this->context[$key] : null;
		} else {
			return $this->context;
		}
	}

	static public function renameContextKey($key) {
		if (!array_key_exists($key, static::$context_key_rename_rules))
			return $key;
		return static::$context_key_rename_rules[$key];
	}


	public function hasContext($key) {
		return array_key_exists(static::renameContextKey($key), $this->context);
	}

	public function setContext($c) {
		foreach ($c as $key => $val) {
			$key = static::renameContextKey($key);
			$this->context[$key] = $val;
		}
		$this->context = array_merge($this->context, $c);
	}

	public function removeContext($key) {
		unset($this->context[static::renameContextKey($key)]);
	}
  
	public function clearContext() {
		$this->context = array();
	}

	public function incrementCounter($name) {
		$c = &$this->getCounter($name);
		return ++$c;
	}

	public function &getCounter($name) {
		$c = &$this->context["counters"];
		if (!isset($c[$name])) {
			$c[$name] = 0;
		}
		return $c[$name];
	}

	public function setCounter($name, $val) {
		$c = &$this->context["counters"];
		$c[$name] = $val;
	}

	public function clearCounter($name = null) {
		if (isset($name)) {
			$this->setCounter($name, 0);
		} else {
			$this->setContext(array("counters" => array()));
		}
	}

	public function &getCacheDepends() {
		return $this->context["cache_depends"];
	}

	public function addCacheDepends($deps) {
		if (empty($deps)) return;
		if (!is_array($deps)) $deps = array($deps);
		$c = &$this->context["cache_depends"];
		foreach ($deps as $dep) {
			$c []= $dep;
		}
	}

	public function clearCacheDepends() {
		$this->context["cache_depends"] = array();
	}

	public function reset() {
		$this->is_vary = false;
		$this->text = "";
		$this->formatted_text = "";
		$this->clearCounter();
		$this->clearPreProc();
		$this->clearPostProc();
		$this->clearCacheDepends();
		if ($this->getFormatter())
			$this->getFormatter()->reset();
	}

	public function isVary() {
		return $this->is_vary;
	}

	public function setText($text) {
		$old = $this->text;
		$this->text = $text;
		return $old;
	}

	public function getText() {
		return $this->text;
	}

	public function getFormattedText() {
		$ret = '';
		foreach ($this->preproc as $p) {
			$ret .= $p->process();
		}
		$ret .= $this->formatted_text;
		foreach ($this->postproc as $p) {
			$ret .= $p->process();
		}
		return $ret;
	}

	public function get_plugin_instance($class_name) {
		$check_name = str_replace('\\', '/', $class_name);
		$name = basename($check_name);

		if (!$this->check_plugin_allowed($check_name))
			throw new Exception\Plugin_Error("Load Denied: $name");
		if (!preg_match('/^[A-Za-z0-9._-]+$/', $name))
			throw new Exception\Plugin_error("Wrong Plugin Name: $name");

		if (in_array(strtolower($name), self::$reserved)) {
			$class_name = substr($class_name, 0, strlen($class_name) - strlen($name)) . "_{$name}";
		}

		try {
			$orig_include_path = null;
			if ($this->getContext('extension.additional_include_path')) {
				$orig_include_path = ini_get('include_path');
				ini_set('include_path', $this->getContext('extension.additional_include_path').":$orig_include_path");
			}
			$class = new \ReflectionClass("\\sfjp\\Wiki\\{$class_name}");
			if ($orig_include_path)
				ini_set('include_path', $orig_include_path);
			$instance = $class->newInstance($this);
			if (!is_callable(array($instance, "process")))
				throw new \ReflectionException();
		} catch (\ReflectionException $e) {
			ini_set('include_path', $orig_include_path);
			error_log("Plugin '$name' load failed.");
			throw new Exception\Plugin_Error("Not Found: {$name}");
		}
		return $instance;
	}



	protected function check_plugin_allowed($name) {
		$order = $this->getContext("plugin.order");
		$allow = $this->getContext("plugin.allow");
		$deny  = $this->getContext("plugin.deny");
		$ret   = false;
		if (!$order) $order = "deny,allow";
		$order = strtolower($order);
		if (!is_array($allow)) $allow = array($allow);
		if (!is_array($deny)) $deny = array($deny);
		$deny  = array_map('strtolower', $deny);
		$allow = array_map('strtolower', $allow);
		$name  = strtolower($name);

		if ($order === "deny,allow") {
			$ret = true;
			if (in_array('all', $deny))  $ret = false;
			if (in_array($name, $deny))  $ret = false;
			if (in_array('all', $allow)) return true;
			if (in_array($name, $allow)) return true;
		} else { # "allow,deny"
				$ret = false;
			if (in_array('all', $allow)) $ret = true;
			if (in_array($name, $allow)) $ret = true;
			if (in_array('all', $deny))  return false;
			if (in_array($name, $deny))  return false;
		}
		return $ret;
	}

	public function addPreProc($obj) {
		$this->preproc[] = $obj;
	}

	public function clearPreProc() {
		$this->preproc = array();
	}

	public function addPostProc($obj) {
		$this->postproc[] = $obj;
	}

	public function clearPostProc() {
		$this->postproc = array();
	}

	public function getFormatter() {
		return $this->formatter;
	}

	public function setFormatter($f) {
		$this->formatter = $f;
		if (!$this->formatter->getProcessor())
			$this->formatter->setProcessor($this);
	}

	public function __($text, $args=array()) {
		if (!$this->hasContext('i18n')) {
			return $text;
		} else {
			return $this->getContext('i18n')->__($text, $args);
		}
	}
}
