<?php
namespace sfjp\Wiki\Formatter;
abstract class Base {
	protected $processor;
	function __construct() {
	}

	function __destruct() {
		unset($this->processor);
	}

	public function cleanup() {}

	public function reset() {}

	public function setProcessor($proc) {
		$this->processor = $proc;
	}

	public function getProcessor() {
		return $this->processor;
	}

	public function setContext($c) {
		return $this->getProcessor()->setContext($c);
	}

	public function getContext($key = null) {
		return $this->getProcessor()->getContext($key);
	}

	public function __($text, $args=array()) {
		return $this->getProcessor()->__($text, $args);
	}

	abstract public function raw_node($string);
	abstract public function text_node($text);
	abstract public function open_element($neme, $opt = null);
	abstract public function close_element($name, $opt = null);

	static public function escape_id_value($str) {
		$str = preg_replace_callback('/[^A-Za-z0-9_:.-]+/',
					     create_function('$m', '$p = unpack("H*", $m[0]); return $p[1];'),
					     $str);
		if (!ctype_alpha(substr($str, 0, 1))) $str = "badid-".$str;
		return $str;
	}
}