<?php
namespace sfjp\Wiki\Processor;
if (!function_exists("kses"))
  require_once("kses.php");

class HTML extends Base {
  static public $allowed = array(
    'h1' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'h2' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'h3' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'h4' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'h5' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'h6' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'div' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'span' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'address' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'em' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'strong' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'dfn' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'code' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'samp' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'kbd' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'var' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'abbr' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'acronym' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'blockquote' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'cite' => 1),
    'q' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'cite' => 1),
    'sub' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'sup' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'p' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1),
    'br' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'clear' => 1),
    'pre' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'width' => 1),
    'ins' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'cite' => 1, 'datetime' => 1),
    'del' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'cite' => 1, 'datetime' => 1),
    'ul' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'type' => 1),
    'ol' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'type' => 1, 'start' => 1),
    'li' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'type' => 1, 'value' => 1),
    'dl' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'dt' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'dd' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'table' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'width' => 1, 'summary' => 1, 'border' => 1, 'cellspacing' => 1, 'cellpadding' => 1, 'align' => 1, 'valign' => 1, 'bgcolor' => 1),
    'tbody' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1, 'valign' => 1),
    'thead' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1, 'valign' => 1),
    'tfoot' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1, 'valign' => 1),
    'colgroup' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'width' => 1, 'span' => 1, 'align' => 1, 'valign' => 1),
    'col' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'width' => 1, 'span' => 1, 'align' => 1, 'valign' => 1),
    'tr' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1, 'valign' => 1, 'bgcolor' => 1),
    'th' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1, 'valign' => 1, 'abbr' => 1, 'axis' => 1, 'headers' => 1, 'scope' => 1, 'rowspan' => 1, 'colspan' => 1, 'bgcolor' => 1),
    'td' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'align' => 1, 'valign' => 1, 'abbr' => 1, 'axis' => 1, 'headers' => 1, 'scope' => 1, 'rowspan' => 1, 'colspan' => 1, 'bgcolor' => 1),
    'a' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'href' => 1, 'name' => 1, 'rel' => 1, 'rev' => 1, 'accesskey' => 1, 'tabindex' => 1, 'title' => 1),
    'img' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'src' => 1, 'alt' => 1, 'name' => 1, 'height' => 1, 'width' => 1, 'border' => 1, 'title' => 1, 'align' => 1),
    'tt' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'i' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'b' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'big' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'small' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    's' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'u' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'font' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'size' => 1, 'color' => 1, 'face' => 1),
    'hr' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1), 'noshade' => 1, 'align' => 1, 'size' => 1, 'width' => 1),
    'wbr' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
    'nobr' => array('id' => 1, 'class' => 1, 'style' => array('cssfilter' => 1)),
  );

  public function __construct($args = null) {
    parent::__construct();
  }

  public function process($text) {
    $this->formatted_text = $this->getFormatter()->raw_node(kses($text, self::$allowed, array('http', 'https', 'ftp')));
    return $this;
  }
}
