<?php
namespace sfjp\Wiki\Plugin;
use sfjp\Wiki\Exception\Plugin_Error;
class PageOutline extends Base {
	public $is_vary = false;
	public $is_block = true;
	public function process($args) {
		$proc = $this->processor;
		$opt = array('start' => 1, 'depth' => 3, 'type' => 'ordered');
		$opt['title'] = $this->__('Outline');
		$counter = array();

		foreach ($args as $arg) {
			if (!strpos($arg, '='))
				return $this->error("unknown argument $arg");
			list($key, $value) = explode('=', $arg, 2);
			if (!$key || !array_key_exists($key, $opt))
				return $this->error("unknown argument $arg");
			$opt[$key] = $value;
		}

		$text  = "";
		$match = array();
		$orig  = $proc->getText();
		$orig  = preg_replace('/^{{{.*?^}}}/sm', '', $orig);
		foreach($proc->getBlockstyleRules() as $r) {
			if ($r[0] != "heading")
				continue;
			$headre = $r[1];
			break;
		}
		$parser = new \sfjp\Wiki\Parser(array());
		preg_match_all("/$headre/m", $orig, $match);
		for($h = 0; array_key_exists($h, $match[1]); $h++) {
			$level  = strlen($match[1][$h]);
			$label  = preg_replace('/<.*?>/', '', $parser->parse(preg_replace('/\[\[.*?\]\]/', '', $match[0][$h])));
			if (isset($match[3][$h]) && strlen($match[3][$h])) {
				$linkid = trim($match[3][$h]);
			} else {
				$linkid = "h" . ($level + intval($proc->getContext('head_excess'))) . "-";
				$linkid .= preg_replace_callback($parser->processor->getInlinestyleRegex(),
								 create_function('$m', 'return empty($m[1]) ? "" : substr($m[0], 1);'),
								 trim($match[2][$h]));
			}
			if (!isset($counter)) $counter[$linkid] = 0;
			$c =& $counter[$linkid];
			if (++$c > 1) $linkid .= "-{$c}";
			$linkid = str_replace('%', '.', rawurlencode($linkid));

			$outlevel = $level - ($opt['start']-1);
			if ($outlevel > 0 && $outlevel <= $opt['depth'])
				$text .= sprintf("%".($outlevel*2)."s%s [#%s %s]\n", '',
						 ($opt['type'] == 'unordered' ? '*' : '1.'),
						 $linkid, htmlspecialchars_decode($label));
		}
		return $this->getFormatter()->raw_node(
						       '<div class="pageoutline"><div class="pageoutline-title">'
						       . '<div class="action">'
						       . '<button type="button" onClick="javascript:togglePageOutline(this)">'
						       . '<img src="//static.sourceforge.jp/wiki/images/icons/roll-up.gif" border="0"></button>'
						       . '</div>'
						       . $this->__($opt['title']) 
						       . '</div>' . $parser->parse($text) . '</div>');
	}


}