<?php
namespace sfjp\Wiki\Plugin;
use sfjp\Wiki\Exception\Plugin_Error;
abstract class Base {
	public $is_vary  = true;
	public $is_block = false;
	public $processor;

	function __construct($processor) {
		$this->processor = $processor;
	}

	public function setContext($ctx) {
		return $this->processor->setContext($ctx);
	}

	public function getContext($key=null) {
		return $this->processor->getContext($key);
	}

	public function error($msg) {
		$this->setContext(array('whole_page_cachable' => false));
		throw new Plugin_Error($msg);
	}

	public function __($text, $args=array()) {
		if (!$this->processor->hasContext('i18n')) {
			return $text;
		} else {
			return $this->getContext('i18n')->__($text, $args);
		}
	}

	public function getProcessor() {
		return $this->processor;
	}

	public function getFormatter() {
		return $this->getProcessor()->getFormatter();
	}

	public function parseArgs($args, $list = array(), $default = null) {
		$opt = array();
		foreach ($args as $arg) {
			if (strpos($arg, '=')) {
				list($key, $value) = explode('=', $arg, 2);
				if (!$key)
					continue;
			} elseif (isset($default) && !empty($default)) {
				$key = $default;
				$value = $arg;
			}
			if (!in_array($key, $list) && !array_key_exists($key, $list)) {
				$this->error("unknown argument $arg");
			}
			$opt[$key] = $value;
		}
		return $opt;
	}

	public function render_table($data) {
		$fmt = $this->getFormatter();
		$ret = '';

		$ret .= $fmt->open_element('table');
		foreach ($data as $cols) {
			$ret .= $fmt->open_element('table_row');
			foreach ($cols as $col) {
				$ret .= $fmt->open_element('table_col');
				$ret .= $col;
				$ret .= $fmt->close_element('table_col');
			}
			$ret .= $fmt->close_element('table_row');
		}
		$ret .= $fmt->close_element('table');
		return $fmt->raw_node($ret);
	}

	public function render_date_separated_list($data) {
		$wikistr = '';
		$last_date = null;

		foreach ($data as $item) {
			if ($last_date != date('Y-m-d', $item[0])) 
				$wikistr .= "==== " . date('Y-m-d', $item[0]) . " ====\n";
			$last_date = date('Y-m-d', $item[0]);
			$wikistr .= " * " . $item[1];
		}
		$p = new \sfjp\Wiki\Parser($this->getContext());
		return $this->getFormatter()->raw_node($p->parse($wikistr));
	}

}