<?php
namespace sfjp\Wiki;

class Parser {
	public $text;
	public $processor;

	function __construct($context = null, $processor = null, $formatter = null) {
		if ($processor) {
			$this->processor = $processor;
		} else {
			$this->processor = new Processor\Trac();
		}
		if ($context)
			$this->processor->setContext($context);
		if ($formatter)
			$this->processor->setFormatter($formatter);
		$storage_class = $this->processor->getContext('storage.class');
		if (!$storage_class) $storage_class = 'Dummy';
		$c = new \ReflectionClass("sfjp\\Wiki\\Storage\\{$storage_class}");
		$storage = $c->newInstance();
		$this->processor->setContext(array('storage' => $storage));
	}

	public function parse($text) {
		$this->processor->reset();
		return $this->processor->process($text)->getFormattedText();
	}

	public function getFormattedText() {
		return $this->processor->getFormattedText();
	}

	public function isVary() {
		return $this->processor->isVary();
	}
  
	public function setContext($c) {
		$this->processor->setContext($c);
	}

	public function getContext($key = null) {
		return $this->processor->getContext($key);
	}

	public function removeContext($key) {
		$this->processor->removeContext($key);
	}

	public function clearContext() {
		$this->processor->clearContext();
	}

	public function reset() {
		$this->processor->reset();
	}
}
