module OSDN; module CLI; module Command
  class Login < Base
    def run
      logger.debug "Trying login"
      scope = %w(profile group group_write)

      auth_url = "https://#{OSDNClient.configure.host}/account/oauth2ui/authorize?client_id=#{CLI.client_id}&state=cli#{Time.now.to_i}&response_type=code&scope=#{scope.join('%20')}"

      launch_brwoser auth_url
      puts
      authcode = prompt("Type your auth code: ")
      puts
      if authcode.empty?
        logger.error "Empty auth code, login has been canceled."
        return
      end

      api = OSDNClient::DefaultApi.new
      begin
        set_credential api.token(CLI.client_id, CLI.client_secret, code: authcode)
      rescue OSDNClient::ApiError => e
        begin
          err = JSON.parse(e.response_body)
          logger.fatal err["error_description"]
        rescue
          logger.fatal "Failed to get access token"
        end
        return
      end
    end

    def launch_brwoser(url)
      puts "Access follwoing URL to get auth code;\n#{url}"
      %w(/usr/bin/xdg-open /usr/bin/X11/xdg-open /usr/local/bin/xdg-open
             /usr/bin/x-www-browser /usr/bin/firefox /usr/local/bin/firefox
            ).each do |bin|
        File.executable?(bin) or next
        exec(bin, url) if fork.nil?
        return
      end
      case RUBY_PLATFORM
      when /mswin|msys|mingw|cygwin|bccwin|wince|emc/
        exec("start #{url}") if fork.nil?
      when /darwin|mac os/
        exec("/usr/bin/open", url) if fork.nil?
      end
    end

    def prompt(msg = "", newline = false)
      require 'readline'
      msg += "\n" if newline
      Readline.readline(msg, true).to_s.squeeze(" ").strip
    end

    def help
      puts "#{$0} login"
    end

    def self.description
      "Login and save access token."
    end
  end
end; end; end
