require 'osdn/cli/command/frs_base'

module OSDN; module CLI; module Command
  class Package < FrsBase
    def help
      puts "#{$0} package [opts] [list]"
      puts "#{$0} package [opts] create <new-package-name>"
      puts "#{$0} package [opts] update <numeric-package-id> [name]"
      puts "#{$0} package [opts] delete <numeric-package-id>"
      puts "Options:"
      puts "  -f --format=<pretty|json>  Set output format"
      puts "  -p --project=<project>     Target project (numeric id or name)"
      puts "  -v --visibility=<public|private|hidden>"
    end

    def self.description
      "Manipulate release package of project"
    end

    def process_options
      opts = GetoptLong.new(
        [ '--format', '-f', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--project', '-p', GetoptLong::REQUIRED_ARGUMENT ],
        [ '--visibility', '-v', GetoptLong::REQUIRED_ARGUMENT ],
      )
      opts.each do |opt, arg|
        case opt
        when '--format'
          arg == 'json' and
            self.format = arg
        when '--project'
          arg.empty? or
            @target_proj = arg
        when '--visibility'
          unless %w(public private hidden).member?(arg)
            logger.fatal "Invalid visibility status: #{arg}"
            exit
          end
          @visibility = arg
        end
      end
    end

    def list
      list = api.list_packages target_proj
      if format == 'json'
        puts list.map{|i| i.to_hash}.to_json
      else
        list.each do |p|
          puts format_package(p)
        end
      end
    end

    def create
      name = ARGV.shift
      if !name
        logger.fatal "Package name is missing."
        help
        return
      end
      p = api.create_package target_proj, name, visibility: @visibility
      logger.info "New package has been created."
      puts format_package(p)
    end

    def update
      target_id = ARGV.shift
      args = {name: ARGV.shift}
      if @visibility
        args[:visibility] = @visibility
      end
      p = api.update_package target_proj, target_id, args
      logger.info "Package #{target_id} has been updated."
      puts format_package(p)
    end

    def delete
      target_id = ARGV.shift
      p = api.delete_package target_proj, target_id
      logger.info "Package #{target_id} has been deleted."
    end

  end
end; end; end
