module OSDN; module CLI; module Command
  class FrsBase < Base
    def run
      update_token
      process_options
      command = ARGV.shift || 'list'
      if !command || command.empty?
        logger.fatal "subcommand is missing."
        help
        return
      end
      if self.respond_to? command
        self.send command
      else
        logger.fatal "Invalid subcommand: #{command}"
        help
        return
      end
    end

    def process_options
      raise NotImplementedError
    end

    private
    def target_proj
      @target_proj and return @target_proj
      vars = load_variables
      vars.project && !vars.project.empty? and
        return vars.project
      logger.fatal "No target project is specified."
      exit
    end

    def target_package
      @target_package and return @target_package
      vars = load_variables
      vars.package_id && !vars.package_id.empty? and
        return vars.package_id
      logger.fatal "No target package is specified."
      exit
    end

    def target_release
      @target_release and return @target_release
      vars = load_variables
      vars.release_id && !vars.release_id.empty? and
        return vars.release_id
      logger.fatal "No target release is specified."
      exit
    end

    def api
      OSDNClient::ProjectApi.new
    end

    def format_object(o, children = nil)
      if format == 'json'
        o.to_hash.to_json
      else
        children_str = ''
        children and
          children_str = ", #{[*o.send(children)].count} #{children}"
        "##{o.id} #{o.name} (#{o.visibility}#{children_str})\n  #{o.url}"
       end
    end
    
    def format_release(r)
      format_object(r, :files)
    end

    def format_package(p)
      format_object(p, :releases)
    end

    def format_file(f)
      format_object(f)
    end
  end
end; end; end
