package portablesimulator.skillset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SkillCategories {

    private ArrayList<SkillKind> listKind = new ArrayList<SkillKind>();
    private Map<String, List<SkillPoint>> mapCategory = new LinkedHashMap<String, List<SkillPoint>>();
    private String DEFAULT_NAME = "JeSȂ";

    public SkillCategories() {
        mapCategory.put(DEFAULT_NAME, new ArrayList<SkillPoint>());
    }

    public SkillPoint getNearSkillPoint(SkillPoint point) {
        SkillPoint found = null;
        for (List<SkillPoint> listPoint : mapCategory.values()) {
            for (SkillPoint seek : listPoint) {
                if (seek.skillPoint % 5 != 0) {
                    continue;
                }
                if (seek.skillKind == point.skillKind) {
                    if (point.skillPoint >= 0) {
                        if (point.skillPoint >= seek.skillPoint && seek.skillPoint >= 0) {
                            if (found == null || found.skillPoint < seek.skillPoint) {
                                found = seek;
                            }
                        }
                    } else {
                        if (point.skillPoint <= seek.skillPoint && seek.skillPoint <= 0) {
                            if (found == null || found.skillPoint > seek.skillPoint) {
                                found = seek;
                            }
                        }
                    }
                }
            }
        }
        return found;
    }

    public SkillPoint getMatchSkillPoint(SkillPoint point) {
        SkillPoint found = null;
        for (List<SkillPoint> listPoint : mapCategory.values()) {
            for (SkillPoint seek : listPoint) {
                if (seek.skillKind == point.skillKind) {
                    if (seek.skillPoint == point.skillPoint) {
                        return seek;
                    }
                }
            }
        }
        return null;
    }

    public List<SkillPoint> listPoints() {
        List<SkillPoint> result = new ArrayList<SkillPoint>();
        for (List<SkillPoint> listPoint : mapCategory.values()) {
            result.addAll(listPoint);
        }
        return result;
    }

    public SkillPoint findPointByFixedName(String name) {
        for (List<SkillPoint> listPoint : mapCategory.values()) {
            for (SkillPoint pt : listPoint) {
                if (pt.pointName != null && pt.pointName.equals(name)) {
                    return pt;
                }
            }
        }
        return null;
    }

    public void addPoint(SkillPoint point) {
        List<SkillPoint> list = mapCategory.get(DEFAULT_NAME);
        list.add(point);
    }

    public List<SkillPoint> addCategory(String categoryName) {
        List<SkillPoint> ret = mapCategory.get(categoryName);
        if (ret == null) {
            ret = new ArrayList<SkillPoint>(9);
            mapCategory.put(categoryName, ret);
        }
        return ret;
    }

    public Collection<String> listCategoryNames() {
        Set<String> result = new LinkedHashSet<String>(mapCategory.keySet());
        result.remove(DEFAULT_NAME);
        result.add(DEFAULT_NAME);
        return result;
    }

    public List<SkillKind> listupKindOrdered() {
        List<SkillKind> result = new ArrayList<SkillKind>();
        for (String categoryName : listCategoryNames()) {
            List<SkillPoint> pointList = listPointByCategory(categoryName);

            for (int i = 0; i < pointList.size(); ++i) {
                SkillKind kind = pointList.get(i).skillKind;
                if (result.contains(kind)) {
                    continue;
                }
                result.add(kind);
            }
        }
        return result;
    }

    public List<SkillPoint> listPointByCategory(String categoryName) {
        final List<SkillPoint> oldList = mapCategory.get(categoryName);
        List<SkillPoint> result = new ArrayList<SkillPoint>(oldList);

        Collections.sort(result, new Comparator<SkillPoint>() {

            public int compare(SkillPoint p1, SkillPoint p2) {
                if (p1.skillPoint < 0 && p2.skillPoint >= 0) {
                    return 1;
                }
                if (p2.skillPoint < 0 && p1.skillPoint >= 0) {
                    return -1;
                }

                if (p1.skillKind != p2.skillKind) {
                    int x1 = oldList.indexOf(p1);
                    int x2 = oldList.indexOf(p2);
                    if (x1 < x2) {
                        return -1;
                    }
                    if (x1 > x2) {
                        return 1;
                    }
                }

                if (p1.skillPoint > p2.skillPoint) {
                    return -1;
                }
                if (p1.skillPoint < p2.skillPoint) {
                    return 1;
                }

                if (p1.positiveRange != p2.positiveRange) {
                    if (p1.positiveRange) {
                        return 1;
                    }
                    return -1;
                }

                return 0;
            }
        });

        return result;
    }

    public String pointNameToCategory(String pointName) {
        for (String cate : mapCategory.keySet()) {
            List<SkillPoint> listPoint = mapCategory.get(cate);
            for (int i = 0; i < listPoint.size(); ++i) {
                SkillPoint pt = listPoint.get(i);
                if (pt.pointName.equals(pointName)) {
                    return cate;
                }
            }
        }
        return null;
    }

    public SkillPoint pointNameToPoint(String pointName) {
        for (String cate : mapCategory.keySet()) {
            List<SkillPoint> listPoint = mapCategory.get(cate);
            for (int i = 0; i < listPoint.size(); ++i) {
                SkillPoint pt = listPoint.get(i);
                if (pt.pointName.equals(pointName)) {
                    return pt;
                }
            }
        }
        return null;
    }

    public void setCategory(String categoryName, String pointName) {
        SkillPoint pt = pointNameToPoint(pointName);
        String cate = pointNameToCategory(pointName);

        if (pt == null || cate == null) {
            return;
        }

        List<SkillPoint> oldList = mapCategory.get(cate);

        if (cate.equals(categoryName)) {
            return;
        }

        List<SkillPoint> newList = mapCategory.get(categoryName);
        if (newList == null) {
            newList = addCategory(categoryName);
        }

        if (cate.equals(DEFAULT_NAME)) {
            for (int i = 0; i < oldList.size(); ++i) {
                SkillPoint old = oldList.get(i);
                if (pt.skillKind == old.skillKind) {
                    oldList.remove(i);
                    i--;
                    newList.add(old);
                }
            }
        } else {
            oldList.remove(pt);
            newList.add(pt);
        }
    }

    public SkillKind findKindByName(String name) {
        int i = indexOfKind(name);
        if (i >= 0) {
            return listKind.get(i);
        }
        return null;
    }

    public int indexOfKind(String name) {
        for (int i = 0; i < listKind.size(); ++i) {
            if (name.equals(listKind.get(i).name)) {
                return i;
            }
        }
        return -1;
    }

    public void addSkillKind(SkillKind sk) {
        int i = indexOfKind(sk.name);
        if (i >= 0) {
            listKind.set(i, sk);
        } else {
            listKind.add(sk);
        }
    }

    public List<SkillKind> listupKind() {
        return listKind;
    }
}
